/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.exception.BuilderException;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;

public abstract class ExportBuilder {
    protected String builderType = "UNKNOWN";
    protected OutputStream outputStream = null;
    protected String[] exportScript = null;
    protected int scriptCursor = 0;
    protected int[] scriptNesting = null;
    protected int nestingDepth = 0;
    protected int[] nestingScore = null;
    protected int logicalRecordLength = 0;
    protected int physicalRecordLength = 0;
    protected int logicalPerPhysical = 0;
    protected int logicalRecordCount = 0;
    protected Vector logicalRecords = null;
    protected Vector exportMold = null;
    protected byte recordPadding = 0;
    protected boolean vaxOrder = false;
    protected boolean endOfGroup = true;
    protected boolean endOfLogical = false;
    protected boolean endOfPhysical = false;
    protected boolean penDown = true;
    protected LogicalRecord logicalRecord = null;

    public ExportBuilder() {
    }

    public ExportBuilder(OutputStream outStream) throws BuilderException {
        this();
        this.open(outStream);
    }

    public String getType() throws BuilderException {
        if (this.builderType.equals("UNKNOWN")) {
            throw new BuilderException("builder type is UNKNOWN");
        }
        return this.builderType;
    }

    public void open(OutputStream outStream) throws BuilderException {
        if (outStream == null) {
            throw new BuilderException("attempted to open null OutputStream reference");
        }
        this.outputStream = outStream;
    }

    public void close() {
        this.outputStream = null;
    }

    public void setLogicalRecLen(int len) {
        this.logicalRecordLength = len;
        if (this.physicalRecordLength < this.logicalRecordLength) {
            this.physicalRecordLength = this.logicalRecordLength;
        }
    }

    public void setPhysicalRecLen(int len) {
        this.physicalRecordLength = len;
        if (this.physicalRecordLength < this.logicalRecordLength) {
            this.logicalRecordLength = this.physicalRecordLength;
        }
    }

    public void setVaxOrder(boolean flag) {
        this.vaxOrder = flag;
    }

    public void startVolume() throws BuilderException {
        if (this.logicalRecordLength <= 0) {
            throw new BuilderException("invalid logical record length: " + this.logicalRecordLength);
        }
        if (this.physicalRecordLength <= 0) {
            throw new BuilderException("invalid physical record length: " + this.physicalRecordLength);
        }
        int i = 0;
        while (i * this.logicalRecordLength < this.physicalRecordLength) {
            ++i;
        }
        if (i * this.logicalRecordLength > this.physicalRecordLength) {
            throw new BuilderException("physicalRecordLength (" + this.physicalRecordLength + ") not a multiple of logicalRecordLength (" + this.logicalRecordLength + ")");
        }
        this.logicalPerPhysical = this.physicalRecordLength / this.logicalRecordLength;
        this.logicalRecords = new Vector(8, 8);
        this.scriptCursor = 0;
        this.nestingDepth = 0;
    }

    public int getNext() throws Exception {
        boolean searching = true;
        String scriptElem = null;
        while (searching) {
            if (this.scriptCursor == this.exportScript.length) {
                return -1;
            }
            scriptElem = this.exportScript[this.scriptCursor];
            if (scriptElem.equals("(")) {
                ++this.nestingDepth;
                if (this.scriptNesting.length == this.nestingDepth + 1) {
                    throw new BuilderException("scriptNesting array not allocated enough space");
                }
                if (this.nestingScore.length == this.nestingDepth + 1) {
                    throw new BuilderException("nestingScore array not allocated enough space");
                }
                this.scriptNesting[this.nestingDepth] = ++this.scriptCursor;
                this.nestingScore[this.nestingDepth] = 0;
                continue;
            }
            if (scriptElem.equals(")")) {
                if (this.nestingScore[this.nestingDepth] == 0) {
                    --this.nestingDepth;
                    ++this.scriptCursor;
                    continue;
                }
                int n = this.nestingDepth - 1;
                this.nestingScore[n] = this.nestingScore[n] + this.nestingScore[this.nestingDepth];
                this.nestingScore[this.nestingDepth] = 0;
                this.scriptCursor = this.scriptNesting[this.nestingDepth];
                continue;
            }
            if (scriptElem.equals("[")) {
                ++this.scriptCursor;
                this.endOfGroup = false;
                continue;
            }
            if (scriptElem.equals("]")) {
                ++this.scriptCursor;
                this.endOfGroup = true;
                this.push(null);
                continue;
            }
            if (scriptElem.equals("<")) {
                ++this.scriptCursor;
                this.endOfLogical = true;
                this.push(null);
                continue;
            }
            if (scriptElem.equals("<<")) {
                ++this.scriptCursor;
                this.endOfPhysical = true;
                this.push(null);
                continue;
            }
            if (scriptElem.equals("^")) {
                ++this.scriptCursor;
                if (this.logicalRecord != null) {
                    this.padLogical();
                }
                while (this.writeRecord()) {
                }
                this.penDown = false;
                continue;
            }
            if (scriptElem.equals("v")) {
                ++this.scriptCursor;
                if (this.logicalRecord != null) {
                    this.padLogical();
                }
                while (this.writeRecord()) {
                }
                this.penDown = true;
                continue;
            }
            if (this.checkTrigger(scriptElem)) {
                ++this.scriptCursor;
                continue;
            }
            ++this.scriptCursor;
            searching = false;
        }
        return Integer.parseInt(scriptElem);
    }

    public int build(Object obj) throws Exception {
        if (obj == null) {
            return 0;
        }
        int n = this.nestingDepth;
        this.nestingScore[n] = this.nestingScore[n] + 1;
        int oldRecordCount = this.logicalRecordCount;
        this.push(obj);
        if (this.penDown) {
            return this.logicalRecordCount - oldRecordCount;
        }
        return 0;
    }

    public void finish() throws Exception {
        this.volumeFinish();
        if (this.logicalRecord != null) {
            this.padLogical();
        }
        while (this.writeRecord()) {
        }
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    protected void push(Object obj) throws Exception {
        if (obj != null) {
            this.exportMold.add(obj);
        }
        if (!this.endOfGroup) {
            return;
        }
        if (this.endOfLogical) {
            this.padLogical();
        } else {
            this.packToRecord();
        }
        this.endOfLogical = false;
        if (this.logicalRecords.size() > this.logicalPerPhysical || this.endOfPhysical) {
            this.writeRecord();
            this.endOfPhysical = false;
        }
    }

    protected boolean writeRecord() throws Exception {
        this.padPhysical();
        int logRecCount = this.logicalRecords.size();
        if (logRecCount == 0) {
            return false;
        }
        if (this.outputStream == null && this.penDown) {
            throw new BuilderException("no open OutputStream available...");
        }
        byte[] outputRecord = null;
        int i = 0;
        while (i < this.logicalPerPhysical && i < logRecCount) {
            if (this.penDown) {
                outputRecord = ((LogicalRecord)this.logicalRecords.get((int)i)).contents;
                this.outputStream.write(outputRecord);
            }
            ++i;
        }
        List subList = this.logicalRecords.subList(i, logRecCount);
        this.logicalRecords = new Vector(subList);
        logRecCount = this.logicalRecords.size();
        return logRecCount > 0;
    }

    protected void padLogical() {
        if (this.logicalRecord == null) {
            return;
        }
        int i = this.logicalRecord.position;
        while (i < this.logicalRecordLength) {
            this.logicalRecord.contents[i] = this.recordPadding;
            ++i;
        }
        this.logicalRecord.position = this.logicalRecordLength;
        this.logicalRecords.add(this.logicalRecord);
        ++this.logicalRecordCount;
        this.logicalRecord = null;
    }

    protected void padPhysical() throws Exception {
        if (this.logicalRecords.size() == 0 && this.logicalRecord == null) {
            return;
        }
        boolean padded = false;
        while (this.logicalPerPhysical > this.logicalRecords.size()) {
            padded = true;
            this.padLogical();
            this.startNewLogical(null, false);
        }
        if (padded) {
            this.logicalRecord = null;
        }
    }

    protected abstract void packToRecord() throws Exception;

    protected abstract boolean checkTrigger(String var1) throws Exception;

    protected abstract void volumeFinish() throws BuilderException;

    protected abstract void startNewLogical(SeedObject var1, boolean var2) throws Exception;

    protected class LogicalRecord {
        public int position = 0;
        public byte[] contents;

        public LogicalRecord() {
            this.contents = new byte[ExportBuilder.this.logicalRecordLength];
        }
    }
}

