/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.GroupNode;
import gov.usgs.winston.Instrument;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class Channels {
    private WinstonDatabase winston;

    public Channels(WinstonDatabase w) {
        this.winston = w;
    }

    public Map<Integer, GroupNode> getGroupNodes() {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            HashMap<Integer, GroupNode> result = new HashMap<Integer, GroupNode>();
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT * FROM groupnodes");
            while (rs.next()) {
                GroupNode gn = new GroupNode(rs);
                result.put(gn.nid, gn);
            }
            GroupNode.buildTree(result);
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get groups.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public List<Channel> getChannels() {
        return this.getChannels(false);
    }

    public List<Channel> getChannels(boolean fullMetadata) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT sid, instruments.iid, code, alias, unit, linearA, linearB, st, et, instruments.lon, instruments.lat, height, name, description, timezone FROM channels LEFT JOIN instruments ON channels.iid=instruments.iid ORDER BY code ASC");
            HashMap<Integer, Channel> channelsMap = new HashMap<Integer, Channel>();
            ArrayList<Channel> channels = new ArrayList<Channel>();
            while (rs.next()) {
                Channel ch = new Channel(rs);
                channelsMap.put(ch.getSID(), ch);
                channels.add(ch);
            }
            rs.close();
            Map<Integer, GroupNode> nodes = this.getGroupNodes();
            rs = this.winston.executeQuery("SELECT sid, nid FROM grouplinks");
            while (rs.next()) {
                GroupNode gn;
                int sid = rs.getInt(1);
                int nid = rs.getInt(2);
                Channel ch = (Channel)channelsMap.get(sid);
                if (ch == null || (gn = nodes.get(nid)) == null) continue;
                ch.addGroup(gn.toString());
            }
            rs.close();
            if (fullMetadata) {
                PreparedStatement ps = this.winston.getPreparedStatement("SELECT * FROM channelmetadata WHERE sid=? ORDER BY name ASC");
                for (Channel ch : channels) {
                    HashMap<String, String> md = null;
                    ps.setInt(1, ch.getSID());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        if (md == null) {
                            md = new HashMap<String, String>();
                        }
                        md.put(rs.getString("name"), rs.getString("value"));
                    }
                    ch.setMetadata(md);
                }
            }
            return channels;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channels.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public int getChannelID(String code) {
        if (!this.winston.checkConnect()) {
            return -1;
        }
        try {
            int result = -1;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT sid FROM channels WHERE code='" + code + "'");
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channel ID.", e);
            return -1;
        }
    }

    public String getChannelCode(int sid) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            String result = null;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT code FROM channels WHERE sid=" + sid);
            if (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channel code.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public boolean channelExists(String code) {
        if (!this.winston.checkConnect()) {
            return false;
        }
        try {
            boolean result = false;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT sid FROM channels WHERE code='" + code + "'");
            result = rs.next();
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not determine channel existence.", Util.getLineNumber(this, e));
            return false;
        }
    }

    public boolean createChannel(String code) {
        if (!this.winston.checkConnect()) {
            return false;
        }
        try {
            this.winston.useRootDatabase();
            this.winston.getStatement().execute("INSERT INTO channels (code, st, et) VALUES ('" + code + "', 1E300, -1E300)");
            this.winston.getStatement().execute("CREATE DATABASE " + this.winston.getDatabasePrefix() + "_" + code);
            this.winston.getStatement().execute("USE " + this.winston.getDatabasePrefix() + "_" + code);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not create channel.  Are permissions set properly?", Util.getLineNumber(this, e));
        }
        return false;
    }

    public List<Instrument> getInstruments() {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT * FROM instruments ORDER BY name ASC");
            ArrayList<Instrument> insts = new ArrayList<Instrument>();
            while (rs.next()) {
                Instrument inst = new Instrument(rs);
                insts.add(inst);
            }
            rs.close();
            PreparedStatement ps = this.winston.getPreparedStatement("SELECT * FROM instrumentmetadata WHERE iid=? ORDER BY name ASC");
            for (Instrument inst : insts) {
                HashMap<String, String> md = null;
                ps.setInt(1, inst.getID());
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (md == null) {
                        md = new HashMap<String, String>();
                    }
                    md.put(rs.getString("name"), rs.getString("value"));
                }
                inst.setMetadata(md);
            }
            return insts;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get instruments.", Util.getLineNumber(this, e));
            return null;
        }
    }
}

