/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.wave.plot;

import gov.usgs.plot.AxisRenderer;
import gov.usgs.plot.DefaultFrameDecorator;
import gov.usgs.plot.FrameDecorator;
import gov.usgs.plot.ImageDataRenderer;
import gov.usgs.plot.Jet;
import gov.usgs.plot.Spectrum;
import gov.usgs.vdx.data.wave.SliceWave;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class SpectrogramRenderer
extends ImageDataRenderer {
    private static final int[] SAMPLE_SIZES = new int[]{64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private String fftSize = "Auto";
    protected int hTicks = -1;
    protected int vTicks = -1;
    protected boolean logPower = false;
    protected boolean logFreq = false;
    protected boolean autoScale = true;
    protected double minFreq = 0.75;
    protected double maxFreq = 20.0;
    protected double maxPower = -1.7976931348623157E308;
    protected double viewStartTime;
    protected double viewEndTime;
    protected double overlap = 0.2;
    protected double xLabel;
    protected double yLabel;
    protected byte[] imgBuffer;
    protected Spectrum spectrum;
    protected AxisRenderer axis = new AxisRenderer(this);
    protected MemoryImageSource mis;
    protected Image im;
    protected SliceWave wave;
    protected double timeZoneOffset;
    protected FrameDecorator decorator;
    protected String channelTitle;

    public SpectrogramRenderer() {
        this.imgBuffer = new byte[64000];
        this.spectrum = Jet.getInstance();
    }

    public SpectrogramRenderer(SliceWave w) {
        this();
        this.wave = w;
    }

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void createDefaultFrameDecorator() {
        this.decorator = new DefaultWaveFrameDecorator();
    }

    public void setTitle(String t) {
        this.channelTitle = t;
    }

    public double update(double oldMaxPower) {
        if (this.decorator == null) {
            this.createDefaultFrameDecorator();
        }
        this.wave.setSlice(this.viewStartTime, this.viewEndTime);
        int sampleSize = 128;
        if (this.fftSize.toLowerCase().equals("auto")) {
            double bestFit = 1.0E300;
            int bestIndex = -1;
            int i = 0;
            while (i < SAMPLE_SIZES.length) {
                double ys;
                double xs = (double)this.wave.samples() / (double)SAMPLE_SIZES[i];
                double ar = xs / (ys = (double)SAMPLE_SIZES[i] / 2.0);
                double fit = Math.abs(ar - 1.0);
                if (fit < bestFit) {
                    bestFit = fit;
                    bestIndex = i;
                }
                ++i;
            }
            sampleSize = SAMPLE_SIZES[bestIndex];
        } else {
            sampleSize = Integer.parseInt(this.fftSize);
        }
        int imgXSize = this.wave.samples() / sampleSize;
        int imgYSize = sampleSize / 4;
        if (imgXSize <= 0 || imgYSize <= 0) {
            return -1.0;
        }
        double minF = this.minFreq;
        double maxF = this.maxFreq;
        double maxMag = -1.0E300;
        double[][] powerBuffer = this.wave.toSpectrogram(sampleSize, this.logPower, this.logFreq, this.overlap);
        imgYSize = powerBuffer[0].length;
        imgXSize = powerBuffer.length;
        int i = 0;
        while (i < imgXSize) {
            int j = 0;
            while (j < imgYSize) {
                double f = (double)j / (double)imgYSize * this.wave.getSamplingRate() / 2.0;
                double mag = powerBuffer[i][j];
                if (f >= minF && f <= maxF && mag > maxMag) {
                    maxMag = mag;
                }
                ++j;
            }
            ++i;
        }
        if (this.autoScale) {
            if (this.logPower) {
                maxMag = Math.pow(10.0, maxMag);
            }
            maxMag = Math.max(maxMag, oldMaxPower);
        } else {
            maxMag = this.maxPower;
        }
        if (this.logPower) {
            maxMag = Math.log(maxMag) / Math.log(10.0);
        }
        if (this.imgBuffer.length < imgXSize * imgYSize) {
            this.imgBuffer = new byte[imgXSize * imgYSize];
        }
        double logMinMag = maxMag - 3.0;
        int i2 = 0;
        while (i2 < imgXSize) {
            int j = imgYSize - 1;
            int k = 0;
            while (j >= 0) {
                double ratio;
                double d = ratio = this.logPower ? (powerBuffer[i2][j] - logMinMag) / (maxMag - logMinMag) : powerBuffer[i2][j] / maxMag;
                if (ratio < 0.0) {
                    ratio = 0.0;
                }
                if (ratio > 1.0) {
                    ratio = 1.0;
                }
                this.imgBuffer[i2 + imgXSize * k] = (byte)(this.spectrum.getColorIndexByRatio(ratio) + 9);
                --j;
                ++k;
            }
            ++i2;
        }
        if (this.mis == null || this.im.getWidth(null) != imgXSize || this.im.getHeight(null) != imgYSize) {
            this.mis = new MemoryImageSource(imgXSize, imgYSize, (ColorModel)this.spectrum.palette, this.imgBuffer, 0, imgXSize);
        }
        this.im = Toolkit.getDefaultToolkit().createImage(this.mis);
        this.setImage(this.im);
        this.setDataExtents(this.wave.getStartTime() + this.timeZoneOffset, this.wave.getEndTime() + this.timeZoneOffset, 0.0, this.wave.getSamplingRate() / 2.0);
        this.setExtents(this.viewStartTime + this.timeZoneOffset, this.viewEndTime + this.timeZoneOffset, minF, maxF);
        this.decorator.decorate(this);
        return maxMag;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public void setFftSize(String fftSize) {
        this.fftSize = fftSize;
    }

    public void setLogFreq(boolean logFreq) {
        this.logFreq = logFreq;
    }

    public void setLogPower(boolean logPower) {
        this.logPower = logPower;
    }

    public void setMaxFreq(double maxFreq) {
        this.maxFreq = maxFreq;
    }

    public void setMaxPower(double maxPower) {
        this.maxPower = maxPower;
    }

    public void setMinFreq(double minFreq) {
        this.minFreq = minFreq;
    }

    public void setOverlap(double overlap) {
        this.overlap = overlap;
    }

    public void setViewEndTime(double viewEndTime) {
        this.viewEndTime = viewEndTime;
    }

    public void setViewStartTime(double viewStartTime) {
        this.viewStartTime = viewStartTime;
    }

    public void setWave(SliceWave wave) {
        this.wave = wave;
    }

    public void setHTicks(int ticks) {
        this.hTicks = ticks;
    }

    public void setVTicks(int ticks) {
        this.vTicks = ticks;
    }

    public void setTimeZoneOffset(double tzo) {
        this.timeZoneOffset = tzo;
    }

    public void setYLabel(int i) {
        this.yLabel = i;
    }

    public void setYAxisLabel(String s) {
        if (this.decorator instanceof DefaultWaveFrameDecorator) {
            ((DefaultWaveFrameDecorator)this.decorator).setYAxisLabel(s);
        }
    }

    public void setXLabel(int i) {
        this.xLabel = i;
    }

    protected class DefaultWaveFrameDecorator
    extends DefaultFrameDecorator {
        public DefaultWaveFrameDecorator() {
            this.yAxisLabel = "Frequency (Hz)";
            this.title = SpectrogramRenderer.this.channelTitle;
            this.titleBackground = Color.WHITE;
        }

        public void setYAxisLabel(String s) {
            this.yAxisLabel = s;
        }
    }
}

