/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import gov.usgs.math.Butterworth;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewSettingsToolbar;
import gov.usgs.util.ConfigFile;

public class WaveViewSettings {
    public static final String DEFAULTS_FILENAME = "WaveDefaults.config";
    public ViewType viewType;
    public Butterworth filter;
    public boolean filterOn;
    public boolean zeroPhaseShift;
    public boolean autoScaleAmp;
    public boolean autoScaleAmpMemory;
    public double maxAmp;
    public double minAmp;
    public boolean autoScalePower;
    public boolean autoScalePowerMemory;
    public double maxPower;
    public boolean removeBias;
    public boolean useUnits;
    public boolean logFreq;
    public boolean logPower;
    public double minFreq;
    public double maxFreq;
    public String fftSize;
    public double spectrogramOverlap;
    public WaveViewPanel view;
    public WaveViewSettingsToolbar toolbar;
    private static WaveViewSettings DEFAULT_WAVE_VIEW_SETTINGS = new WaveViewSettings();

    static {
        ConfigFile cf = new ConfigFile(DEFAULTS_FILENAME);
        if (cf.wasSuccessfullyRead()) {
            ConfigFile sub = cf.getSubConfig("default");
            DEFAULT_WAVE_VIEW_SETTINGS.set(sub);
        } else {
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.viewType = ViewType.WAVE;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.removeBias = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScaleAmp = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScaleAmpMemory = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxAmp = 1000.0;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minAmp = -1000.0;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScalePower = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScalePowerMemory = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxPower = 40000.0;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.useUnits = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.logFreq = false;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.logPower = true;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.spectrogramOverlap = 0.2;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minFreq = 0.75;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxFreq = 25.0;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.fftSize = "Auto";
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.filter = new Butterworth();
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.filterOn = false;
            WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.zeroPhaseShift = true;
            DEFAULT_WAVE_VIEW_SETTINGS.save(cf, "default");
            cf.writeToFile(DEFAULTS_FILENAME);
        }
    }

    public WaveViewSettings() {
        this.filter = new Butterworth();
        this.view = null;
        if (DEFAULT_WAVE_VIEW_SETTINGS != null) {
            this.copy(DEFAULT_WAVE_VIEW_SETTINGS);
        }
    }

    public WaveViewSettings(WaveViewSettings s) {
        this.copy(s);
    }

    public void copy(WaveViewSettings s) {
        this.viewType = s.viewType;
        this.removeBias = s.removeBias;
        this.autoScaleAmp = s.autoScaleAmp;
        this.autoScaleAmpMemory = s.autoScaleAmpMemory;
        this.maxAmp = s.maxAmp;
        this.minAmp = s.minAmp;
        this.autoScalePowerMemory = s.autoScalePowerMemory;
        this.autoScalePower = s.autoScalePower;
        this.maxPower = s.maxPower;
        this.filter = new Butterworth(s.filter);
        this.useUnits = s.useUnits;
        this.logFreq = s.logFreq;
        this.minFreq = s.minFreq;
        this.maxFreq = s.maxFreq;
        this.fftSize = s.fftSize;
        this.spectrogramOverlap = s.spectrogramOverlap;
        this.logPower = s.logPower;
        this.zeroPhaseShift = s.zeroPhaseShift;
        this.filterOn = s.filterOn;
    }

    public void set(ConfigFile cf) {
        this.viewType = ViewType.fromString(cf.getString("viewType"));
        this.filter.set(cf.getSubConfig("filter"));
        this.maxAmp = Double.parseDouble(cf.getString("maxAmp"));
        this.minAmp = Double.parseDouble(cf.getString("minAmp"));
        this.maxPower = Double.parseDouble(cf.getString("maxPower"));
        this.minFreq = Double.parseDouble(cf.getString("minFreq"));
        this.maxFreq = Double.parseDouble(cf.getString("maxFreq"));
        this.spectrogramOverlap = Double.parseDouble(cf.getString("spectrogramOverlap"));
        this.removeBias = Boolean.parseBoolean(cf.getString("removeBias"));
        this.filterOn = Boolean.parseBoolean(cf.getString("filterOn"));
        this.zeroPhaseShift = Boolean.parseBoolean(cf.getString("zeroPhaseShift"));
        this.autoScaleAmp = Boolean.parseBoolean(cf.getString("autoScaleAmp"));
        this.autoScaleAmpMemory = Boolean.parseBoolean(cf.getString("autoScaleAmpMemory"));
        this.autoScalePower = Boolean.parseBoolean(cf.getString("autoScalePower"));
        this.autoScalePowerMemory = Boolean.parseBoolean(cf.getString("autoScalePowerMemory"));
        this.useUnits = Boolean.parseBoolean(cf.getString("useUnits"));
        this.logFreq = Boolean.parseBoolean(cf.getString("logFreq"));
        this.logPower = Boolean.parseBoolean(cf.getString("logPower"));
        this.fftSize = cf.getString("fftSize");
    }

    public void save(ConfigFile cf, String prefix) {
        cf.put(String.valueOf(prefix) + ".viewType", this.viewType.code);
        this.filter.save(cf, String.valueOf(prefix) + ".filter");
        cf.put(String.valueOf(prefix) + ".maxAmp", Double.toString(this.maxAmp));
        cf.put(String.valueOf(prefix) + ".minAmp", Double.toString(this.minAmp));
        cf.put(String.valueOf(prefix) + ".maxPower", Double.toString(this.maxPower));
        cf.put(String.valueOf(prefix) + ".minFreq", Double.toString(this.minFreq));
        cf.put(String.valueOf(prefix) + ".maxFreq", Double.toString(this.maxFreq));
        cf.put(String.valueOf(prefix) + ".spectrogramOverlap", Double.toString(this.spectrogramOverlap));
        cf.put(String.valueOf(prefix) + ".removeBias", Boolean.toString(this.removeBias));
        cf.put(String.valueOf(prefix) + ".filterOn", Boolean.toString(this.filterOn));
        cf.put(String.valueOf(prefix) + ".zeroPhaseShift", Boolean.toString(this.zeroPhaseShift));
        cf.put(String.valueOf(prefix) + ".autoScaleAmp", Boolean.toString(this.autoScaleAmp));
        cf.put(String.valueOf(prefix) + ".autoScaleAmpMemory", Boolean.toString(this.autoScaleAmpMemory));
        cf.put(String.valueOf(prefix) + ".autoScalePower", Boolean.toString(this.autoScalePower));
        cf.put(String.valueOf(prefix) + ".autoScalePowerMemory", Boolean.toString(this.autoScalePowerMemory));
        cf.put(String.valueOf(prefix) + ".useUnits", Boolean.toString(this.useUnits));
        cf.put(String.valueOf(prefix) + ".logFreq", Boolean.toString(this.logFreq));
        cf.put(String.valueOf(prefix) + ".logPower", Boolean.toString(this.logPower));
        cf.put(String.valueOf(prefix) + ".fftSize", this.fftSize);
    }

    public void setType(ViewType t) {
        this.viewType = t;
        this.notifyView();
    }

    public void cycleType() {
        switch (this.viewType) {
            case WAVE: {
                this.viewType = ViewType.SPECTRA;
                break;
            }
            case SPECTRA: {
                this.viewType = ViewType.SPECTROGRAM;
                break;
            }
            case SPECTROGRAM: {
                this.viewType = ViewType.WAVE;
            }
        }
        this.notifyView();
    }

    public void cycleLogSettings() {
        if (this.logFreq && this.logPower) {
            this.logFreq = false;
            this.logPower = false;
        } else if (this.logFreq) {
            this.logFreq = true;
            this.logPower = true;
        } else if (this.logPower) {
            this.logFreq = true;
            this.logPower = false;
        } else {
            this.logPower = true;
        }
        this.notifyView();
    }

    public void toggleLogFreq() {
        this.logFreq = !this.logFreq;
        this.notifyView();
    }

    public void toggleLogPower() {
        this.logPower = !this.logPower;
        this.notifyView();
    }

    public void toggleFilter() {
        this.filterOn = !this.filterOn;
        this.notifyView();
    }

    public void resetAutoScaleMemory() {
        if (this.view != null) {
            this.view.resetAutoScaleMemory();
        }
    }

    public void adjustScale(double pct) {
        if (this.view != null) {
            this.view.adjustScale(pct);
        }
    }

    public void notifyView() {
        if (this.view != null) {
            this.view.settingsChanged();
        }
        if (this.toolbar != null) {
            this.toolbar.settingsChanged();
        }
    }

    public static enum ViewType {
        WAVE("W"),
        SPECTRA("S"),
        SPECTROGRAM("G");

        public String code;

        private ViewType(String c) {
            this.code = c;
        }

        public static ViewType fromString(String c) {
            if (c.equals("S")) {
                return SPECTRA;
            }
            if (c.equals("G")) {
                return SPECTROGRAM;
            }
            return WAVE;
        }
    }
}

