/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.SAC;
import gov.usgs.vdx.data.wave.Wave;
import java.util.ArrayList;
import java.util.List;

public class SACDataSource
extends SeismicDataSource {
    private String station;
    private Wave wave;
    private String filename;

    public SACDataSource(String fn) {
        try {
            this.filename = fn;
            SAC sac = new SAC();
            sac.read(fn);
            this.station = sac.getStationInfo();
            this.wave = sac.toWave();
            Swarm.getCache().cacheWaveAsHelicorder(this.station, this.wave);
            Swarm.getCache().putWave(this.station, this.wave);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        double dt = t2 - t1;
        double now = CurrentTime.getInstance().nowJ2K();
        if (Math.abs(now - t2) < 3600.0) {
            t2 = this.wave.getEndTime();
            t1 = t2 - dt;
        }
        return Swarm.getCache().getHelicorder(station, t1, t2, gl);
    }

    @Override
    public List<String> getChannels() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.station);
        return list;
    }

    @Override
    public Wave getWave(String station, double t1, double t2) {
        return Swarm.getCache().getBestWave(station, t1, t2);
    }

    @Override
    public String toConfigString() {
        return String.valueOf(this.name) + ";sac:" + this.filename;
    }
}

