/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.swarm.data.Gulper;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import java.util.HashMap;
import java.util.Map;

public class GulperList {
    private Map<String, Gulper> gulpers = new HashMap<String, Gulper>();
    private static GulperList gulperList;

    private GulperList() {
    }

    public static GulperList getInstance() {
        if (gulperList == null) {
            gulperList = new GulperList();
        }
        return gulperList;
    }

    public synchronized Gulper requestGulper(String key, GulperListener gl, SeismicDataSource source, String ch, double t1, double t2, int size, int delay) {
        Gulper g = this.gulpers.get(key);
        if (g != null) {
            g.addListener(gl);
            g.update(t1, t2);
        } else if (t2 - t1 < (double)size) {
            source.getWave(ch, t1, t2);
        } else {
            g = new Gulper(this, key, gl, source, ch, t1, t2, size, delay);
            this.gulpers.put(key, g);
        }
        return g;
    }

    public synchronized void killGulper(String key, GulperListener gl) {
        Gulper g = this.gulpers.get(key);
        if (g != null) {
            g.kill(gl);
        }
    }

    public synchronized void removeGulper(Gulper g) {
        this.gulpers.remove(g.getKey());
    }
}

