/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.GulperList;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.vdx.data.wave.Wave;
import java.util.HashSet;
import java.util.Set;

public class Gulper
extends Thread {
    private SeismicDataSource gulpSource;
    private GulperList gulperList;
    private String channel;
    private double lastTime;
    private double goalTime;
    private boolean killed;
    private String key;
    private Set<GulperListener> listeners;
    private int gulpSize;
    private int gulpDelay;

    public Gulper(GulperList gl, String k, GulperListener glnr, SeismicDataSource source, String ch, double t1, double t2, int size, int delay) {
        this.gulpSize = size;
        this.gulpDelay = delay;
        this.gulperList = gl;
        this.gulpSource = source;
        this.key = k;
        this.listeners = new HashSet<GulperListener>();
        this.addListener(glnr);
        this.channel = ch;
        this.lastTime = t2;
        double now = CurrentTime.getInstance().nowJ2K();
        if (this.lastTime > now) {
            this.lastTime = now;
        }
        this.update(t1, t2);
        this.start();
        Swarm.logger.finer("gulper started for " + this.channel);
    }

    public synchronized void addListener(GulperListener gl) {
        this.listeners.add(gl);
    }

    public synchronized void removeListener(GulperListener gl) {
        this.listeners.remove(gl);
    }

    public String getChannel() {
        return this.channel;
    }

    public String getKey() {
        return this.key;
    }

    public void kill(GulperListener gl) {
        this.removeListener(gl);
        if (this.listeners.size() == 0) {
            this.killed = true;
            this.interrupt();
        }
    }

    public void update(double t1, double t2) {
        CachedDataSource cache = Swarm.getCache();
        if (t2 < this.lastTime) {
            this.lastTime = t2;
        }
        this.goalTime = t1;
        while (cache.inHelicorderCache(this.channel, this.lastTime - (double)this.gulpSize, this.lastTime) && this.lastTime > this.goalTime && !this.killed) {
            this.lastTime -= (double)this.gulpSize;
            this.lastTime += 10.0;
        }
    }

    private synchronized void fireStarted() {
        for (GulperListener listener : this.listeners) {
            listener.gulperStarted();
        }
    }

    private synchronized void fireGulped(double t1, double t2, boolean success) {
        for (GulperListener listener : this.listeners) {
            listener.gulperGulped(t1, t2, success);
        }
    }

    private synchronized void fireStopped(boolean killed) {
        for (GulperListener listener : this.listeners) {
            listener.gulperStopped(killed);
        }
    }

    @Override
    public void run() {
        this.fireStarted();
        while (this.lastTime > this.goalTime && !this.killed) {
            try {
                double t1 = this.lastTime - (double)this.gulpSize;
                double t2 = this.lastTime;
                Wave w = this.gulpSource.getWave(this.channel, t1, t2);
                this.fireGulped(t1, t2, w != null && !this.killed);
                this.update(this.goalTime, this.lastTime - (double)this.gulpSize + 10.0);
            }
            catch (Throwable e) {
                System.err.println("Exception during gulp:");
                e.printStackTrace();
            }
            if (this.killed) continue;
            try {
                Thread.sleep(this.gulpDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.gulpSource.close();
        if (this.killed) {
            Swarm.logger.finest("gulper killed");
        } else {
            Swarm.logger.finest("gulper finished");
        }
        this.gulperList.removeGulper(this);
        this.fireStopped(this.killed);
    }

    @Override
    public String toString() {
        return this.channel;
    }
}

