/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.util.ArrayList;
import java.util.List;

public class DirectWWSSource
extends SeismicDataSource {
    private String dbDriver;
    private String dbURL;
    private String dbPrefix;
    private WinstonDatabase winston;
    private Data data;
    private Channels stations;

    public DirectWWSSource(String d, String u, String db) {
        this.dbDriver = d;
        this.dbURL = u;
        this.dbPrefix = db;
        this.winston = new WinstonDatabase(this.dbDriver, this.dbURL, this.dbPrefix);
        this.stations = new Channels(this.winston);
        this.data = new Data(this.winston);
    }

    @Override
    public void close() {
        this.winston.close();
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        CachedDataSource cache = Swarm.getCache();
        Wave sw = cache.getWave(station, t1, t2);
        if (sw == null) {
            sw = this.data.getWave(station, t1, t2);
            if (sw != null && !sw.isData()) {
                sw = null;
            }
            if (sw != null && sw.buffer != null && sw.buffer.length > 0) {
                cache.putWave(station, sw);
            }
        }
        return sw;
    }

    @Override
    public synchronized List<String> getChannels() {
        List<Channel> chs = this.stations.getChannels();
        ArrayList<String> result = new ArrayList<String>();
        for (Channel ch : chs) {
            result.add(ch.toString());
        }
        return result;
    }

    @Override
    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        CachedDataSource cache = Swarm.getCache();
        HelicorderData hd = cache.getHelicorder(station, t1, t2, this);
        if (hd == null) {
            hd = this.data.getHelicorderData(station, t1, t2);
            if (hd != null && hd.rows() != 0) {
                cache.putHelicorder(station, hd);
            } else {
                hd = null;
            }
        }
        return hd;
    }

    @Override
    public String toConfigString() {
        return "winston:";
    }
}

