/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.swarm.Images;
import gov.usgs.swarm.Swarm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class AboutDialog
extends JDialog
implements Runnable {
    private static final long serialVersionUID = -1L;
    private static final int WIDTH = 240;
    private static final int HEIGHT = 271;
    private JPanel mainPanel;
    private JLabel freeMemory;
    private JLabel totalMemory;
    private JLabel usedMemory;
    private JLabel maxMemory;
    private JLabel cacheMemory;
    private JButton gcButton;
    private ImageIcon background;
    private JButton okButton;
    private Thread updateThread;
    private boolean kill = false;

    public AboutDialog() {
        super(Swarm.getApplication(), "About", true);
        this.setSize(240, 271);
        Dimension parentSize = Swarm.getApplication().getSize();
        Point parentLoc = Swarm.getApplication().getLocation();
        this.setLocation(parentLoc.x + (parentSize.width / 2 - 120), parentLoc.y + (parentSize.height / 2 - 135));
        this.setResizable(false);
        this.background = Images.getIcon("honeycomb");
        JPanel bp = new JPanel(new BorderLayout());
        bp.add((Component)new JLabel(this.background), "Center");
        bp.setSize(237, 245);
        bp.setLocation(0, 0);
        this.getLayeredPane().add(bp);
        this.getLayeredPane().setLayer(bp, JLayeredPane.DEFAULT_LAYER);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(LineBorder.createBlackLineBorder());
        JPanel panel = new JPanel(new GridLayout(5, 2));
        panel.setBorder(new EmptyBorder(3, 6, 3, 6));
        panel.add(new JLabel("Free memory: "));
        this.freeMemory = new JLabel();
        panel.add(this.freeMemory);
        panel.add(new JLabel("Total memory: "));
        this.totalMemory = new JLabel();
        panel.add(this.totalMemory);
        panel.add(new JLabel("Used memory: "));
        this.usedMemory = new JLabel();
        panel.add(this.usedMemory);
        panel.add(new JLabel("Max memory: "));
        this.maxMemory = new JLabel();
        panel.add(this.maxMemory);
        panel.add(new JLabel("Cache size: "));
        this.cacheMemory = new JLabel();
        panel.add(this.cacheMemory);
        this.mainPanel.add((Component)panel, "Center");
        this.mainPanel.setSize(224, 100);
        this.mainPanel.setLocation(5, 94);
        panel.setBackground(new Color(255, 255, 0));
        this.mainPanel.setBackground(new Color(0, 0, 0, 0));
        this.getLayeredPane().add(this.mainPanel);
        this.getLayeredPane().setLayer(this.mainPanel, JLayeredPane.PALETTE_LAYER);
        JPanel title = new JPanel(new GridLayout(4, 1));
        title.setBackground(new Color(255, 255, 0, 210));
        title.setSize(224, 80);
        title.setLocation(5, 5);
        title.setBorder(LineBorder.createBlackLineBorder());
        JLabel titleLabel = new JLabel("SWARM:", 0);
        titleLabel.setForeground(Color.red);
        title.add(titleLabel);
        JLabel l2 = new JLabel("Seismic Wave Analysis/", 0);
        l2.setForeground(Color.blue);
        title.add(l2);
        JLabel l3 = new JLabel("Real-time Monitoring", 0);
        l3.setForeground(Color.blue);
        title.add(l3);
        title.add(new JLabel("Version: " + Swarm.getVersion(), 0));
        this.getLayeredPane().add(title);
        this.getLayeredPane().setLayer(title, JLayeredPane.PALETTE_LAYER);
        this.okButton = new JButton("OK");
        this.okButton.setSize(60, 30);
        this.okButton.setLocation(170, 205);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
                AboutDialog.this.kill = true;
            }
        });
        this.gcButton = new JButton("Run GC");
        this.gcButton.setSize(90, 30);
        this.gcButton.setLocation(70, 205);
        this.gcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                AboutDialog.this.update();
            }
        });
        this.getLayeredPane().add(this.okButton);
        this.getLayeredPane().add(this.gcButton);
        this.getLayeredPane().setLayer(this.okButton, JLayeredPane.PALETTE_LAYER);
        this.getLayeredPane().setLayer(this.gcButton, JLayeredPane.PALETTE_LAYER);
    }

    public String toByteString(long bytes) {
        DecimalFormat nf = new DecimalFormat("#.##");
        return String.valueOf(nf.format((double)bytes / 1000000.0)) + " MB";
    }

    @Override
    public void setVisible(boolean v) {
        this.updateThread = new Thread((Runnable)this, "About");
        this.updateThread.start();
        super.setVisible(v);
    }

    @Override
    public void run() {
        while (!this.kill) {
            try {
                this.update();
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.kill = false;
    }

    public void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Runtime r = Runtime.getRuntime();
                AboutDialog.this.freeMemory.setText(AboutDialog.this.toByteString(r.freeMemory()));
                AboutDialog.this.totalMemory.setText(AboutDialog.this.toByteString(r.totalMemory()));
                AboutDialog.this.usedMemory.setText(AboutDialog.this.toByteString(r.totalMemory() - r.freeMemory()));
                AboutDialog.this.maxMemory.setText(AboutDialog.this.toByteString(r.maxMemory()));
                AboutDialog.this.cacheMemory.setText(AboutDialog.this.toByteString(Swarm.getCache().getSize()));
                AboutDialog.this.repaint();
            }
        });
    }
}

