/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class UnprojectImage {
    private double deltaX;
    private double deltaY;
    private double originX;
    private double originY;
    private BufferedImage image;

    public UnprojectImage(BufferedImage img, double dx, double dy, double ox, double oy) {
        this.image = img;
        this.deltaX = dx;
        this.deltaY = dy;
        this.originX = ox;
        this.originY = oy;
    }

    public int getSourcePixel(double sx, double sy, Interpolation interp) {
        if (interp == Interpolation.NEAREST_NEIGHBOR) {
            int xo = (int)((sx - this.originX) / this.deltaX);
            int yo = (int)((sy - this.originY) / this.deltaY);
            if (xo >= this.image.getWidth() || yo >= this.image.getHeight() || xo < 0 || yo < 0) {
                return 0;
            }
            return this.image.getRGB(xo, yo);
        }
        if (interp == Interpolation.BILINEAR) {
            double xo = (sx - this.originX) / this.deltaX;
            double yo = (sy - this.originY) / this.deltaY;
            if (xo >= (double)(this.image.getWidth() - 1) || yo >= (double)(this.image.getHeight() - 1) || xo < 0.0 || yo < 0.0) {
                return 0;
            }
            int pul = this.image.getRGB((int)xo, (int)yo);
            int pur = this.image.getRGB((int)xo + 1, (int)yo);
            int plr = this.image.getRGB((int)xo + 1, (int)yo + 1);
            int pll = this.image.getRGB((int)xo, (int)yo + 1);
            int px = (int)xo;
            int py = (int)yo;
            double delx = xo - (double)px;
            double dely = yo - (double)py;
            int ul = pul & 0xFF;
            int ur = pur & 0xFF;
            int lr = plr & 0xFF;
            int ll = pll & 0xFF;
            int b = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            ul = pul >> 8 & 0xFF;
            ur = pur >> 8 & 0xFF;
            lr = plr >> 8 & 0xFF;
            ll = pll >> 8 & 0xFF;
            int g = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            ul = pul >> 16 & 0xFF;
            ur = pur >> 16 & 0xFF;
            lr = plr >> 16 & 0xFF;
            ll = pll >> 16 & 0xFF;
            int r = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            return b | g << 8 | r << 16;
        }
        return 0;
    }

    public BufferedImage getUnprojectedImage(Projection proj, int w, int h, double lon, double lat, double dlon, double dlat, Interpolation interp) {
        BufferedImage img = new BufferedImage(w, h, 1);
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                Point2D.Double pt = new Point2D.Double(lon + (double)x * dlon, lat + (double)y * dlat);
                Point2D.Double src = proj.forward(pt);
                img.setRGB(x, y, this.getSourcePixel(src.x, src.y, interp));
                ++y;
            }
            ++x;
        }
        return img;
    }

    public static enum Interpolation {
        NEAREST_NEIGHBOR,
        BILINEAR;

    }
}

