/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.TimeFormatter;

public class SiteIdUtil {
    public static boolean areEqual(SiteId a, SiteId b) {
        if (a == b) {
            return true;
        }
        return a.station_code.equals(b.station_code) && a.site_code.equals(b.site_code) && NetworkIdUtil.areEqual(a.network_id, b.network_id) && NetworkIdUtil.areEqual(a.begin_time, b.begin_time);
    }

    public static String toString(SiteId id) {
        return NetworkIdUtil.toString(id.network_id) + ":" + id.station_code + ":" + id.site_code + ":" + id.begin_time.date_time;
    }

    public static String toStringFormatDates(SiteId id) {
        return NetworkIdUtil.toStringFormatDates(id.network_id) + ":" + id.station_code + ":" + id.site_code + ":" + TimeFormatter.format(id.begin_time);
    }

    public static String toStringNoDates(SiteId id) {
        return NetworkIdUtil.toStringNoDates(id.network_id) + "." + id.station_code + "." + id.site_code;
    }

    public static boolean areSameSite(ChannelId a, ChannelId b) {
        if (a == b) {
            return true;
        }
        return a.station_code.equals(b.station_code) && a.site_code.equals(b.site_code) && NetworkIdUtil.areEqual(a.network_id, b.network_id);
    }
}

