/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools;

import gov.usgs.winston.tools.TermIO;
import gov.usgs.winston.tools.WinstonToolsAboutDialog;
import gov.usgs.winston.tools.WinstonToolsHelpDialog;
import gov.usgs.winston.tools.WinstonToolsPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class WinstonToolsMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private JMenu fileMenu;
    private JMenu helpMenu;

    public WinstonToolsMenu() {
        this.createFileMenu();
        this.add(Box.createGlue());
        this.createHelpMenu();
    }

    public void addHelpItem(final WinstonToolsPanel p) {
        JMenuItem i = new JMenuItem(p.getTitle());
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WinstonToolsHelpDialog d = new WinstonToolsHelpDialog(p);
                d.setVisible(true);
            }
        });
        this.helpMenu.add((Component)i, this.helpMenu.getItemCount() - 2);
    }

    private void createHelpMenu() {
        this.helpMenu = new JMenu("Help");
        this.fileMenu.setMnemonic('H');
        this.helpMenu.addSeparator();
        JMenuItem i = new JMenuItem("About Winston Tools");
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WinstonToolsAboutDialog d = new WinstonToolsAboutDialog();
                d.setVisible(true);
            }
        });
        this.helpMenu.add(i);
        this.add(this.helpMenu);
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        JMenuItem term = new JMenuItem("Show Console");
        term.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TermIO.showTerm(true);
            }
        });
        this.fileMenu.add(term);
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic('x');
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.fileMenu.add(exit);
        this.add(this.fileMenu);
    }
}

