/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.util.Time;
import gov.usgs.winston.server.WWSClient;
import gov.usgs.winston.tools.FilePanel;
import gov.usgs.winston.tools.ScnlPanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WWSClientPanel
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(16752762);
    private JTextField waveServerF;
    private JTextField portF;
    private ScnlPanel scnlPanel;
    private FilePanel filePanel;
    private JTextField start;
    private JTextField end;
    private JButton exportB;

    public WWSClientPanel() {
        super("WWS Client");
    }

    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Write to SAC File"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:max(40dlu;p)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Source Wave Server");
        builder.append("Host", (Component)this.waveServerF);
        builder.nextLine();
        builder.append("Port", (Component)this.portF);
        builder.nextLine();
        builder.appendSeparator("Channel");
        builder.append("SCNL", (Component)this.scnlPanel);
        builder.nextLine();
        builder.appendSeparator("Destination File");
        builder.append("SAC File", (Component)this.filePanel);
        builder.nextLine();
        builder.appendSeparator("Time Range");
        builder.append("Start", (Component)this.start);
        builder.nextLine();
        builder.append("End", (Component)this.end);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.exportB);
        this.add((Component)builder.getPanel(), "Center");
    }

    protected void createFields() {
        this.waveServerF = new JTextField(15);
        this.portF = new JTextField();
        this.portF.setText("16022");
        this.scnlPanel = new ScnlPanel();
        this.filePanel = new FilePanel(FilePanel.Type.SAVE);
        this.start = new JTextField(15);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.start.setText(Time.format("yyyyMMddHHmmss", cal.getTime()));
        this.start.setToolTipText("yyyyMMddHHmmss");
        this.start.getDocument().addDocumentListener(new TimeRangeDocumentListener(this.start));
        this.end = new JTextField(15);
        this.end.setText(Time.format("yyyyMMddHHmmss", new Date()));
        this.end.setToolTipText("yyyyMMddHHmmss");
        this.end.getDocument().addDocumentListener(new TimeRangeDocumentListener(this.end));
        this.exportB = new JButton("Export");
        this.exportB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WWSClientPanel.this.start();
            }
        });
    }

    protected void go() {
        this.exportB.setEnabled(false);
        String server = this.waveServerF.getText().trim();
        int port = Integer.parseInt(this.portF.getText().trim());
        String scnl = this.scnlPanel.getSCNL('$');
        String file = this.filePanel.getFileName();
        try {
            double[] d = Time.parseTimeRange(this.start.getText() + "," + this.end.getText());
            System.out.println("Starting export...");
            WWSClient.outputSac(server, port, d[0], d[1], scnl, file);
        }
        catch (ParseException e) {
            // empty catch block
        }
        System.out.println("Done.");
        this.exportB.setEnabled(true);
    }

    public boolean needsWinston() {
        return false;
    }

    public class TimeRangeDocumentListener
    implements DocumentListener {
        JTextField f;

        public TimeRangeDocumentListener(JTextField f) {
            this.f = f;
        }

        public void insertUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        public void removeUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private boolean validateTime() {
            try {
                Time.parseTimeRange(this.f.getText());
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
        }
    }

    public class TimeRangeOption {
        String title;
        String value;

        public TimeRangeOption(String t, String v) {
            this.title = t;
            this.value = v;
        }

        public String toString() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }
    }
}

