/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Time;
import gov.usgs.winston.in.ew.ImportWS;
import gov.usgs.winston.tools.ScnlPanel;
import gov.usgs.winston.tools.WinstonToolsStoppablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportWSPanel
extends WinstonToolsStoppablePanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(16752762);
    private ImportWS ws;
    private static JTextField waveServer;
    private static JTextField port;
    private static JTextField chunkSize;
    private static JTextField chunkDelay;
    private static JCheckBox createChannels;
    private static JCheckBox findGaps;
    private static ScnlPanel scnlPanel;
    private static JRadioButton explicitB;
    private static JRadioButton relativeB;
    private static JTextField start;
    private static JTextField end;
    private static JComboBox rangeList;
    private static JButton importB;

    public ImportWSPanel() {
        super("Import WS");
    }

    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Import From Wave Server"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Source Wave Server");
        builder.append("Host", (Component)waveServer);
        builder.nextLine();
        builder.append("Port", (Component)port);
        builder.nextLine();
        builder.appendSeparator("Import Settings");
        builder.append("Chunk Size", (Component)chunkSize);
        builder.nextLine();
        builder.append("Chunk Delay", (Component)chunkDelay);
        builder.nextLine();
        builder.appendSeparator("Winston Settings");
        builder.append((Component)createChannels, 3);
        builder.nextLine();
        builder.append((Component)findGaps, 3);
        builder.nextLine();
        builder.appendSeparator("Channel");
        builder.append("SCNL", (Component)scnlPanel);
        builder.nextLine();
        builder.appendSeparator("Time Range");
        builder.append((Component)explicitB, 3);
        builder.nextLine();
        builder.append("Start", (Component)start);
        builder.nextLine();
        builder.append("End", (Component)end);
        builder.append((Component)relativeB, 3);
        builder.nextLine();
        builder.append("", (Component)rangeList);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)importB, 3);
        this.add((Component)builder.getPanel(), "Center");
    }

    protected void createFields() {
        this.ws = new ImportWS();
        waveServer = new JTextField();
        port = new JTextField();
        port.setText("16022");
        chunkSize = new JTextField();
        chunkSize.setText("3600");
        chunkDelay = new JTextField();
        chunkDelay.setText("0");
        createChannels = new JCheckBox("Create Channels", true);
        findGaps = new JCheckBox("Find Gaps", true);
        scnlPanel = new ScnlPanel();
        scnlPanel.setSCNL("* * * *");
        explicitB = new JRadioButton("Explicit");
        relativeB = new JRadioButton("Relative", true);
        ButtonGroup timeRangeG = new ButtonGroup();
        timeRangeG.add(explicitB);
        timeRangeG.add(relativeB);
        start = new JTextField();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        start.setText(Time.format("yyyyMMddHHmmss", cal.getTime()));
        start.setToolTipText("yyyyMMddHHmmss");
        start.addFocusListener(new TimeRangeFocusListener(explicitB));
        start.getDocument().addDocumentListener(new TimeRangeDocumentListener(start));
        end = new JTextField();
        end.setText(Time.format("yyyyMMddHHmmss", new Date()));
        end.setToolTipText("yyyyMMddHHmmss");
        end.addFocusListener(new TimeRangeFocusListener(explicitB));
        end.getDocument().addDocumentListener(new TimeRangeDocumentListener(end));
        rangeList = new JComboBox();
        rangeList.addItem(new TimeRangeOption("1 Day", "-1d"));
        rangeList.addItem(new TimeRangeOption("1 Week", "-1w"));
        rangeList.addItem(new TimeRangeOption("1 Month", "-1m"));
        rangeList.addItem(new TimeRangeOption("3 Months", "-3m"));
        rangeList.addItem(new TimeRangeOption("1 Year", "-1y"));
        rangeList.setSelectedIndex(0);
        rangeList.addFocusListener(new TimeRangeFocusListener(relativeB));
        importB = new JButton("Import");
        importB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportWSPanel.this.start();
            }
        });
    }

    protected void go() {
        importB.setEnabled(false);
        this.ws.setQuit(false);
        ConfigFile config = new ConfigFile("Winston.config");
        config.put("createDatabase", "true");
        String s = waveServer.getText().trim() + ":" + port.getText().trim();
        config.put("waveServer", s);
        s = createChannels.isSelected() ? "true" : "flase";
        config.put("createChannels", s);
        config.put("channel", scnlPanel.getSCNL());
        s = this.getTimeRange();
        config.put("timeRange", s);
        config.put("chunkSize", chunkSize.getText());
        config.put("chunkDelay", chunkDelay.getText());
        this.ws.setConfig(config);
        this.ws.processConfig();
        this.ws.createJobs();
        this.ws.startImport();
        importB.setEnabled(true);
    }

    public void stop() {
        this.ws.quit();
    }

    public boolean needsWinston() {
        return true;
    }

    private String getTimeRange() {
        String s;
        if (explicitB.isSelected()) {
            s = start.getText() + "," + end.getText();
        } else {
            s = ((TimeRangeOption)rangeList.getSelectedItem()).getValue();
            s = s + "," + Time.format("yyyyMMddHHmmss", new Date());
        }
        return s;
    }

    public class TimeRangeDocumentListener
    implements DocumentListener {
        JTextField f;

        public TimeRangeDocumentListener(JTextField f) {
            this.f = f;
        }

        public void insertUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        public void removeUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private boolean validateTime() {
            try {
                Time.parseTimeRange(this.f.getText());
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
        }
    }

    public class TimeRangeFocusListener
    implements FocusListener {
        JRadioButton b;

        TimeRangeFocusListener(JRadioButton b) {
            this.b = b;
        }

        public void focusGained(FocusEvent e) {
            this.b.setSelected(true);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    public class TimeRangeOption {
        String title;
        String value;

        public TimeRangeOption(String t, String v) {
            this.title = t;
            this.value = v;
        }

        public String toString() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }
    }
}

