/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.NetTools;
import gov.usgs.vdx.data.rsam.RSAMData;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.WWSCommandString;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetSCNLRSAMRawCommand
extends BaseCommand {
    public GetSCNLRSAMRawCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    public void doCommand(Object info, SocketChannel channel) {
        WWSCommandString cmd = new WWSCommandString((String)info);
        if (!cmd.isLegalSCNLTT(10) || Double.isNaN(cmd.getDouble(8)) || cmd.getInt(9) == Integer.MIN_VALUE) {
            return;
        }
        RSAMData rsam = this.data.getRSAMData(cmd.getWinstonSCNL(), cmd.getT1(true), cmd.getT2(true), cmd.getDouble(8));
        ByteBuffer bb = null;
        if (rsam != null && rsam.rows() > 0) {
            bb = (ByteBuffer)rsam.toBinary().flip();
        }
        int bytes = this.writeByteBuffer(cmd.getID(), bb, cmd.getInt(9) == 1, channel);
        this.wws.log(Level.FINER, "GETSCNLRSAMRAW, " + bytes + " bytes.", channel);
    }
}

