/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.earthworm.ImportGeneric;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.monitor.Collector;
import gov.usgs.winston.monitor.MonitorServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Monitor
extends Thread {
    public static final String DEFAULT_CONFIG_FILENAME = "WinstonMonitor.config";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_STATUS_INTERVAL = 60;
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    public static final int DEFAULT_MAX_DAYS = 0;
    public static final int DEFAULT_MAX_BACKLOG = 100;
    public static final String DEFAULT_LOG_LEVEL = "FINE";
    public static final String DEFAULT_LOG_FILE = "monitor.log";
    public static final int DEFAULT_LOG_NUM_FILES = 10;
    public static final int DEFAULT_LOG_FILE_SIZE = 1000000;
    public static final String DEFAULT_RRD_DIR = "rrds";
    public static String JSAP_PROGRAM_NAME = "java gov.usgs.winston.monitor.Monitor";
    public static String JSAP_EXPLANATION_PREFACE = "Winston Monitor\n\nThis program collects data from winston sources and provides plots over HTTP\nSee 'winstonMonitor.config' for more options.\n\n";
    private static final String DEFAULT_JSAP_EXPLANATION = "All output goes to both standard error and the file log.\n\nWhile the process is running (and accepting console input) you can enter\nthese commands into the console (followed by [Enter]):\n0: turn logging off.\n1: normal logging level (WARNING).\n2: high logging level (FINE).\n3: log everything.\ni: no longer accept console input.\nq: quit cleanly.\nctrl-c: quit now.\n\nNote that if console input is disabled the only way to\nterminate the program is with ctrl-c or by killing the process.\n";
    private static final Parameter[] DEFAULT_JSAP_PARAMETERS = new Parameter[]{new FlaggedOption("logLevel", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'l', "log-level", "The level of logging to start with\nThis may consist of either a java.util.logging.Level name or an integer value.\nFor example: \"SEVERE\", or \"1000\""), new Switch("logoff", '0', "logoff", "Turn logging off (equivalent to --log-level OFF)."), new Switch("lognormal", '1', "lognormal", "Normal (default) logging level (equivalent to --log-level FINE)."), new Switch("loghigh", '2', "loghigh", "High logging level (equivalent to --log-level ALL)."), new Switch("noinput", 'i', "noinput", "Don't accept input from the console."), new UnflaggedOption("configFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The config file name.")};
    protected String configFilename;
    protected ConfigFile config;
    protected ImportGeneric importGeneric;
    protected final Logger logger;
    protected String logFile;
    protected int logNumFiles;
    protected int logSize;
    private MonitorServer server;
    private ArrayList<Collector> collectors;

    public Monitor(String fn) {
        this();
        this.configFilename = Util.stringToString(fn, DEFAULT_CONFIG_FILENAME);
        System.out.println(String.format("Reading config file %s in directory %s", this.configFilename, System.getProperty("user.dir")));
        this.config = new ConfigFile(this.configFilename);
        this.processConfigFile();
    }

    public Monitor() {
        this.setName("Monitor");
        this.logger = Log.getLogger("gov.usgs.winston");
        this.logger.setLevel(Level.parse(DEFAULT_LOG_LEVEL));
    }

    protected void processConfigFile() {
        this.processLoggerConfig();
        this.processMonitorConfig();
        this.processCollectorConfig();
        this.processServerConfig();
    }

    private void processServerConfig() {
        this.server = new MonitorServer(this.config.getSubConfig("server"), this.collectors);
        new Thread(this.server).start();
    }

    private void processCollectorConfig() {
        this.collectors = new ArrayList();
        ConfigFile wc = this.config.getSubConfig("winston");
        for (String collectorName : this.config.getList("collector")) {
            ConfigFile cc = this.config.getSubConfig(collectorName);
            try {
                Collector collector = (Collector)Class.forName(cc.getString("class")).newInstance();
                collector.configure(collectorName, cc, wc);
                this.collectors.add(collector);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, String.format("Could not create %s collector: %s", collectorName, e.getMessage()));
                e.printStackTrace();
            }
        }
        for (Collector collector : this.collectors) {
            this.logger.info("starting collector: " + collector.getName());
            collector.start();
        }
    }

    protected void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    protected void processLoggerConfig() {
        String[] version;
        this.logFile = Util.stringToString(this.config.getString("monitor.log.name"), DEFAULT_LOG_FILE);
        this.logNumFiles = Util.stringToInt(this.config.getString("monitor.log.numFiles"), 10);
        this.logSize = Util.stringToInt(this.config.getString("monitor.log.maxSize"), 1000000);
        if (this.logNumFiles > 0) {
            Log.attachFileLogger(this.logger, this.logFile, this.logSize, this.logNumFiles, true);
        }
        if ((version = Util.getVersion("gov.usgs.winston")) != null) {
            this.logger.info("Version: " + version[0] + " Built: " + version[1]);
        } else {
            this.logger.info("No version information available.");
        }
        this.logger.info("config: monitor.log.name=" + this.logFile);
        this.logger.info("config: monitor.log.numFiles=" + this.logNumFiles);
        this.logger.info("config: monitor.log.maxSize=" + this.logSize);
    }

    protected void processMonitorConfig() {
        int port = Util.stringToInt(this.config.getString("monitor.port"), 8080);
        this.logger.info("config: monitor.port=" + port);
    }

    public void run() {
    }

    public void quit() {
        System.out.println("Quitting cleanly...");
        for (Collector c : this.collectors) {
            System.out.print("Stopping collector " + c.getName() + "... ");
            c.quit();
            System.out.println(" done.");
        }
    }

    public void printStatus() {
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, JSAP_EXPLANATION_PREFACE + DEFAULT_JSAP_EXPLANATION, DEFAULT_JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted()) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    public void setLogLevel(Level level) {
        if (level.equals(Level.ALL)) {
            this.logger.fine("Logging set to high.");
        } else if (level.equals(Level.FINE)) {
            this.logger.fine("Logging set to normal.");
        } else if (level.equals(Level.OFF)) {
            this.logger.fine("Logging turned off.");
        }
        this.logger.setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consoleInputManager(Monitor im) {
        im.logger.entering(im.getClass().getName(), "consoleInputManager");
        boolean acceptCommands = true;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (acceptCommands) {
            try {
                String s = null;
                try {
                    s = in.readLine();
                }
                catch (IOException ioex) {
                    im.logger.log(Level.SEVERE, "IOException encountered while attempting to read console input.", ioex);
                }
                if (s == null) continue;
                if ((s = s.toLowerCase().trim()).equals("q")) {
                    im.quit();
                    try {
                        im.join();
                    }
                    catch (Throwable e) {
                        im.logger.log(Level.SEVERE, "Failed to quit cleanly.", e);
                    }
                    finally {
                        im.printStatus();
                    }
                    System.exit(0);
                    continue;
                }
                if (s.equals("0")) {
                    im.setLogLevel(Level.OFF);
                    continue;
                }
                if (s.equals("1")) {
                    im.setLogLevel(Level.FINE);
                    continue;
                }
                if (!s.equals("2")) continue;
                im.setLogLevel(Level.ALL);
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        im.logger.exiting(im.getClass().getName(), "consoleInputManager");
    }

    public static void main(String[] args) {
        JSAPResult config = Monitor.getArguments(args);
        String fn = Util.stringToString(config.getString("configFilename"), DEFAULT_CONFIG_FILENAME);
        Level logLevel = Level.parse(DEFAULT_LOG_LEVEL);
        if (config.getString("logLevel") != null) {
            try {
                logLevel = Level.parse(config.getString("logLevel"));
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Invalid log level: " + config.getString("logLevel"));
                System.err.println("Using default log level: " + logLevel);
            }
        } else {
            if (config.getBoolean("logoff")) {
                logLevel = Level.OFF;
            }
            if (config.getBoolean("lognormal")) {
                logLevel = Level.FINE;
            }
            if (config.getBoolean("loghigh")) {
                logLevel = Level.ALL;
            }
        }
        Monitor mon = new Monitor(fn);
        if (!config.getBoolean("noinput")) {
            Monitor.consoleInputManager(mon);
        }
    }
}

