/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class Export {
    private WinstonDatabase winston;
    private Data data;
    private static String dbDriver;
    private static String dbURL;
    private static String dbPrefix;

    public Export(WinstonDatabase w) {
        this.winston = w;
        this.data = new Data(this.winston);
    }

    public static void readConfigFile() {
        ConfigFile config = new ConfigFile("Winston.config");
        dbDriver = config.getString("winston.driver");
        dbURL = config.getString("winston.url");
        dbPrefix = config.getString("winston.prefix");
    }

    public void export(String code, String pre, double t1, double t2) {
        try {
            double nst;
            double maxSize = 3600.0;
            double ct = nst = t1 - t1 % 5.0;
            int cnt = 0;
            while (ct < t2) {
                Wave sw;
                if (t2 - ct > maxSize) {
                    sw = this.data.getWave(code, ct, ct + maxSize);
                    ct += maxSize;
                } else {
                    sw = this.data.getWave(code, ct, ct + maxSize);
                    ct = t2;
                }
                if (sw != null) {
                    sw.exportToText(pre + "_" + code + "_" + cnt + ".txt");
                }
                System.out.println(ct - t1 + "s");
                ++cnt;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws ParseException {
        if (args.length != 4) {
            System.out.println("Usage: java gov.usgs.winston.db.Export [code] [prefix] [yyyymmddhhmmss] [yyyymmddhhmmss]");
            System.out.println();
            System.out.println("Database parameters ('winston.url', 'winston.driver', 'winston.prefix')\nmust be in 'Winston.config'.");
            System.out.println();
            System.out.println("Input time is in GMT.");
            System.out.println();
            System.out.println("[code] is $ separated, example: CRP$EHZ$AV");
            System.out.println();
            System.out.println("Output files will have names like: '[prefix]_[code]_[number].txt'.");
            System.exit(1);
        }
        Export.readConfigFile();
        String code = args[0];
        String prefix = args[1];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        double t1 = Util.dateToJ2K(dateFormat.parse(args[2]));
        double t2 = Util.dateToJ2K(dateFormat.parse(args[3]));
        System.out.println("Attempting to extract " + (t2 - t1) + " seconds from " + code);
        WinstonDatabase winston = new WinstonDatabase(dbDriver, dbURL, dbPrefix);
        Export export = new Export(winston);
        export.export(code, prefix, t1, t2);
    }
}

