/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo;

import gov.usgs.util.ConfigFile;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SelectOption;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.HypocenterList;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLHypocenterDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "hypocenters";
    public static final boolean channels = false;
    public static final boolean translations = false;
    public static final boolean channelTypes = false;
    public static final boolean ranks = true;
    public static final boolean columns = false;
    public static final boolean menuColumns = false;
    public static final String REMARK = "remark";
    public static final String MAGTYPE = "magtype";
    public static final SelectOption[] REMARK_OPTIONS = new SelectOption[]{new SelectOption(1, "F", "Felt (F)"), new SelectOption(2, "B", "Explosion/Collapse (B)"), new SelectOption(3, "L", "Long Period (L)"), new SelectOption(4, "T", "Tremor (T)"), new SelectOption(5, "Q", "Quarry (Q)"), new SelectOption(6, "N", "Nuclear (N")};
    public static final SelectOption[] MAGTYPE_OPTIONS = new SelectOption[]{new SelectOption(1, "B", "Body Wave Magnitude (B)"), new SelectOption(2, "C", "Coda Amplitude Magnitude (C)"), new SelectOption(3, "D", "Coda Duration Magnitude (D)"), new SelectOption(4, "E", "Energy Magnitude (E)"), new SelectOption(5, "G", "MAGNUM (G)"), new SelectOption(1, "H", "Hand Entered (H)"), new SelectOption(2, "L", "Local Magnitude (L)"), new SelectOption(3, "O", "Moment Magnitude (O)"), new SelectOption(4, "P", "P-Wave Magnitude (P)"), new SelectOption(5, "S", "Surface Wave Magnitude (S)"), new SelectOption(6, "X", "External (X)")};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return false;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return false;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            SelectOption so;
            int i;
            this.defaultCreateDatabase(false, false, false, true, false, false);
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.sql = "CREATE TABLE hypocenters (j2ksec DOUBLE NOT NULL, eid VARCHAR(45) NOT NULL, rid INT NOT NULL, ";
            this.sql = this.sql + "   lat DOUBLE NOT NULL, lon DOUBLE NOT NULL, depth DOUBLE NOT NULL, ";
            this.sql = this.sql + "   prefmag DOUBLE, ampmag DOUBLE, codamag DOUBLE, ";
            this.sql = this.sql + "   nphases INT, azgap INT, dmin DOUBLE, rms DOUBLE, nstimes INT, herr DOUBLE, verr DOUBLE, ";
            this.sql = this.sql + "   magtype VARCHAR(1), rmk VARCHAR(1), PRIMARY KEY(eid,rid), KEY index_j2ksec (j2ksec))";
            this.st.execute(this.sql);
            this.sql = "CREATE TABLE options_remark (id INT PRIMARY KEY AUTO_INCREMENT, ";
            this.sql = this.sql + "   idx INT NOT NULL, code VARCHAR(1) NOT NULL, name VARCHAR(255) NOT NULL)";
            this.st.execute(this.sql);
            this.sql = "CREATE TABLE options_magtype (id INT PRIMARY KEY AUTO_INCREMENT, ";
            this.sql = this.sql + "   idx INT NOT NULL, code VARCHAR(1) NOT NULL, name VARCHAR(255) NOT NULL)";
            this.st.execute(this.sql);
            for (i = 0; i < REMARK_OPTIONS.length; ++i) {
                so = REMARK_OPTIONS[i];
                this.sql = "INSERT INTO options_remark (idx, code, name) VALUES(?,?,?)";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setInt(1, so.getIndex());
                this.ps.setString(2, so.getCode());
                this.ps.setString(3, so.getName());
                this.ps.execute();
            }
            for (i = 0; i < MAGTYPE_OPTIONS.length; ++i) {
                so = MAGTYPE_OPTIONS[i];
                this.sql = "INSERT INTO options_magtype (idx, code, name) VALUES(?,?,?)";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setInt(1, so.getIndex());
                this.ps.setString(2, so.getCode());
                this.ps.setString(3, so.getName());
                this.ps.execute();
            }
            this.logger.log(Level.INFO, "SQLHypocenterDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded.");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLHypocenterDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") failed.", e);
            return false;
        }
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String rmk;
        double maxVerr;
        double minVerr;
        double maxHerr;
        double minHerr;
        double maxRMS;
        double minRMS;
        Integer maxNPhases;
        Integer minNPhases;
        double maxMag;
        double minMag;
        double maxDepth;
        double minDepth;
        double north;
        double south;
        double east;
        double west;
        double et;
        double st;
        int rid;
        HypocenterList data;
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals(REMARK) || action.equals(MAGTYPE)) {
            return new TextResult(this.defaultGetOptions(action));
        }
        if (action.equals("data") && (data = this.getHypocenterData(rid = Integer.parseInt(params.get("rk")), st = Double.parseDouble(params.get("st")), et = Double.parseDouble(params.get("et")), west = Double.parseDouble(params.get("west")), east = Double.parseDouble(params.get("east")), south = Double.parseDouble(params.get("south")), north = Double.parseDouble(params.get("north")), minDepth = Double.parseDouble(params.get("minDepth")), maxDepth = Double.parseDouble(params.get("maxDepth")), minMag = Double.parseDouble(params.get("minMag")), maxMag = Double.parseDouble(params.get("maxMag")), minNPhases = Integer.valueOf(Integer.parseInt(params.get("minNPhases"))), maxNPhases = Integer.valueOf(Integer.parseInt(params.get("maxNPhases"))), minRMS = Double.parseDouble(params.get("minRMS")), maxRMS = Double.parseDouble(params.get("maxRMS")), minHerr = Double.parseDouble(params.get("minHerr")), maxHerr = Double.parseDouble(params.get("maxHerr")), minVerr = Double.parseDouble(params.get("minVerr")), maxVerr = Double.parseDouble(params.get("maxVerr")), rmk = params.get("rmk"))) != null && data.size() > 0) {
            return new BinaryResult(data);
        }
        return null;
    }

    public HypocenterList getHypocenterData(int rid, double st, double et, double west, double east, double south, double north, double minDepth, double maxDepth, double minMag, double maxMag, Integer minNPhases, Integer maxNPhases, double minRMS, double maxRMS, double minHerr, double maxHerr, double minVerr, double maxVerr, String rmk) {
        ArrayList<Hypocenter> pts = new ArrayList<Hypocenter>();
        HypocenterList result = null;
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT a.j2ksec, a.rid, a.lat, a.lon, a.depth, a.prefmag ";
            this.sql = this.sql + "FROM   hypocenters a, ranks c ";
            this.sql = this.sql + "WHERE  a.rid = c.rid ";
            this.sql = this.sql + "AND    a.j2ksec  >= ? AND a.j2ksec  <= ? ";
            this.sql = this.sql + "AND    a.lon     >= ? AND a.lon     <= ? ";
            this.sql = this.sql + "AND    a.lat     >= ? AND a.lat     <= ? ";
            if (minDepth != -1.7976931348623157E308 || maxDepth != Double.MAX_VALUE) {
                this.sql = this.sql + "AND    a.depth   >= " + minDepth + " AND a.depth   <= " + maxDepth + " ";
            }
            if (minMag != -1.7976931348623157E308 || maxMag != Double.MAX_VALUE) {
                this.sql = this.sql + "AND    a.prefmag >= " + minMag + " AND a.prefmag <= " + maxMag + " ";
            }
            this.sql = this.sql + "AND    a.prefmag IS NOT NULL ";
            if (minNPhases != Integer.MIN_VALUE || maxNPhases != Integer.MAX_VALUE) {
                this.sql = this.sql + "AND    a.nphases >= " + minNPhases + " AND a.nphases <= " + maxNPhases + " ";
            }
            if (minRMS != -1.7976931348623157E308 || maxRMS != Double.MAX_VALUE) {
                this.sql = this.sql + "AND    a.rms >= " + minRMS + " AND a.rms <= " + maxRMS + " ";
            }
            if (minHerr != -1.7976931348623157E308 || maxHerr != Double.MAX_VALUE) {
                this.sql = this.sql + "AND    a.herr >= " + minHerr + " AND a.herr <= " + maxHerr + " ";
            }
            if (minVerr != -1.7976931348623157E308 || maxVerr != Double.MAX_VALUE) {
                this.sql = this.sql + "AND    a.verr >= " + minVerr + " AND a.verr <= " + maxVerr + " ";
            }
            if (!rmk.equals("")) {
                this.sql = this.sql + "AND    a.rmk = '" + rmk + "' ";
            }
            if (rid != 0) {
                this.sql = this.sql + "AND    c.rid  = ? ";
            } else if (rid == 0) {
                this.sql = this.sql + "AND    c.rank = (SELECT MAX(e.rank) FROM   hypocenters d, ranks e WHERE  d.rid = e.rid  AND    trim(a.eid) = trim(d.eid) AND    d.j2ksec >= ? AND    d.j2ksec <= ? ) ";
            }
            this.sql = this.sql + "ORDER BY j2ksec ASC";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, st);
            this.ps.setDouble(2, et);
            this.ps.setDouble(3, west);
            this.ps.setDouble(4, east);
            this.ps.setDouble(5, south);
            this.ps.setDouble(6, north);
            if (rid != 0) {
                this.ps.setInt(7, rid);
            } else {
                this.ps.setDouble(7, st);
                this.ps.setDouble(8, et);
            }
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                double j2ksec = this.rs.getDouble(1);
                rid = this.rs.getInt(2);
                double lat = this.rs.getDouble(3);
                double lon = this.rs.getDouble(4);
                double depth = this.rs.getDouble(5);
                double mag = this.rs.getDouble(6);
                pts.add(new Hypocenter(j2ksec, rid, lat, lon, depth, mag));
            }
            this.rs.close();
            if (pts.size() > 0) {
                return new HypocenterList(pts);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLHypocenterDataSource.getHypocenterData() failed.", e);
        }
        return result;
    }

    public void insertHypocenter(Hypocenter hc) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "INSERT IGNORE INTO hypocenters ";
            this.sql = this.sql + "       (j2ksec, eid, rid, lat, lon, depth, prefmag, ampmag, codamag, ";
            this.sql = this.sql + "        nphases, azgap, dmin, rms, nstimes, herr, verr, magtype, rmk) ";
            this.sql = this.sql + "VALUES (?,?,?,round(?, 4),round(?, 4),round(?, 2),round(?, 2),round(?, 2),round(?, 2),?,?,?,?,?,?,?,?,?)";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, hc.j2ksec);
            this.ps.setString(2, hc.eid);
            this.ps.setInt(3, hc.rid);
            this.ps.setDouble(4, hc.lat);
            this.ps.setDouble(5, hc.lon);
            this.ps.setDouble(6, hc.depth);
            if (Double.isNaN(hc.prefmag)) {
                this.ps.setNull(7, 8);
            } else {
                this.ps.setDouble(7, hc.prefmag);
            }
            if (Double.isNaN(hc.ampmag)) {
                this.ps.setNull(8, 8);
            } else {
                this.ps.setDouble(8, hc.ampmag);
            }
            if (Double.isNaN(hc.codamag)) {
                this.ps.setNull(9, 8);
            } else {
                this.ps.setDouble(9, hc.codamag);
            }
            if (hc.nphases == null) {
                this.ps.setNull(10, 4);
            } else {
                this.ps.setInt(10, hc.nphases);
            }
            if (hc.azgap == null) {
                this.ps.setNull(11, 4);
            } else {
                this.ps.setInt(11, hc.azgap);
            }
            if (Double.isNaN(hc.dmin)) {
                this.ps.setNull(12, 8);
            } else {
                this.ps.setDouble(12, hc.dmin);
            }
            if (Double.isNaN(hc.rms)) {
                this.ps.setNull(13, 8);
            } else {
                this.ps.setDouble(13, hc.rms);
            }
            if (hc.nstimes == null) {
                this.ps.setNull(14, 4);
            } else {
                this.ps.setInt(14, hc.nstimes);
            }
            if (Double.isNaN(hc.herr)) {
                this.ps.setNull(15, 8);
            } else {
                this.ps.setDouble(15, hc.herr);
            }
            if (Double.isNaN(hc.verr)) {
                this.ps.setNull(16, 8);
            } else {
                this.ps.setDouble(16, hc.verr);
            }
            if (hc.magtype == null) {
                this.ps.setNull(17, 12);
            } else {
                this.ps.setString(17, hc.magtype);
            }
            if (hc.rmk == null) {
                this.ps.setNull(18, 12);
            } else {
                this.ps.setString(18, hc.rmk);
            }
            this.ps.execute();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLHypocenterDataSource.insertHypocenter() failed.", e);
        }
    }
}

