/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.gps;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import gov.usgs.util.CodeTimer;
import gov.usgs.vdx.data.BinaryDataSet;
import gov.usgs.vdx.data.gps.DataPoint;
import gov.usgs.vdx.data.gps.GPS;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GPSData
implements BinaryDataSet {
    private static final DoubleFactory2D DENSE = DoubleFactory2D.dense;
    private static final DoubleFactory2D SPARSE = DoubleFactory2D.sparse;
    private static final DoubleMatrix2D I3X3 = DENSE.identity(3);
    private static final DoubleMatrix2D ZERO3X3 = DENSE.make(3, 3);
    private DoubleMatrix2D tData;
    private DoubleMatrix2D rData;
    private DoubleMatrix2D xyzData;
    private DoubleMatrix2D covData;
    private DoubleMatrix2D lenData;

    public GPSData() {
    }

    public GPSData(List pts) {
        this.setToList(pts);
    }

    public void setToList(List pts) {
        int rows = pts.size();
        DataPoint origin = (DataPoint)pts.get(0);
        boolean hasLen = !Double.isNaN(origin.len);
        this.tData = DENSE.make(rows, 1);
        this.rData = DENSE.make(rows, 1);
        this.xyzData = DENSE.make(rows * 3, 1);
        this.covData = SPARSE.make(rows * 3, rows * 3);
        this.lenData = DENSE.make(rows, 1);
        for (int i = 0; i < rows; ++i) {
            DataPoint dp = (DataPoint)pts.get(i);
            this.tData.setQuick(i, 0, dp.t);
            this.rData.setQuick(i, 0, dp.r);
            this.xyzData.setQuick(i * 3, 0, dp.x);
            this.xyzData.setQuick(i * 3 + 1, 0, dp.y);
            this.xyzData.setQuick(i * 3 + 2, 0, dp.z);
            this.covData.setQuick(i * 3, i * 3, dp.sxx);
            this.covData.setQuick(i * 3, i * 3 + 1, dp.sxy);
            this.covData.setQuick(i * 3, i * 3 + 2, dp.sxz);
            this.covData.setQuick(i * 3 + 1, i * 3, dp.sxy);
            this.covData.setQuick(i * 3 + 1, i * 3 + 1, dp.syy);
            this.covData.setQuick(i * 3 + 1, i * 3 + 2, dp.syz);
            this.covData.setQuick(i * 3 + 2, i * 3, dp.sxz);
            this.covData.setQuick(i * 3 + 2, i * 3 + 1, dp.syz);
            this.covData.setQuick(i * 3 + 2, i * 3 + 2, dp.szz);
            if (hasLen) {
                this.lenData.setQuick(i, 0, dp.len);
                continue;
            }
            double dx = dp.x - origin.x;
            double dy = dp.y - origin.y;
            double dz = dp.z - origin.z;
            this.lenData.setQuick(i, 0, Math.sqrt(dx * dx + dy * dy + dz * dz));
        }
    }

    public ByteBuffer toBinary() {
        int rows = this.observations();
        ByteBuffer bb = ByteBuffer.allocate(4 + rows * 12 * 8);
        bb.putInt(rows);
        for (int i = 0; i < rows; ++i) {
            bb.putDouble(this.tData.getQuick(i, 0));
            bb.putDouble(this.rData.getQuick(i, 0));
            bb.putDouble(this.xyzData.getQuick(i * 3, 0));
            bb.putDouble(this.xyzData.getQuick(i * 3 + 1, 0));
            bb.putDouble(this.xyzData.getQuick(i * 3 + 2, 0));
            bb.putDouble(this.covData.getQuick(i * 3, i * 3));
            bb.putDouble(this.covData.getQuick(i * 3 + 1, i * 3 + 1));
            bb.putDouble(this.covData.getQuick(i * 3 + 2, i * 3 + 2));
            bb.putDouble(this.covData.getQuick(i * 3 + 1, i * 3));
            bb.putDouble(this.covData.getQuick(i * 3 + 2, i * 3));
            bb.putDouble(this.covData.getQuick(i * 3 + 2, i * 3 + 1));
            bb.putDouble(this.lenData.getQuick(i, 0));
        }
        return bb;
    }

    public void fromBinary(ByteBuffer bb) {
        int rows = bb.getInt();
        this.tData = DENSE.make(rows, 1);
        this.rData = DENSE.make(rows, 1);
        this.xyzData = DENSE.make(rows * 3, 1);
        this.covData = SPARSE.make(rows * 3, rows * 3);
        this.lenData = DENSE.make(rows, 1);
        DataPoint dp = new DataPoint();
        for (int i = 0; i < rows; ++i) {
            dp.fromBinary(bb);
            this.tData.setQuick(i, 0, dp.t);
            this.rData.setQuick(i, 0, dp.r);
            this.xyzData.setQuick(i * 3, 0, dp.x);
            this.xyzData.setQuick(i * 3 + 1, 0, dp.y);
            this.xyzData.setQuick(i * 3 + 2, 0, dp.z);
            this.covData.setQuick(i * 3, i * 3, dp.sxx);
            this.covData.setQuick(i * 3, i * 3 + 1, dp.sxy);
            this.covData.setQuick(i * 3, i * 3 + 2, dp.sxz);
            this.covData.setQuick(i * 3 + 1, i * 3, dp.sxy);
            this.covData.setQuick(i * 3 + 1, i * 3 + 1, dp.syy);
            this.covData.setQuick(i * 3 + 1, i * 3 + 2, dp.syz);
            this.covData.setQuick(i * 3 + 2, i * 3, dp.sxz);
            this.covData.setQuick(i * 3 + 2, i * 3 + 1, dp.syz);
            this.covData.setQuick(i * 3 + 2, i * 3 + 2, dp.szz);
        }
    }

    public void setData(DoubleMatrix2D t, DoubleMatrix2D r, DoubleMatrix2D xyz, DoubleMatrix2D cov) {
        this.tData = t;
        this.rData = r;
        this.xyzData = xyz;
        this.covData = cov;
    }

    public int observations() {
        return this.tData.rows();
    }

    public void adjustTime(double adj) {
        for (int i = 0; i < this.tData.rows(); ++i) {
            this.tData.setQuick(i, 0, this.tData.getQuick(i, 0) + adj);
        }
    }

    public DoubleMatrix2D getTimes() {
        return this.tData;
    }

    public DoubleMatrix2D getRanks() {
        return this.rData;
    }

    public DoubleMatrix2D getXYZ() {
        return this.xyzData;
    }

    public DoubleMatrix2D getCovariance() {
        return this.covData;
    }

    public double[] getOrigin() {
        return new double[]{this.xyzData.get(0, 0), this.xyzData.get(1, 0), this.xyzData.get(2, 0)};
    }

    public void applyBaseline(GPSData baseline) {
        CodeTimer ct = new CodeTimer("applyBaseline");
        int si = 0;
        int bi = 0;
        ArrayList<DataPoint> data = new ArrayList<DataPoint>(this.observations());
        boolean done = false;
        while (!done) {
            double bt;
            double st = this.tData.getQuick(si, 0);
            if (Math.abs(st - (bt = baseline.tData.getQuick(bi, 0))) < 0.001) {
                DataPoint dp = new DataPoint();
                dp.t = st;
                dp.x = this.xyzData.getQuick(si * 3, 0) - baseline.xyzData.getQuick(bi * 3, 0);
                dp.y = this.xyzData.getQuick(si * 3 + 1, 0) - baseline.xyzData.getQuick(bi * 3 + 1, 0);
                dp.z = this.xyzData.getQuick(si * 3 + 2, 0) - baseline.xyzData.getQuick(bi * 3 + 2, 0);
                dp.sxx = this.covData.getQuick(si * 3, si * 3) + baseline.covData.getQuick(bi * 3, bi * 3);
                dp.syy = this.covData.getQuick(si * 3 + 1, si * 3 + 1) + baseline.covData.getQuick(bi * 3 + 1, bi * 3 + 1);
                dp.szz = this.covData.getQuick(si * 3 + 2, si * 3 + 2) + baseline.covData.getQuick(bi * 3 + 2, bi * 3 + 2);
                dp.sxy = this.covData.getQuick(si * 3, si * 3 + 1) + baseline.covData.getQuick(bi * 3, bi * 3 + 1);
                dp.sxz = this.covData.getQuick(si * 3, si * 3 + 2) + baseline.covData.getQuick(bi * 3, bi * 3 + 2);
                dp.syz = this.covData.getQuick(si * 3 + 1, si * 3 + 2) + baseline.covData.getQuick(bi * 3 + 1, bi * 3 + 2);
                dp.len = Math.sqrt(dp.x * dp.x + dp.y * dp.y + dp.z * dp.z);
                data.add(dp);
                ++si;
                ++bi;
            } else if (st < bt) {
                while (++si < this.tData.rows() && this.tData.getQuick(si, 0) < baseline.tData.getQuick(bi, 0)) {
                }
                if (si == this.tData.rows()) {
                    done = true;
                }
            } else {
                while (++bi < baseline.tData.rows() && baseline.tData.getQuick(bi, 0) < this.tData.getQuick(si, 0)) {
                }
                if (bi == baseline.tData.rows()) {
                    done = true;
                }
            }
            if (si != this.tData.rows() && bi != baseline.tData.rows()) continue;
            done = true;
        }
        if (data.size() > 0) {
            this.setToList(data);
        }
        ct.stop();
    }

    public void toENU(double lon, double lat) {
        CodeTimer ct = new CodeTimer("fast toENU");
        DoubleMatrix2D t = GPS.createENUTransform(lon, lat);
        DoubleMatrix2D tt = t.viewDice();
        DoubleMatrix2D[][] xyz = new DoubleMatrix2D[this.observations()][1];
        DoubleMatrix2D[][] cov = new DoubleMatrix2D[this.observations()][this.observations()];
        for (int i = 0; i < this.observations(); ++i) {
            xyz[i][0] = Algebra.DEFAULT.mult(t, this.xyzData.viewPart(i * 3, 0, 3, 1));
            cov[i][i] = Algebra.DEFAULT.mult(Algebra.DEFAULT.mult(t, this.covData.viewPart(i * 3, i * 3, 3, 3)), tt);
        }
        this.xyzData = DENSE.compose(xyz);
        this.covData = SPARSE.compose(cov);
        ct.stop();
    }

    public DoubleMatrix2D toTimeSeries(GPSData baseline) {
        double[] origin = this.getOrigin();
        double[] originLLH = GPS.xyz2LLH(origin[0], origin[1], origin[2]);
        if (baseline != null) {
            this.applyBaseline(baseline);
        }
        this.toENU(originLLH[0], originLLH[1]);
        DoubleMatrix2D enuRows = GPS.column3NToRows(this.xyzData);
        DoubleMatrix2D bigMatrix = DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.tData, this.rData, enuRows, this.lenData}});
        return bigMatrix;
    }

    public DoubleMatrix2D createVelocityKernel() {
        double t0 = this.tData.getQuick(0, 0);
        DoubleMatrix2D[][] g = new DoubleMatrix2D[this.observations()][2];
        for (int i = 0; i < this.observations(); ++i) {
            double ta = (this.tData.getQuick(i, 0) - t0) / 3.15576E7;
            DoubleMatrix2D temp = DENSE.make(3, 3);
            temp.setQuick(0, 0, ta);
            temp.setQuick(1, 1, ta);
            temp.setQuick(2, 2, ta);
            g[i][0] = temp;
            g[i][1] = I3X3;
        }
        return SPARSE.compose(g);
    }

    public DoubleMatrix2D createDisplacementKernel(double dt) {
        DoubleMatrix2D[][] g = new DoubleMatrix2D[this.observations()][2];
        for (int i = 0; i < this.observations(); ++i) {
            g[i][0] = this.tData.getQuick(i, 0) < dt ? ZERO3X3 : I3X3;
            g[i][1] = I3X3;
        }
        return SPARSE.compose(g);
    }

    public DoubleMatrix2D createDetrendedDisplacementKernel(double dt) {
        double t0 = this.tData.getQuick(0, 0);
        DoubleMatrix2D[][] g = new DoubleMatrix2D[this.observations()][3];
        for (int i = 0; i < this.observations(); ++i) {
            g[i][0] = this.tData.getQuick(i, 0) < dt ? ZERO3X3 : I3X3;
            double ta = (this.tData.getQuick(i, 0) - t0) / 3.15576E7;
            DoubleMatrix2D temp = DENSE.make(3, 3);
            temp.setQuick(0, 0, ta);
            temp.setQuick(1, 1, ta);
            temp.setQuick(2, 2, ta);
            g[i][1] = temp;
            g[i][2] = I3X3;
        }
        return SPARSE.compose(g);
    }

    public DataPoint getFirstObservation() {
        if (this.observations() <= 0) {
            return null;
        }
        DataPoint dp = new DataPoint();
        dp.t = this.tData.getQuick(0, 0);
        dp.r = this.rData.getQuick(0, 0);
        dp.x = this.xyzData.getQuick(0, 0);
        dp.y = this.xyzData.getQuick(1, 0);
        dp.z = this.xyzData.getQuick(2, 0);
        dp.len = this.lenData.getQuick(0, 0);
        dp.sxx = this.covData.getQuick(0, 0);
        dp.syy = this.covData.getQuick(1, 1);
        dp.szz = this.covData.getQuick(2, 2);
        dp.sxy = this.covData.getQuick(0, 1);
        dp.sxz = this.covData.getQuick(0, 2);
        dp.syz = this.covData.getQuick(1, 2);
        return dp;
    }

    public void output() {
        for (int i = 0; i < this.observations(); ++i) {
            System.out.println(this.tData.getQuick(i, 0));
            System.out.println(this.rData.getQuick(i, 0));
            System.out.println("\t" + this.xyzData.getQuick(i * 3, 0) + " " + this.xyzData.getQuick(i * 3 + 1, 0) + " " + this.xyzData.getQuick(i * 3 + 2, 0) + " " + this.lenData.getQuick(i, 0));
            System.out.println("\t\t" + this.covData.getQuick(i * 3 + 0, i * 3) + " " + this.covData.getQuick(i * 3 + 0, i * 3 + 1) + " " + this.covData.getQuick(i * 3 + 0, i * 3 + 2) + " ");
            System.out.println("\t\t" + this.covData.getQuick(i * 3 + 1, i * 3) + " " + this.covData.getQuick(i * 3 + 1, i * 3 + 1) + " " + this.covData.getQuick(i * 3 + 1, i * 3 + 2) + " ");
            System.out.println("\t\t" + this.covData.getQuick(i * 3 + 2, i * 3) + " " + this.covData.getQuick(i * 3 + 2, i * 3 + 1) + " " + this.covData.getQuick(i * 3 + 2, i * 3 + 2) + " ");
        }
    }

    public void outputRawData(String fn, String extra) {
    }
}

