/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDataSourceHandler {
    private static final String CONFIG_FILE = "vdxSources.config";
    protected Logger logger;
    protected Map<String, SQLDataSourceDescriptor> sqlDataSources;
    private ConfigFile config;
    private String driver;
    private String url;
    private String prefix;

    public SQLDataSourceHandler(String d, String u, String p) {
        this.driver = d;
        this.url = u;
        this.prefix = p;
        this.logger = Log.getLogger("gov.usgs.vdx");
        this.sqlDataSources = new HashMap<String, SQLDataSourceDescriptor>();
        this.processConfigFile();
    }

    public void processConfigFile() {
        this.config = new ConfigFile(CONFIG_FILE);
        List<String> sources = this.config.getList("source");
        for (String source : sources) {
            ConfigFile sub = this.config.getSubConfig(source);
            String className = sub.getString("class");
            String description = sub.getString("description");
            sub.put("vdx.driver", this.driver);
            sub.put("vdx.url", this.url);
            sub.put("vdx.prefix", this.prefix);
            SQLDataSourceDescriptor dsd = new SQLDataSourceDescriptor(source, className, description, sub);
            this.sqlDataSources.put(source, dsd);
            this.logger.fine("read data source: " + source);
        }
    }

    public ConfigFile getConfig() {
        return this.config;
    }

    public SQLDataSourceDescriptor getDataSourceDescriptor(String key) {
        return this.sqlDataSources.get(key);
    }

    public List<SQLDataSourceDescriptor> getDataSources() {
        ArrayList<SQLDataSourceDescriptor> result = new ArrayList<SQLDataSourceDescriptor>();
        result.addAll(this.sqlDataSources.values());
        return result;
    }
}

