/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.NetTools;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BroadcastServer {
    protected String name = "Server";
    protected int port = -1;
    protected int maxConnections = 20;
    protected int connections = 0;
    protected Logger logger;
    protected NetTools netTools;
    protected List<SocketChannel> currentConnections;

    public BroadcastServer(String n, int p) {
        this.name = n;
        this.port = p;
        this.currentConnections = Collections.synchronizedList(new ArrayList());
        this.logger = Log.getLogger("gov.usgs.net");
        this.netTools = new NetTools();
    }

    public static String getHost(SocketChannel channel) {
        if (channel == null || channel.socket() == null || channel.socket().getInetAddress() == null) {
            return "(closed)";
        }
        return channel.socket().getInetAddress().getHostAddress();
    }

    public void log(Level level, String msg, SocketChannel channel) {
        String channelString = channel == null ? "" : BroadcastServer.getHost(channel) + "/";
        String logMsg = channelString + msg;
        this.logger.log(level, logMsg);
    }

    protected void closeConnection(SocketChannel channel, SelectionKey selectionKey) {
        try {
            this.currentConnections.remove(channel);
            channel.close();
            selectionKey.cancel();
            selectionKey.selector().wakeup();
            selectionKey.attach(null);
            this.connectionClosed(channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectionClosed(SocketChannel channel) {
        --this.connections;
        this.log(Level.FINE, "Connection closed: " + this.connections + "/" + this.maxConnections + ".", channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String msg) {
        List<SocketChannel> list = this.currentConnections;
        synchronized (list) {
            for (SocketChannel ch : this.currentConnections) {
                this.netTools.writeString(msg, ch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBinary(byte[] buf) {
        this.logger.log(Level.FINER, "Broadcast: " + Util.bytesToHex(buf));
        List<SocketChannel> list = this.currentConnections;
        synchronized (list) {
            for (SocketChannel ch : this.currentConnections) {
                this.netTools.writeByteBuffer(ByteBuffer.wrap(buf), ch);
            }
        }
    }

    public void startListening() {
        if (this.port == -1) {
            return;
        }
        try {
            Selector selector = Selector.open();
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().bind(new InetSocketAddress(this.port));
            serverChannel.register(selector, 16);
            this.logger.info("listening on port " + this.port + ".");
            block2: while (true) {
                selector.select();
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (true) {
                    if (!it.hasNext()) continue block2;
                    SelectionKey selKey = it.next();
                    it.remove();
                    if (selKey.isAcceptable()) {
                        ServerSocketChannel ssChannel = (ServerSocketChannel)selKey.channel();
                        SocketChannel channel = ssChannel.accept();
                        ++this.connections;
                        if (this.maxConnections != 0 && this.connections > this.maxConnections) {
                            channel.close();
                            --this.connections;
                            continue;
                        }
                        this.log(Level.FINE, "Connection accepted: " + this.connections + "/" + this.maxConnections + ".", channel);
                        channel.configureBlocking(false);
                        channel.register(selector, 1);
                        this.currentConnections.add(channel);
                    }
                    if (!selKey.isReadable()) continue;
                    SocketChannel channel = (SocketChannel)selKey.channel();
                    this.closeConnection(channel, selKey);
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Fatal exception.", e);
            return;
        }
    }

    public static void main(String[] args) {
        final BroadcastServer bs = new BroadcastServer("Random number server", 16000);
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    bs.sendMessage("Random: " + Math.random() + "\n");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        });
        t.start();
        bs.startListening();
    }
}

