/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm.vdx;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.WaveServer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDXWaveServerSource
implements DataSource {
    private String host;
    private int port;
    private int timeout;
    private WaveServer waveServer;

    @Override
    public String getType() {
        return "wave";
    }

    @Override
    public void initialize(ConfigFile params) {
        this.host = params.getString("host");
        this.port = Integer.parseInt(params.getString("port"));
        this.timeout = Integer.parseInt(params.getString("timeout"));
        this.waveServer = new WaveServer(this.host, this.port);
        this.waveServer.setTimeout(this.timeout);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action != null && action.equals("selectors")) {
            Menu menu = this.waveServer.getMenuSCNL();
            List<MenuItem> stations = menu.getSortedItems();
            ArrayList<String> result = new ArrayList<String>(stations.size());
            for (int i = 0; i < stations.size(); ++i) {
                MenuItem mi = stations.get(i);
                result.add(mi.getSCN() + ":-999:-999:" + mi.getSCN() + ":" + mi.getSCN());
            }
            return new TextResult(result);
        }
        double t1 = Double.parseDouble(params.get("st"));
        double t2 = Double.parseDouble(params.get("et"));
        String code = params.get("selector");
        if (code == null) {
            return null;
        }
        String[] ss = code.split("_");
        if (ss.length < 3) {
            return null;
        }
        String sta = ss[0];
        String cha = ss[1];
        String net = ss[2];
        String loc = null;
        if (ss.length >= 4) {
            loc = ss[3];
        }
        this.waveServer.connect();
        Wave sw = this.waveServer.getRawData(sta, cha, net, loc, Util.j2KToEW(t1), Util.j2KToEW(t2));
        if (sw != null) {
            sw.convertToJ2K();
        }
        this.waveServer.close();
        return new BinaryResult(sw);
    }
}

