/**PickEWAnalysis attempts to replicate the behavior of pick_ew to assist
 * the tuning of a seismic network.
 *
 * This application reads the settings from a station file and retrieves data
 * from a waveserver. It presents the following data
 * in a graphical form:
 * - Original trace
 * - Filtered trace: This is the the data after filtering with RawDataFilt
 * - STA and LTA: These are the short and long term averages of the characteristic funcion
 * - STA/LTA: This is the STA/LTA ratio, that starts the picking routine
 * - An approximation of the picks that would be generated by pick_ew on the
 * selected patch of data, with information on the first motion, weight and coda length
 *
 * The code presented in the class PickAnalysis.java has been copied almost directly
 * from the pick_ew code of Earthworm 7.3.
 *
 * This program is free software: you can redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 *
 * Revision History:
 *
 * 2010.03.09:
 * - Bug report by Mitchell Gold - Corrected the calculation of pick arrival times
 * by introducing the appropriate sampling rate.
 * - Suggestion by Mitchell Gold - Output pick arrival times to the console
 *
 * 2009.12.08:
 * - Bug report by Paul Fridberg - Changed windows look and feel to accomodate other OS
 *
 * 2009.12.02:
 * - First working version
 *
 **/

package pick_ew_analysis;

import javax.swing.UIManager;

public class Main {
    public static Config config; // Configuration object

    public static void main(String[] args) {
        /* Set time zone to UTC */
        System.setProperty("user.timezone","Etc/Universal");

        /* Load current configuration from file */
        config = Config.loadConfig();
        /* Load station file, if available */
        if (config.StationFile!=null)
            config.channels = config.readStationFile();

        /* Set default look and feel */
        try {
            /* Setting default look and feel
             * instead of windows look and feel.
             * Bug reported by Paul Fridberg - 2009.12.08
             */
            //UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception ex) {
            //Using the default look and feel...
        }

        /* Start GUI */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                MainWindow mainwindow = new MainWindow();
                mainwindow.setLocationRelativeTo(null);
                mainwindow.startup();
                mainwindow.setVisible(true);
            }
        });

    } //end main
}
