package pick_ew_analysis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;

/*
 * A set of functions to draw traces on a pane
 */

public class DrawUtils {


    public static double[] drawTrace(javax.swing.JPanel panel, double[] x, double[] y, Color color, double[] scale) {
        //If the scale is null, compute required scales
        double[] outScale;
        if ((scale == null)||(scale.length != 4)) {
            //Get maximum and minimum y value
            double yMax = Double.NEGATIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            if (scale==null) {
                for (int i=0; i<y.length; i++) {
                    if (y[i] > yMax) yMax = y[i];
                    if (y[i] < yMin) yMin = y[i];
                }
            } else {
                for (int i=0; i<y.length; i++) {
                    if (scale[i] > yMax) yMax = scale[i];
                    if (scale[i] < yMin) yMin = scale[i];
                }
            }
            outScale = new double[4];
            outScale[0] = x[0];
            outScale[1] = x[x.length-1];
            outScale[2] = yMin;
            outScale[3] = yMax;
        } else {
            outScale = scale;
        }

        //Compute x and y conversion factors
        double width = (double)panel.getWidth();
        double height = (double)panel.getHeight();
        double xConv = (width)/(outScale[1] - outScale[0]);
        double yConv = (height)/(outScale[3] - outScale[2]);

        //Compute plotted x and y values
        int[] xP = new int[x.length];
        int[] yP = new int[y.length];
        for (int i=0; i<x.length; i++) {
            xP[i] = (int)((x[i] - outScale[0]) * xConv);
            yP[i] = (int)(height) - (int)((y[i] - outScale[2]) * yConv);
        }

        //Plot data on panel
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        gr.setColor(color);
        gr.drawPolyline(xP, yP, xP.length);

        return outScale;
    }



    public static void clearPanel(javax.swing.JPanel panel, Color color) {
        int width = panel.getWidth();
        int height = panel.getHeight();
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        if (color!=null) {
            gr.setBackground(color);
        } else {
            gr.setBackground(Color.WHITE);
        }
        gr.clearRect(1, 1, width-2, height-2);
    }



    public static void drawFullHorizontalLine(javax.swing.JPanel panel, double y, Color color, double[] scale) {
        //Get limits of panel
        int width = panel.getWidth();
        int height = panel.getHeight();

        //Compute value for panel
        double yConv = (double)(height)/(scale[3] - scale[2]);
        int yP = height - (int)((y - scale[2]) * yConv);
        
        //Plot data on panel
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        gr.setColor(color);
        gr.drawLine(1, yP, width-2, yP);
    }

    public static void drawFullVerticalLine(javax.swing.JPanel panel, double x, Color color, double[] scale) {
        //Get limits of panel
        int width = panel.getWidth();
        int height = panel.getHeight();

        //Compute value for panel
        double xConv = (width)/(scale[1] - scale[0]);
        int xP = (int)((x - scale[0]) * xConv);

        //Plot data on panel
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        gr.setColor(color);
        gr.drawLine(xP, 1, xP, height-2);
    }

    public static void drawTransparentRect(javax.swing.JPanel panel, double x1, double xwidth, Color color, double[] scale) {
        //Get limits of panel
        int width = panel.getWidth();
        int height = panel.getHeight();

        //Compute value for panel
        double xConv = width/(scale[1] - scale[0]);
        int xP1 = (int)((x1 - scale[0]) * xConv);
        int xP2 = (int)((x1 + xwidth - scale[0]) * xConv);
        int rwidth = xP2 - xP1;

        //Create rectangle
        Rectangle rect = new Rectangle(xP1, 1, rwidth, height-2);

        //Plot data on panel
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        Composite originalComposite = gr.getComposite();
        gr.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.2f));
        gr.setPaint(color);
        gr.fill(rect);
        gr.setComposite(originalComposite);
    }


    public static void drawBaseRect(javax.swing.JPanel panel) {
        //Get limits of panel
        int width = panel.getWidth();
        int height = panel.getHeight();
        //Plot base rectangle
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        gr.setColor(Color.BLACK);
        gr.drawRect(0, 0, width-1, height-1);
    }


    public static void drawFstMotion(javax.swing.JPanel panel, String txt, double x, Color color, double[] scale) {
        if (color==null) color = Color.BLACK;
        //Get limits of panel
        int width = panel.getWidth();
        int height = panel.getHeight();

        //Compute value for panel
        double xConv = (width-2)/(scale[1] - scale[0]);
        int xP = (int)((x - scale[0]) * xConv);

        //Plot text
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        gr.setColor(color);
        gr.setFont(new Font("Arial", Font.PLAIN, 10));
        gr.drawString(txt, xP+3, 12);
    }


    public static void drawVerticalLine(javax.swing.JPanel panel, double x, double y1, double y2, Color color, double[] scale) {
        //Get limits of panel
        int width = panel.getWidth();
        int height = panel.getHeight();

        //Compute horizontal position
        double xConv = (width-2)/(scale[1] - scale[0]);
        int xP = (int)((x - scale[0]) * xConv);

        //Compute vertical position
        double yConv = (double)(height)/(scale[3] - scale[2]);
        int y1P = height - (int)((y1 - scale[2]) * yConv);
        int y2P = height - (int)((y2 - scale[2]) * yConv);

        //Plot
        Graphics2D gr = (Graphics2D)panel.getGraphics();
        gr.setColor(color);
        gr.drawLine(xP, y1P, xP, y2P);

    }
}
