# Create an Earthworm environment on Linux!
# This file should be sourced by a bourne shell wanting 
# to run or build an EARTHWORM system under Linux.

# IMPORTANT NOTE, if running on a 64 bit linux system, long's can be 8 bytes and not 4 bytes!
# If this is the case, be sure to compile with the -m32 flag in the GLOBALFLAGS section!!!!

# Set environment variables describing your Earthworm directory/version

# Use value from elsewhere if defined (eg from .bashrc)
export EW_HOME="${EW_INSTALL_HOME:-/home/paulf}"
export EW_VERSION="${EW_INSTALL_VERSION:-earthworm}"
EW_RUN_DIR="${EW_RUN_DIR:-$EW_HOME/run_working}"
# Or set your own value directly
#export EW_HOME=/earthworm
#export EW_VERSION=earthworm_7.4

export SYS_NAME=`hostname`


# Set environment variables used by earthworm modules at run-time
# Path names must end with the slash "/"
export EW_INSTALLATION=INST_UNKNOWN
export EW_PARAMS="$EW_RUN_DIR/params/"
export EW_LOG="$EW_RUN_DIR/logs/"


# Tack the earthworm bin directory in front of the current path
# Also add Oracle paths to the current path.
#set path=( ${EW_HOME}/${EW_VERSION}/bin /opt/oracle/bin /var/opt/oracle $path )
export PATH="$EW_HOME/$EW_VERSION/bin:$PATH"

# Set up library path for dynamically loaded libraries:
#export OPENWINHOME   /usr/openwin
#export ORACLE_HOME   /opt/oracle
#export COMPILER_DIR /opt/SUNWspro
#export LD_LIBRARY_PATH="${OPENWINHOME}/lib:${ORACLE_HOME}/lib:${COMPILER_DIR}/lib:/usr/lib"

export GLOBALFLAGS="-D_SPARC -D_SOLARIS -I${EW_HOME}/${EW_VERSION}/include"


export KEEP_STATE=""

# Set initial defaults
export CFLAGS=$GLOBALFLAGS
export CPPFLAGS=$GLOBALFLAGS
# be explicit about which compiler to use
export CC=`which cc`

# Auto-detect fortran compiler and flags
if which f77 1> /dev/null 2>&1
then
    export FC=`which f77`
fi

# Alternatively, you can hard-code values here:
#export FC='...'
#export FFLAGS='...'
