/*
 * Standalone program to read MSEED data files and write
 * earthworm TRACE_BUF2 messages.

 * this was based on ms2tb that used qlib2 functions, but was switched to libmseed (from Chad Trabant)
 * because that library is easily supported under windows.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mseed2tank.h"

/* Internal Function Prototypes */
void usage( char * );
#define MAX_4BYTE_SAMPS_TBUF 1008
#define DEFAULT_MAX_SAMPS 200

#define MS2TANK_VERSION_NUMBER "0.0.2 2008.04.24"

int main(int argc, char **argv)
{
  char *MSfile;
  int max_samps = DEFAULT_MAX_SAMPS;
  int arg = 1;
  
  if (argc < 2)
    usage( argv[0] );

  while (arg < argc && argv[arg][0] == '-')
  {
    switch(argv[arg][1])
    {
    case 'n':
      arg++;
      max_samps = atoi(argv[arg]);
      if (max_samps > MAX_4BYTE_SAMPS_TBUF) {
		usage(argv[0]);
      }
      break;
    default:
      usage( argv[0] );
    }
    arg++;
  }
  if (argc - arg != 1)
    usage( argv[0] );
  
  MSfile = argv[arg];
  arg++;
  
  return(convert_mseed_to_tank(MSfile, "stdout",  max_samps));
}


void usage( char *argv0 )
{
  fprintf(stderr, "Usage: %s [-n maxsamples] miniseed_inputfile >> outfile\n", argv0);
  fprintf(stderr, "Version %s\n", MS2TANK_VERSION_NUMBER);
  fprintf(stderr, " -n maxsamples - the max number of samps per tracebuf, \n\tdefaults to 200 per tbuf, cannot be larger than 1008\n");
  exit( 1 );
}
  
