/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * PickList.java
 *
 * Created on 22/Dez/2009, 16:13:33
 */
package pick_ew_analysis;

import javax.swing.DefaultListModel;

/**
 *
 * @author RL197718
 */
public class PickList extends javax.swing.JFrame {

    /** Creates new form PickList */
    public PickList() {
        initComponents();
        //computePicks();
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        pickList = new javax.swing.JList();
        menuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        saveMenuItem = new javax.swing.JMenuItem();
        saveAsMenuItem = new javax.swing.JMenuItem();
        exitMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowActivated(java.awt.event.WindowEvent evt) {
                formWindowActivated(evt);
            }
        });

        pickList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(pickList);

        fileMenu.setText("File");

        openMenuItem.setText("Open");
        fileMenu.add(openMenuItem);

        saveMenuItem.setText("Save");
        fileMenu.add(saveMenuItem);

        saveAsMenuItem.setText("Save As ...");
        fileMenu.add(saveAsMenuItem);

        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        setJMenuBar(menuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 293, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(26, Short.MAX_VALUE)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 222, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(31, 31, 31))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        dispose();
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void formWindowActivated(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowActivated
        //computePicks();
    }//GEN-LAST:event_formWindowActivated

    public void computePicks() {
        DefaultListModel picklist = new DefaultListModel();
        for (int i = 0; i < Main.config.channels.length; i++) {
            System.out.println(Main.config.channels[i].S + " " + Main.config.channels[i].C);
            boolean deleteOldTrace = false;

            if (Main.config.channels[i].getTrace()==null)
                deleteOldTrace = true;

            //Retrieve data for this channel
            if (Main.config.channels[i].setTrace()) {
                //Initialize computations
                Main.config.channels[i].getTrace().getSamples();
                Main.config.channels[i].getTrace().getTime();

                //Compute picks
                PickAnalysis pickanalysis = new PickAnalysis(Main.config.channels[i]);
                double[] pickTimes = pickanalysis.getPickTimes();
                if (pickTimes != null) {
                    System.out.println(pickTimes.length);

                    for (int f=0; i<pickTimes.length; f++) {
                        String pickString = String.valueOf(pickTimes[f]);
                        picklist.addElement(pickString);
                    }
                }

                if (deleteOldTrace)
                    Main.config.channels[i].releaseTrace();
            }
        }
        pickList.setModel(picklist);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem openMenuItem;
    private javax.swing.JList pickList;
    private javax.swing.JMenuItem saveAsMenuItem;
    private javax.swing.JMenuItem saveMenuItem;
    // End of variables declaration//GEN-END:variables
}
