package pick_ew_analysis;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class Config implements java.io.Serializable {

    //WaveServer Settings
    public String ServerIP = "10.19.6.40";
    public int ServerPort = 16022;
    //EW Info
    public String StationFile = null;
    public Channel[] channels = null;
    //Trace data
    public int SelectedStation = 0;
    public double endtime = 0;//(double)(System.currentTimeMillis())/1000 - 60;
    public double starttime = 0;//endtime - 30;

    public Channel getStation(int s) {
        if ((s >= 0) && (channels.length > 0) && (channels.length > s)) {
            return channels[s];
        }
        return null;
    }

    public Channel[] readStationFile() {
        Vector<Channel> tempChan = new Vector<Channel>();
        Channel[] output = null;
        try {
            BufferedReader finput = new BufferedReader(new FileReader(StationFile));
            String command = "";
            while ((command = finput.readLine()) != null) {
                //Shell comment
                if (((command.length() > 0) && (command.trim().substring(0, 1).equals("#"))) ||
                        (command.trim().length() == 0)) {
                    continue;
                }
                //Process command
                String[] parts = command.trim().split("[\\s]+");
                if (!processCommand(parts)) {
                    System.err.println("Failed setting configuration command: " + command);
                    finput.close();
                    return null;
                } else {
                    try {
                        if (parts.length == 24) {
                            tempChan.add(new Channel(parts[2], parts[3], parts[4], parts[5],
                                    Double.valueOf(parts[6]),
                                    Double.valueOf(parts[7]),
                                    Double.valueOf(parts[8]),
                                    Double.valueOf(parts[9]),
                                    Double.valueOf(parts[10]),
                                    Double.valueOf(parts[11]),
                                    Double.valueOf(parts[12]),
                                    Double.valueOf(parts[13]),
                                    Double.valueOf(parts[14]),
                                    Double.valueOf(parts[15]),
                                    Double.valueOf(parts[16]),
                                    Double.valueOf(parts[17]),
                                    Double.valueOf(parts[18]),
                                    Double.valueOf(parts[19]),
                                    Double.valueOf(parts[20]),
                                    Double.valueOf(parts[21]),
                                    Double.valueOf(parts[22]),
                                    Double.valueOf(parts[23]),
                                    parts[0], parts[1]));
                        }
                        if (parts.length == 23) {
                            tempChan.add(new Channel(parts[2], parts[3], parts[4], parts[5],
                                    Double.valueOf(parts[6]),
                                    Double.valueOf(parts[7]),
                                    Double.valueOf(parts[8]),
                                    Double.valueOf(parts[9]),
                                    Double.valueOf(parts[10]),
                                    Double.valueOf(parts[11]),
                                    Double.valueOf(parts[12]),
                                    Double.valueOf(parts[13]),
                                    Double.valueOf(parts[14]),
                                    Double.valueOf(parts[15]),
                                    Double.valueOf(parts[16]),
                                    Double.valueOf(parts[17]),
                                    Double.valueOf(parts[18]),
                                    Double.valueOf(parts[19]),
                                    Double.valueOf(parts[20]),
                                    Double.valueOf(parts[21]),
                                    Double.valueOf(parts[22]),
                                    8388608.0,
                                    parts[0], parts[1]));
                        }
                    } catch (Exception e) {
                        return null;
                    }
                }
            }
            if (tempChan.size() > 0) {
                output = new Channel[tempChan.size()];
                for (int i = 0; i < output.length; i++) {
                    output[i] = tempChan.elementAt(i);
                }
                return output;
            } else {
                return null;
            }
        } catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    private boolean processCommand(String[] parts) {
        //Check number of parts
        if (parts.length < 23) {
            return false;
        }
        return true;
    }

    public DefaultListModel getChannelList() {
        DefaultListModel output = new DefaultListModel();
        if (channels != null) {
            for (int i = 0; i < channels.length; i++) {
                output.addElement(channels[i].getSCNL());
            }
        }
        return output;
    }

    public static void saveConfig(Config config) {
        //Clear channel information
        config.channels = null;
        try {
            FileOutputStream f = new FileOutputStream("config.cfg");
            ObjectOutputStream obj_out = new ObjectOutputStream(f);
            obj_out.writeObject(config);
        } catch (Exception e) {
            System.err.println("Unable to save configuration: " + e);
        }
    }

    public static Config loadConfig() {
        Config config;
        try {
            FileInputStream f = new FileInputStream("config.cfg");
            ObjectInputStream obj = new ObjectInputStream(f);
            Object rawObj = obj.readObject();
            config = (Config) rawObj;
        } catch (Exception e) {
            /* Removing the error message, too much confusion */
            //System.err.println("Unable to load configuration: " + e);
            config = new Config();
        }
        return config;
    }
}
