package pick_ew_analysis;

import java.util.Vector;

public class PickAnalysis {

    private PickCalculator p;

    PickAnalysis(Channel channel) {
        p = new PickCalculator(channel);
    }

    public double[] getPickTimes() {
        if (p.picks.size() < 1) {
            return null;
        }
        double[] output = new double[p.picks.size()];
        for (int i = 0; i < output.length; i++) {
            output[i] = p.picks.elementAt(i).time;
        }
        return output;
    }

    public double[] getPickCodas() {
        if (p.picks.size() < 1) {
            return null;
        }
        double[] output = new double[p.picks.size()];
        for (int i = 0; i < output.length; i++) {
            output[i] = p.picks.elementAt(i).codalen;
        }
        return output;
    }

    public String[] getFstMotions() {
        if (p.picks.size() < 1) {
            return null;
        }
        String[] output = new String[p.picks.size()];
        for (int i = 0; i < output.length; i++) {
            output[i] = p.picks.elementAt(i).FirstMotion
                    + String.valueOf(p.picks.elementAt(i).weight);
        }
        return output;
    }

    public double[] getFailedPickTimes() {
        if (p.failedpicks.size() < 1) {
            return null;
        }
        double[] output = new double[p.failedpicks.size()];
        for (int i = 0; i < output.length; i++) {
            output[i] = p.failedpicks.elementAt(i).time;
        }
        return output;
    }

    public String[] getFailedPickCause() {
        if (p.failedpicks.size() < 1) {
            return null;
        }
        String[] output = new String[p.failedpicks.size()];
        for (int i = 0; i < output.length; i++) {
            output[i] = p.failedpicks.elementAt(i).cause;
        }
        return output;
    }

    /* CLASS TO CALCULATE THE PICKS FROM PICK_EW */
    private class PickCalculator {

        Channel channel;
        double[] samp;
        double starttime;
        double samprate;
        //Define Variables
        int sa = 0;
        int coda_status = 0;
        int pick_status = 0;
        //STATION
        double cocrit = 0;
        double crtinc = 0;
        double ecrit = 0;
        int evlen = 0;
        int isml = 0;
        int k = 0;
        int m = 1;
        int mint = 0;
        int ndrt = 0;
        int next = 0;
        int nzero = 0;
        double rbig = 0;
        double rlast = 0;
        double rsrdat = 0;
        int[] sarray = new int[10];
        double tmax = 0;
        int xdot = 0;
        double xfrz = 0;
        //CODA
        int[] aav = new int[6];
        int len_sec;
        int len_out = 0;
        int len_win = 0;
        //PICK
        double[] xpk = new double[3];
        String FirstMotion;
        int weight;
        //Pick return
        Vector<Pick> picks = new Vector<Pick>();
        Vector<FailedPick> failedpicks = new Vector<FailedPick>();
        double possiblePickTime = 0;
        //Sample
        double rdat = 0;
        double rold = 0;
        double esta = 0;
        double elta = 0;
        double eref = 0;
        double eabs = 0;

        PickCalculator(Channel channel) {
            this.channel = channel;
            this.samp = channel.getTrace().getBaseSamp();
            this.starttime = channel.getTrace().getBaseTime()[0];
            this.samprate = channel.getTrace().getSampRate();


            //Process initial samples
            int RestartLength = 100;
            while (--RestartLength != 0) {
                Sample(++sa);
            }

            while (sa < samp.length) {
                //System.out.println("Search mode.");
                int event_found = ScanForEvent();
                int saevent = sa;
                int event_active = 0;
                if (event_found == 1) {

                    //System.out.println("Event found.");

                    event_active = EventActive();
                    //System.out.println(event_active);

                    if (event_active == -1) {
                        //Coda too short. Event aborted.
                        failedpicks.add(new FailedPick(channel.getTrace().getBaseTime()[saevent],
                                "1"));
                    }

                    if (event_active == -2) {
                        //No recent zero crossings. Event aborted.
                        failedpicks.add(new FailedPick(channel.getTrace().getBaseTime()[saevent],
                                "2"));
                    }

                    if (event_active == -3) {
                        //Noise pick. Event aborted.
                        //System.out.println("Noise Pick");
                        failedpicks.add(new FailedPick(channel.getTrace().getBaseTime()[saevent],
                                "3"));
                    }

                    //if (event_active == 0)
                    //System.out.println("Event over. Picks/codas reported.");

                }
            }
        }

        private void Sample(int sa) {
            rold = rdat;

            rdat = (rdat * channel.RawDataFilt)
                    + (samp[sa] - samp[sa - 1]) + 1e-10;

            double rdif = rdat - rold;

            double edat = rdat * rdat + (channel.CharFuncFilt * rdif * rdif);

            esta += channel.StaFilt * (edat - esta);

            elta += channel.LtaFilt * (edat - elta);

            eref = elta * channel.EventThresh;

            eabs = (channel.RmavFilt * eabs)
                    + ((1 - channel.RmavFilt) * Math.abs(rdat));

        }

        private int ScanForEvent() {

            while (++sa < samp.length) {
                //Update sample
                double old_eref = eref;
                Sample(sa);

                //Check DeadSta
                if (eabs > channel.DeadSta) {
                    continue;
                }

                //Check EventThresh
                if (esta > eref) {
                    possiblePickTime = starttime + (double) (sa) / samprate;

                    //Prepare variables
                    len_win = 0;
                    len_sec = 0;

                    for (int wi = 0; wi < aav.length; wi++) {
                        aav[wi] = 0;
                    }

                    crtinc = eref / channel.Erefs;
                    ecrit = old_eref;
                    evlen = 0;
                    isml = 0;
                    k = 0;
                    m = 1;
                    mint = 0;
                    ndrt = 0;
                    next = 0;
                    nzero = 0;
                    rlast = rdat;
                    rsrdat = 0;
                    sarray[0] = (int) samp[sa];
                    tmax = Math.abs(rdat);
                    xfrz = 1.6 * eabs;

                    xdot = (int) (samp[sa] - samp[sa - 1]);
                    rbig = ((xdot < 0) ? -xdot : xdot) / 3;
                    rbig = (eabs > rbig) ? eabs : rbig;

                    if (eabs > (channel.AltCoda * channel.CodaTerm)) {
                        cocrit = channel.PreEvent * eabs;
                        len_out = -1;
                    } else {
                        cocrit = channel.CodaTerm;
                        len_out = 1;
                    }

                    pick_status = coda_status = 1;
                    return 1;
                }
            }
            return 0;
        }

        private int EventActive() {
            while (++sa < samp.length) {
                //Update sample
                Sample(sa);

                if (coda_status == 1) {
                    int lwindow = (int) samprate;

                    if (len_win != 72) {
                        lwindow *= 2;
                    }

                    rsrdat += Math.abs(rdat);

                    //Save windows specified in the pwin array
                    if (++ndrt >= lwindow) {
                        int[] pwin = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 16, 20, 24,
                            28, 32, 36, 40, 44, 48, 56, 64, 70, 73};

                        if (len_win++ == pwin[k]) {
                            for (int i = 5; i > 0; i--) {
                                aav[i] = aav[i - 1];
                            }
                            k++;
                        }

                        //Coda length in seconds
                        len_sec = (2 * len_win) - 1;
                        if (len_sec == 145) {
                            len_sec = 144;
                        }

                        if ((pick_status == 2) && (len_sec >= channel.i9)) {
                            //REPORT PICK
                            picks.add(new Pick(possiblePickTime, (int) channel.i9));
                            picks.lastElement().FirstMotion = FirstMotion;
                            picks.lastElement().weight = weight;
                            pick_status = 0;
                            //Artificially terminate coda ???
                        }

                        //Average absolute value
                        double ave_abs_val = rsrdat / (double) lwindow;
                        aav[0] = (int) (ave_abs_val + 0.5);

                        //Initialize counter and coda amp sum
                        ndrt = 0;
                        rsrdat = 0;

                        //Is coda calculation over?
                        if ((len_win == 73) || (ave_abs_val < cocrit)) {
                            if (len_sec < channel.i9) {
                                return -1;
                            }

                            len_out *= len_sec;
                            coda_status = 2;
                        }
                    }
                }
                //The pick has been reported, the coda is complete but not reported
                if (coda_status == 2) {
                    if (pick_status == 0) {
                        //REPORT CODA
                        picks.lastElement().codalen = len_sec;
                        //System.out.println("Reporting coda: len_sec:" + len_sec);
                        coda_status = 0;
                    }
                    if (pick_status == 2) {
                        //REPORT PICK
                        picks.add(new Pick(possiblePickTime, len_sec));
                        picks.lastElement().FirstMotion = FirstMotion;
                        picks.lastElement().weight = weight;
                        pick_status = coda_status = 0;
                    }
                }

                //A Pick is Active... begin calculations
                if (pick_status == 1) {
                    int noise;
                    int itrm;

                    double xon;
                    double xpc;
                    double xp0, xp1, xp2;

                    //Save points for first motion
                    if (++evlen < 10) {
                        sarray[evlen] = (int) samp[sa];
                    }

                    //Store current data if it is a new extreme value
                    if (next < 3) {
                        double adata = Math.abs(rdat);
                        if (adata > tmax) {
                            tmax = adata;
                        }
                    }

                    //Test large ZC
                    if (Math.abs(rdat) >= rbig) {
                        if (Sign(rdat, rlast) != rdat) {
                            nzero++;
                            rlast = rdat;
                        }
                    }

                    //Increment ZC interval counter
                    //and leave if it exceeds MaxMint
                    if (++mint > channel.MaxMint) {
                        return -2;
                    }

                    //Test for small ZC
                    if (Sign(rdat, rold) == rdat) {
                        continue;
                    }

                    //Reset ZC counter
                    mint = 0;

                    //Update ecrit
                    ecrit += crtinc;
                    isml++;
                    if (esta > ecrit) {
                        isml = 0;
                    }

                    //Store extreme of preceeding half cycle
                    if (next < 3) {
                        xpk[next++] = tmax;

                        if (next == 1) {
                            double vt3 = tmax / 3;
                            rbig = (vt3 > rbig) ? vt3 : rbig;
                        }
                        tmax = 0;
                    }

                    //Compute itrm
                    itrm = (int) (channel.Itr1) + (m / (int) (channel.Itr1));

                    if (m > 150) {
                        itrm = 50;
                    }

                    //See if the pick is over
                    if ((++m != channel.MinSmallZC) && (isml < itrm)) {
                        continue;
                    }

                    /*
                    System.out.println("xpk: " + Math.round(xpk[0]) + " "
                            + Math.round(xpk[1]) + " " + Math.round(xpk[2]) + "  "
                            + "m: " + m + "  nzero: " + nzero);
                     * 
                     */

                    //Check if the pick is a noise pick
                    noise = 1;
                    for (int i = 0; i < 3; i++) {
                        if (xpk[i] >= channel.MinPeakSize) {
                            if ((m == channel.MinSmallZC)
                                    && (nzero >= channel.MinBigZC)) {
                                noise = 0;
                            }
                            break;
                        }
                    }
                    if (noise == 1) {
                        return -3;
                    }
                    

                    //A valid pick was found, compute 1st motion
                    FirstMotion = "?";

                    for (int kk = 0; true; kk++) {
                        if (xdot <= 0) {
                            if ((sarray[kk + 1] > sarray[kk]) || (kk == 8)) {
                                if (kk == 0) {
                                    break;
                                }
                                FirstMotion = "D";
                                break;
                            }
                        } else {
                            if ((sarray[kk + 1] < sarray[kk]) || (kk == 8)) {
                                if (kk == 0) {
                                    break;
                                }
                                FirstMotion = "U";
                                break;
                            }
                        }
                    }

                    //Pick weight Calculation
                    xpc = (xpk[0] > Math.abs((double) sarray[0]))
                            ? xpk[0] : xpk[1];
                    xon = Math.abs((double) xdot / xfrz);
                    xp0 = xpk[0] / xfrz;
                    xp1 = xpk[1] / xfrz;
                    xp2 = xpk[2] / xfrz;

                    weight = 3;

                    if ((xp0 > 2) && (xon > 0.5) && (xpc > 25)) {
                        weight = 2;
                    }

                    if ((xp0 > 3) && ((xp1 > 3) || (xp2 > 3)) && (xon > 0.5) && (xpc > 100)) {
                        weight = 1;
                    }

                    if ((xp0 > 4) && ((xp1 > 6) || (xp2 > 6)) && (xon > 0.5) && (xpc > 200)) {
                        weight = 0;
                    }

                    pick_status = 2;

                    //Report stuff
                    if (coda_status == 2) {
                        //REPORT PICK
                        picks.add(new Pick(possiblePickTime, len_sec));
                        picks.lastElement().FirstMotion = FirstMotion;
                        picks.lastElement().weight = weight;
                        //REPORT CODA
                        pick_status = coda_status = 0;
                    }
                }

                //End pick calculations
                if ((pick_status == 0) && (coda_status == 0)) {
                    return 0;
                }
            }
            return 1;
        }

        private double Sign(double x, double y) {
            if (x == 0) {
                return 0;
            }

            if (x < 0) {
                if (y < 0) {
                    return x;
                } else {
                    return -x;
                }
            } else {
                if (y < 0) {
                    return -x;
                } else {
                    return x;
                }
            }
        }
    }

    class Pick {

        double time;
        double codalen;
        String FirstMotion;
        int weight;

        Pick(double time, int len) {
            this.time = time;
            this.codalen = (double) len;
        }
    }

    class FailedPick {

        double time;
        String cause;

        FailedPick(double time, String cause) {
            this.time = time;
            this.cause = cause;
        }
    }
}
    
