package pick_ew_analysis;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class WaveServer {
    private String serverIP;
    private int serverPort;
    private Socket socket;
    private BufferedReader Sinput;
    private DataOutputStream Soutput;
    private String msgStorage;

    WaveServer(String serverIP, int serverPort) {
        //Set local variables
        this.serverIP = serverIP;
        this.serverPort = serverPort;
    }

    public boolean connect() {
        //Create comms socket
        try {
            socket = new Socket(serverIP, serverPort);
            Soutput = new DataOutputStream(socket.getOutputStream());
            Sinput = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            return true;
        } catch (Exception e) {
            System.err.println(e);
            return false;
        }
    }

    public void close() {
        try {
            Sinput.close();
            Soutput.close();
            socket.close();
        } catch (Exception e) {
            System.err.println(e);
        }
    }

    public Trace getSCNL(String S, String C, String N, String L, double starttime, double endtime) {
        //Connect to waveserver
        connect();

        //Set request ID
        int reqID = 1000;

        //Prepare number format for start and endtime
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("en", "US"));
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("#0.000000");

        //Prepare request
        String Request = "GETSCNL: " +
                String.valueOf(++reqID) + " " +
                S + " " + C + " " + N + " " + L + " " +
                df.format(starttime) + " " +
                df.format(endtime) + " "
                + "SCNL" + (char)(byte)10;
        String msg = "";
        try {
            //Send request
            //System.out.println("Sending Request: " + Request);
            Soutput.writeBytes(Request);
            
            String[] parts;
            //Wait for answer - RISK OF HANGING
            do {
                msg = Sinput.readLine();
                //System.out.println(msg);
                parts = msg.split("\\s+");
            } while (!parts[0].equals(String.valueOf(reqID)));
            //Prepare output;
            this.msgStorage = msg;
            //Check if message is OK
            if (!parts[6].equals("F")) return null;
            //Prepare Trace output
            double[][] aux = getSamples(msg);
            if (aux.length==0) {
                System.err.println("No samples acquired.");
                return null;
            }
            Trace trace = new Trace(getSamples(msg));
            trace.setSampRate(Double.valueOf(parts[9]));
            close();
            return trace;
            }
        catch (Exception e) {
            System.err.println("Error retrieving data from waveserver: " + e);
            System.err.println("Original return message: " + msg);
            close();
            return null;
        }
    }

    private double[][] getSamples(String msg) {
        //Split message
        String[] parts = msg.split("[\\s]+");

        //Check if message contains samples...
        if ((parts.length<6) || (!parts[6].equals("F"))) return null;

        //Extract relevant data from message
        double starttime = Double.valueOf(parts[8]);
        double samprate = Double.valueOf(parts[9]);
        double[][] output = new double[parts.length-10][2];

        //Compose array of samples and time
        for (int i=0; i<output.length; i++) {
            output[i][0] = Double.valueOf(parts[i+10]);
            output[i][1] = starttime + (double)(i)/(double)(samprate);
        }

        return output;
    } //end getSamples
}
