/*
 * pick_ew_analysis GUI object
 * Developed with NetBeans 6
 *
 */
package pick_ew_analysis;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MainWindow extends javax.swing.JFrame {

    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        ChannelList = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        StartTime = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        EndTime = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        Itr1 = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        MinSmallZC = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        MinBigZC = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        MinPeakSize = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        MaxMint = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        i9 = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        RawDataFilt = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        CharFuncFilt = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        StaFilt = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        LtaFilt = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        EventThresh = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        RmavFilt = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        DeadSta = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        CodaTerm = new javax.swing.JTextField();
        jLabel19 = new javax.swing.JLabel();
        AltCoda = new javax.swing.JTextField();
        jLabel20 = new javax.swing.JLabel();
        PreEvent = new javax.swing.JTextField();
        jLabel21 = new javax.swing.JLabel();
        Erefs = new javax.swing.JTextField();
        jLabel22 = new javax.swing.JLabel();
        ClipCount = new javax.swing.JTextField();
        OriginalTrace = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        jLabel24 = new javax.swing.JLabel();
        FilteredTrace = new javax.swing.JPanel();
        jLabel25 = new javax.swing.JLabel();
        Sta_Lta = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        StaLta = new javax.swing.JPanel();
        jLabel27 = new javax.swing.JLabel();
        jButton2 = new javax.swing.JButton();
        menuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        exitMenuItem = new javax.swing.JMenuItem();
        editMenu = new javax.swing.JMenu();
        deleteMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Pick EW Analysis");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        ChannelList.setModel(Main.config.getChannelList());
        ChannelList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        ChannelList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                ChannelListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(ChannelList);

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel1.setText("Channel List");

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel3.setText("Parameters");

        jLabel2.setText("Start Time");

        StartTime.setText(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date((long)(Main.config.starttime * 1000))));
        StartTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                StartTimeActionPerformed(evt);
            }
        });

        jLabel4.setText("End Time");

        EndTime.setText(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date((long)(Main.config.endtime * 1000))));
        EndTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EndTimeActionPerformed(evt);
            }
        });

        jLabel5.setText("Itr1");

        Itr1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Itr1ActionPerformed(evt);
            }
        });

        jLabel6.setText("MinSmallZC");

        MinSmallZC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MinSmallZCActionPerformed(evt);
            }
        });

        jLabel7.setText("MinBigZC");

        MinBigZC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MinBigZCActionPerformed(evt);
            }
        });

        jLabel8.setText("MinPeakSize");

        MinPeakSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MinPeakSizeActionPerformed(evt);
            }
        });

        jLabel9.setText("MaxMint");

        MaxMint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MaxMintActionPerformed(evt);
            }
        });

        jLabel10.setText("i9");

        i9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                i9ActionPerformed(evt);
            }
        });

        jLabel11.setText("RawDataFilt");

        RawDataFilt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RawDataFiltActionPerformed(evt);
            }
        });

        jLabel12.setText("CharFuncFilt");

        CharFuncFilt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CharFuncFiltActionPerformed(evt);
            }
        });

        jLabel13.setText("StaFilt");

        StaFilt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                StaFiltActionPerformed(evt);
            }
        });

        jLabel14.setText("LtaFilt");

        LtaFilt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                LtaFiltActionPerformed(evt);
            }
        });

        jLabel15.setText("EventThresh");

        EventThresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EventThreshActionPerformed(evt);
            }
        });

        jLabel16.setText("RmavFilt");

        RmavFilt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RmavFiltActionPerformed(evt);
            }
        });

        jLabel17.setText("DeadSta");

        DeadSta.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                DeadStaActionPerformed(evt);
            }
        });

        jLabel18.setText("CodaTerm");

        CodaTerm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CodaTermActionPerformed(evt);
            }
        });

        jLabel19.setText("AltCoda");

        AltCoda.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AltCodaActionPerformed(evt);
            }
        });

        jLabel20.setText("PreEvent");

        PreEvent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PreEventActionPerformed(evt);
            }
        });

        jLabel21.setText("Erefs");

        Erefs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ErefsActionPerformed(evt);
            }
        });

        jLabel22.setText("ClipCount");

        ClipCount.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ClipCountActionPerformed(evt);
            }
        });

        OriginalTrace.setBackground(new java.awt.Color(255, 255, 255));
        OriginalTrace.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        OriginalTrace.setFocusable(false);

        javax.swing.GroupLayout OriginalTraceLayout = new javax.swing.GroupLayout(OriginalTrace);
        OriginalTrace.setLayout(OriginalTraceLayout);
        OriginalTraceLayout.setHorizontalGroup(
            OriginalTraceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 692, Short.MAX_VALUE)
        );
        OriginalTraceLayout.setVerticalGroup(
            OriginalTraceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 68, Short.MAX_VALUE)
        );

        jLabel23.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel23.setText("Traces");

        jLabel24.setText("Original Trace");

        FilteredTrace.setBackground(new java.awt.Color(255, 255, 255));
        FilteredTrace.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        FilteredTrace.setFocusable(false);

        javax.swing.GroupLayout FilteredTraceLayout = new javax.swing.GroupLayout(FilteredTrace);
        FilteredTrace.setLayout(FilteredTraceLayout);
        FilteredTraceLayout.setHorizontalGroup(
            FilteredTraceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 692, Short.MAX_VALUE)
        );
        FilteredTraceLayout.setVerticalGroup(
            FilteredTraceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 207, Short.MAX_VALUE)
        );

        jLabel25.setText("Filtered Trace");

        Sta_Lta.setBackground(new java.awt.Color(255, 255, 255));
        Sta_Lta.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        Sta_Lta.setFocusable(false);

        javax.swing.GroupLayout Sta_LtaLayout = new javax.swing.GroupLayout(Sta_Lta);
        Sta_Lta.setLayout(Sta_LtaLayout);
        Sta_LtaLayout.setHorizontalGroup(
            Sta_LtaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 692, Short.MAX_VALUE)
        );
        Sta_LtaLayout.setVerticalGroup(
            Sta_LtaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 117, Short.MAX_VALUE)
        );

        jLabel26.setText("Sta and Lta");

        StaLta.setBackground(new java.awt.Color(255, 255, 255));
        StaLta.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        StaLta.setFocusable(false);

        javax.swing.GroupLayout StaLtaLayout = new javax.swing.GroupLayout(StaLta);
        StaLta.setLayout(StaLtaLayout);
        StaLtaLayout.setHorizontalGroup(
            StaLtaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 692, Short.MAX_VALUE)
        );
        StaLtaLayout.setVerticalGroup(
            StaLtaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 117, Short.MAX_VALUE)
        );

        jLabel27.setText("Sta/Lta");

        jButton2.setText("Generate Station File");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        fileMenu.setText("File");
        fileMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileMenuActionPerformed(evt);
            }
        });

        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        editMenu.setText("Edit");

        deleteMenuItem.setText("Settings");
        deleteMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteMenuItemActionPerformed(evt);
            }
        });
        editMenu.add(deleteMenuItem);

        menuBar.add(editMenu);

        setJMenuBar(menuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 134, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(36, 36, 36)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButton2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel3)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel4)
                            .addComponent(jLabel2)
                            .addComponent(jLabel5)
                            .addComponent(jLabel7)
                            .addComponent(jLabel8)
                            .addComponent(jLabel9)
                            .addComponent(jLabel6)
                            .addComponent(jLabel10)
                            .addComponent(jLabel11)
                            .addComponent(jLabel13)
                            .addComponent(jLabel14)
                            .addComponent(jLabel15)
                            .addComponent(jLabel16)
                            .addComponent(jLabel17)
                            .addComponent(jLabel18)
                            .addComponent(jLabel19)
                            .addComponent(jLabel20)
                            .addComponent(jLabel21)
                            .addComponent(jLabel22)
                            .addComponent(jLabel12))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(ClipCount)
                            .addComponent(Erefs)
                            .addComponent(PreEvent)
                            .addComponent(AltCoda)
                            .addComponent(CodaTerm)
                            .addComponent(DeadSta)
                            .addComponent(RmavFilt)
                            .addComponent(EventThresh)
                            .addComponent(LtaFilt)
                            .addComponent(StaFilt)
                            .addComponent(CharFuncFilt)
                            .addComponent(RawDataFilt)
                            .addComponent(i9)
                            .addComponent(MaxMint)
                            .addComponent(MinPeakSize)
                            .addComponent(MinBigZC)
                            .addComponent(MinSmallZC)
                            .addComponent(Itr1)
                            .addComponent(EndTime)
                            .addComponent(StartTime, javax.swing.GroupLayout.PREFERRED_SIZE, 94, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(28, 28, 28)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel23)
                    .addComponent(OriginalTrace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel25)
                    .addComponent(jLabel24)
                    .addComponent(FilteredTrace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(StaLta, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel27)
                    .addComponent(Sta_Lta, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel26))
                .addGap(23, 23, 23))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel3)
                    .addComponent(jLabel23))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2)
                            .addComponent(StartTime, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel24))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(OriginalTrace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(jLabel25)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(FilteredTrace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel26)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(Sta_Lta, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel27)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(StaLta, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel4)
                                    .addComponent(EndTime, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(Itr1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel5))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(MinSmallZC, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel6))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(MinBigZC, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel7))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel8)
                                    .addComponent(MinPeakSize, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel9)
                                    .addComponent(MaxMint, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(i9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel10))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel11)
                                    .addComponent(RawDataFilt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(CharFuncFilt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel12, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel13)
                                    .addComponent(StaFilt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(6, 6, 6)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel14)
                                    .addComponent(LtaFilt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel15)
                                    .addComponent(EventThresh, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel16)
                                    .addComponent(RmavFilt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel17)
                                    .addComponent(DeadSta, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel18)
                                    .addComponent(CodaTerm, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel19)
                                    .addComponent(AltCoda, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel20)
                                    .addComponent(PreEvent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel21)
                                    .addComponent(Erefs, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel22)
                                    .addComponent(ClipCount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(76, 76, 76)
                                .addComponent(jButton2))))
                    .addComponent(jScrollPane1))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void deleteMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteMenuItemActionPerformed
        SettingsWindow dialog = new SettingsWindow(new javax.swing.JFrame(), true);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);

        ChannelList.setModel(Main.config.getChannelList());

        if ((Main.config.channels != null) && (Main.config.channels.length > 0)) {
            if (Main.config.SelectedStation > Main.config.getChannelList().getSize()) {
                ChannelList.setSelectedIndex(0);
            } else {
                ChannelList.setSelectedIndex(Main.config.SelectedStation);
            }
            updateTraces();
        }
    }//GEN-LAST:event_deleteMenuItemActionPerformed

    private void fileMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileMenuActionPerformed
        formWindowClosing(null);
        System.exit(0);
    }//GEN-LAST:event_fileMenuActionPerformed

    private void ChannelListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_ChannelListValueChanged
        if ((evt != null) && (evt.getValueIsAdjusting())) {
            return;
        }
        if ((curChannel != null) && (curChannel.getTrace() != null)) {
            curChannel.releaseTrace();
        }

        //Retrieve corresponding channel
        curChannel = Main.config.getStation(ChannelList.getSelectedIndex());
        if (curChannel == null) {
            return; //Channel does not exist, leave
        }        //curChannel.releaseTrace();
        //curChannel = newChannel;

        //Set current channel on config
        Main.config.SelectedStation = ChannelList.getSelectedIndex();
        //Set data on the window parameters
        Itr1.setText(String.valueOf(curChannel.Itr1));
        MinSmallZC.setText(String.valueOf(curChannel.MinSmallZC));
        MinBigZC.setText(String.valueOf(curChannel.MinBigZC));
        MinPeakSize.setText(String.valueOf(curChannel.MinPeakSize));
        MaxMint.setText(String.valueOf(curChannel.MaxMint));
        i9.setText(String.valueOf(curChannel.i9));
        RawDataFilt.setText(String.valueOf(curChannel.RawDataFilt));
        CharFuncFilt.setText(String.valueOf(curChannel.CharFuncFilt));
        StaFilt.setText(String.valueOf(curChannel.StaFilt));
        LtaFilt.setText(String.valueOf(curChannel.LtaFilt));
        EventThresh.setText(String.valueOf(curChannel.EventThresh));
        RmavFilt.setText(String.valueOf(curChannel.RmavFilt));
        DeadSta.setText(String.valueOf(curChannel.DeadSta));
        CodaTerm.setText(String.valueOf(curChannel.CodaTerm));
        AltCoda.setText(String.valueOf(curChannel.AltCoda));
        PreEvent.setText(String.valueOf(curChannel.PreEvent));
        Erefs.setText(String.valueOf(curChannel.Erefs));
        ClipCount.setText(String.valueOf(curChannel.ClipCount));

        updateTraces();
    }//GEN-LAST:event_ChannelListValueChanged

    private void Itr1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Itr1ActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_Itr1ActionPerformed

    private void MinSmallZCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MinSmallZCActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_MinSmallZCActionPerformed

    private void MinBigZCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MinBigZCActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_MinBigZCActionPerformed

    private void MinPeakSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MinPeakSizeActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_MinPeakSizeActionPerformed

    private void MaxMintActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MaxMintActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_MaxMintActionPerformed

    private void i9ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_i9ActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_i9ActionPerformed

    private void RawDataFiltActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RawDataFiltActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_RawDataFiltActionPerformed

    private void CharFuncFiltActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CharFuncFiltActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_CharFuncFiltActionPerformed

    private void StaFiltActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_StaFiltActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_StaFiltActionPerformed

    private void LtaFiltActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_LtaFiltActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_LtaFiltActionPerformed

    private void EventThreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EventThreshActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_EventThreshActionPerformed

    private void RmavFiltActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RmavFiltActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_RmavFiltActionPerformed

    private void DeadStaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_DeadStaActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_DeadStaActionPerformed

    private void CodaTermActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CodaTermActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_CodaTermActionPerformed

    private void AltCodaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AltCodaActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_AltCodaActionPerformed

    private void PreEventActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PreEventActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_PreEventActionPerformed

    private void ErefsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ErefsActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_ErefsActionPerformed

    private void ClipCountActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ClipCountActionPerformed
        updateConfig();
        updateComputedTraces();
    }//GEN-LAST:event_ClipCountActionPerformed

    private void StartTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_StartTimeActionPerformed
        updateTime();
    }//GEN-LAST:event_StartTimeActionPerformed

    private void EndTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EndTimeActionPerformed
        updateTime();
    }//GEN-LAST:event_EndTimeActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        Config.saveConfig(Main.config);
    }//GEN-LAST:event_formWindowClosing

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        //Generate a station file

        try {
            //Create output stream
            BufferedWriter foutput = new BufferedWriter(new FileWriter("test.sta"));


            for (int i = 0; i < Main.config.channels.length; i++) {
                Channel chan = Main.config.channels[i];
                if (chan == null) {
                    return;
                }

                String staLine = chan.flag + " " +
                        chan.pin + " " +
                        chan.S + " " + chan.C + " " + chan.N + " " + chan.L + " " +
                        (int) chan.Itr1 + " " +
                        (int) chan.MinSmallZC + " " +
                        (int) chan.MinBigZC + " " +
                        (int) chan.MinPeakSize + " " +
                        (int) chan.MaxMint + " " +
                        (int) chan.i9 + " " +
                        chan.RawDataFilt + " " +
                        chan.CharFuncFilt + " " +
                        chan.StaFilt + " " +
                        chan.LtaFilt + " " +
                        chan.EventThresh + " " +
                        chan.RmavFilt + " " +
                        chan.DeadSta + " " +
                        chan.CodaTerm + " " +
                        chan.AltCoda + " " +
                        chan.PreEvent + " " +
                        chan.Erefs + " " +
                        (int) chan.ClipCount;

                System.out.println(staLine);
                foutput.write(staLine);
                foutput.newLine();
            }
            foutput.close();
        } catch (Exception e) {
            System.err.println(e);
        }
}//GEN-LAST:event_jButton2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField AltCoda;
    private javax.swing.JList ChannelList;
    private javax.swing.JTextField CharFuncFilt;
    private javax.swing.JTextField ClipCount;
    private javax.swing.JTextField CodaTerm;
    private javax.swing.JTextField DeadSta;
    private javax.swing.JTextField EndTime;
    private javax.swing.JTextField Erefs;
    private javax.swing.JTextField EventThresh;
    private javax.swing.JPanel FilteredTrace;
    private javax.swing.JTextField Itr1;
    private javax.swing.JTextField LtaFilt;
    private javax.swing.JTextField MaxMint;
    private javax.swing.JTextField MinBigZC;
    private javax.swing.JTextField MinPeakSize;
    private javax.swing.JTextField MinSmallZC;
    private javax.swing.JPanel OriginalTrace;
    private javax.swing.JTextField PreEvent;
    private javax.swing.JTextField RawDataFilt;
    private javax.swing.JTextField RmavFilt;
    private javax.swing.JTextField StaFilt;
    private javax.swing.JPanel StaLta;
    private javax.swing.JPanel Sta_Lta;
    private javax.swing.JTextField StartTime;
    private javax.swing.JMenuItem deleteMenuItem;
    private javax.swing.JMenu editMenu;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JTextField i9;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JMenuBar menuBar;
    // End of variables declaration//GEN-END:variables
    private Channel curChannel;

    private void updateTraces() {
        //Retrieve Channel
        if ((curChannel == null) || (!curChannel.setTrace())) {
            DrawUtils.clearPanel(OriginalTrace, null);
            updateComputedTraces();
            return;
        }

        //Clear original trace panel
        DrawUtils.clearPanel(OriginalTrace, null);
        //Draw riginal trace
        DrawUtils.drawTrace(OriginalTrace, curChannel.getTime(),
                curChannel.getSamples(), Color.BLACK, null);

        //Update computed traces
        updateComputedTraces();
    }

    private void updateComputedTraces() {
        //Retrieve Channel
        if ((curChannel == null) || (curChannel.getTrace() == null)) {
            //Clear all traces
            DrawUtils.clearPanel(FilteredTrace, null);
            DrawUtils.clearPanel(Sta_Lta, null);
            DrawUtils.clearPanel(StaLta, null);
            //leave
            return;
        }

        // Plot RDAT
        double[] time = curChannel.getTime();
        double[] rdat = curChannel.getRdat();
        double[] edat = curChannel.getEdat();

        //Clear filtered trace
        DrawUtils.clearPanel(FilteredTrace, null);
        //Plot Characteristic function
        DrawUtils.drawTrace(FilteredTrace, time, edat, Color.LIGHT_GRAY, null);
        //Plot filtered trace
        double[] scaleRdat = DrawUtils.drawTrace(FilteredTrace, time, rdat, Color.BLUE, null);
        //Plot MinPeakSize
        DrawUtils.drawFullHorizontalLine(FilteredTrace, curChannel.MinPeakSize, Color.RED, scaleRdat);
        DrawUtils.drawFullHorizontalLine(FilteredTrace, -curChannel.MinPeakSize, Color.RED, scaleRdat);
        //Plot Picks and Codas
        PickAnalysis pickanalysis = new PickAnalysis(curChannel);
        double[] pickTimes = pickanalysis.getPickTimes();
        double[] codaTimes;
        String[] fstMotions;
        if (pickTimes != null) {
            codaTimes = pickanalysis.getPickCodas();
            fstMotions = pickanalysis.getFstMotions();

            System.out.println("DETECTED PICKS");
            for (int i = 0; i < pickTimes.length; i++) {
                DrawUtils.drawTransparentRect(FilteredTrace, pickTimes[i], codaTimes[i], Color.GREEN, scaleRdat);
                DrawUtils.drawFullVerticalLine(FilteredTrace, pickTimes[i], Color.RED, scaleRdat);
                DrawUtils.drawFullVerticalLine(FilteredTrace, pickTimes[i] + codaTimes[i], Color.GREEN, scaleRdat);
                DrawUtils.drawFstMotion(FilteredTrace,
                        fstMotions[i] + " " + String.valueOf((int) codaTimes[i]) + "s",
                        pickTimes[i], Color.RED, scaleRdat);

                //Output pick messages
                String pickMsg = fstMotions[i] + " " +
                        new SimpleDateFormat("yyyyMMddHHmmss.SSS").format(new Date((long) (pickTimes[i] * 1000)));
                System.out.println("PICK " + (i+1) + ": " + pickMsg);
            }
        }
        //Plot base rectanble
        DrawUtils.drawBaseRect(Sta_Lta);

        // Plot STA and LTA
        //Clear panel
        DrawUtils.clearPanel(Sta_Lta, null);
        //Plot sta
        double[] scale = DrawUtils.drawTrace(Sta_Lta, curChannel.getTime(),
                curChannel.getSta(), Color.LIGHT_GRAY, curChannel.getLta());
        //Plot lta
        DrawUtils.drawTrace(Sta_Lta, curChannel.getTime(),
                curChannel.getLta(), Color.BLACK, scale);
        //Plot base rectanble
        DrawUtils.drawBaseRect(Sta_Lta);

        //Plot STA/LTA ratio
        //Clear panel
        DrawUtils.clearPanel(StaLta, null);
        //Plot sta/lta
        scale = DrawUtils.drawTrace(StaLta, curChannel.getTime(),
                curChannel.getStaLta(), Color.LIGHT_GRAY, null);
        //Plot Threshold line
        DrawUtils.drawFullHorizontalLine(StaLta, curChannel.EventThresh, Color.BLUE, scale);
        //Plot failed picks
        double[] failedPickTimes = pickanalysis.getFailedPickTimes();
        if (failedPickTimes != null) {
            String[] failedPickCauses = pickanalysis.getFailedPickCause();
            for (int i = 0; i < failedPickTimes.length; i++) {
                DrawUtils.drawVerticalLine(StaLta, failedPickTimes[i],
                        curChannel.EventThresh, scale[3], Color.RED, scale);
                DrawUtils.drawFstMotion(StaLta,
                        failedPickCauses[i],
                        failedPickTimes[i], Color.RED, scale);
            }
        }
        //Plot base rectanble
        DrawUtils.drawBaseRect(StaLta);


    }

    private void updateConfig() {
        if (curChannel == null) {
            return;
        }
        try {
            curChannel.Itr1 = Double.valueOf(Itr1.getText());
            curChannel.MinSmallZC = Double.valueOf(MinSmallZC.getText());
            curChannel.MinBigZC = Double.valueOf(MinBigZC.getText());
            curChannel.MinPeakSize = Double.valueOf(MinPeakSize.getText());
            curChannel.MaxMint = Double.valueOf(MaxMint.getText());
            curChannel.i9 = Double.valueOf(i9.getText());
            curChannel.RawDataFilt = Double.valueOf(RawDataFilt.getText());
            curChannel.CharFuncFilt = Double.valueOf(CharFuncFilt.getText());
            curChannel.StaFilt = Double.valueOf(StaFilt.getText());
            curChannel.LtaFilt = Double.valueOf(LtaFilt.getText());
            curChannel.EventThresh = Double.valueOf(EventThresh.getText());
            curChannel.RmavFilt = Double.valueOf(RmavFilt.getText());
            curChannel.DeadSta = Double.valueOf(DeadSta.getText());
            curChannel.CodaTerm = Double.valueOf(CodaTerm.getText());
            curChannel.AltCoda = Double.valueOf(AltCoda.getText());
            curChannel.PreEvent = Double.valueOf(PreEvent.getText());
            curChannel.Erefs = Double.valueOf(Erefs.getText());
            curChannel.ClipCount = Double.valueOf(ClipCount.getText());
        } catch (Exception e) {
            System.err.println(e);
        }
    } //end updateConfig

    private void updateTime() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = dateFormat.parse(StartTime.getText());
            Main.config.starttime = (double) (date.getTime()) / 1000;
            date = dateFormat.parse(EndTime.getText());
            Main.config.endtime = (double) (date.getTime()) / 1000;
        } catch (Exception e) {
            System.err.println("Invalid date format. Should be YYYYMMDDhhmmss - " + e);
        }
        //System.out.println("Starttime set to: " + Main.config.starttime);
        double aux = Main.config.endtime - Main.config.starttime;
        if ((aux > 0) && (aux < 1200)) {
            updateTraces();
        }
    } //end updateTime

    public void startup() {
    }
}
