package pick_ew_analysis;

import java.util.Vector;

public class Trace implements java.io.Serializable {
    public static final int MAXSAMPLES = 128*330;
    private Vector<Double> samples = new Vector<Double>(MAXSAMPLES);
    private Vector<Double> time = new Vector<Double>(MAXSAMPLES);
    private double samprate;

    //Temporary storage of data
    private double[] samp = null;
    private double[] rdat = null;
    private double[] edat = null;
    private double[] sta = null;
    private double[] lta = null;
    private double[] t = null;




    Trace(double[][] basesamples) {
        if (basesamples == null) return;
        addSamples(basesamples);
    }

    public void setSampRate(double samprate) {
        this.samprate = samprate;
    }

    public double[] getSamples() {
        if (samples.size()==0) return null;
        samp = new double[samples.size()];
        for (int i=0; i<samp.length; i++) samp[i] = samples.elementAt(i);
        return retrieveSamples(samp);
    }

    public double[] getBaseSamp() {
        return samp;
    }

    public double[] getTime() {
        t = new double[time.size()];
        for (int i=0; i<t.length; i++) t[i] = time.elementAt(i);
        return retrieveSamples(t);
    }

    public double[] getBaseTime() {
        return t;
    }

    public double[] getRdat(double RawDataFilt) {
        if (samp==null) return null;
        rdat = new double[samp.length];
        rdat[0]=0;
        for (int i=1; i<rdat.length; i++) {
            rdat[i] = rdat[i-1] * RawDataFilt +
                    samp[i] - samp[i-1] + 1e-10;
        }
        return retrieveSamples(rdat);
    }
    public double[] getBaseRdat() {
        return rdat;
    }

    public double[] getEdat(double CharFuncFilt) {
        if (rdat==null) return null;
        edat = new double[samp.length];
        edat[0]=0;
        for (int i=1; i<samp.length; i++) {
            double rdif = rdat[i] - rdat[i-1];
            edat[i] = (rdat[i] * rdat[i]) +
                    (CharFuncFilt * rdif * rdif);
        }
        return retrieveSamples(edat);
    }
    public double[] getBaseEdat() {
        return edat;
    }

    public double[] getSta(double StaFilt, double CharFuncFilt) {
        if (rdat==null) return null;
        sta = new double[samp.length];
        sta[0]=0;
        for (int i=1; i<samp.length; i++) {
            double rdif = rdat[i] - rdat[i-1];
            double edatx = (rdat[i] * rdat[i]) +
                    (CharFuncFilt * rdif * rdif);
            sta[i] = sta[i-1] + StaFilt * (edatx - sta[i-1]);
        }
        return retrieveSamples(sta);
    }

    public double[] getBaseSta() {
        return sta;
    }

    public double[] getLta(double LtaFilt, double CharFuncFilt) {
        if (rdat==null) return null;
        lta = new double[samp.length];
        lta[0]=0;
        for (int i=1; i<samp.length; i++) {
            double rdif = rdat[i] - rdat[i-1];
            double edat = (rdat[i] * rdat[i]) +
                    (CharFuncFilt * rdif * rdif);
            lta[i] = lta[i-1] + LtaFilt * (edat - lta[i-1]);
        }
        return retrieveSamples(lta);
    }

    public double[] getBaseLta() {
        return lta;
    }

    public double[] getStaLta() {
        if ((sta==null)||(lta==null)) return null;
        double[] output = new double[sta.length];
        for (int i=0; i<output.length; i++)
            output[i] = sta[i]/lta[i];
        return retrieveSamples(output);
    }

    public void addSamples(double[][] baseSamples) {
        for (int i=0; i<baseSamples.length; i++) {
            samples.add(baseSamples[i][0]);
            time.add(baseSamples[i][1]);
        }
        return;
    }



    private double[] retrieveSamples(double[] x) {
        if (time.size()<1) return null;
        int minPos = 0;
        int maxPos = time.size()-1;
        for (minPos=0; minPos<time.size(); minPos++)
            if (time.elementAt(minPos)>=Main.config.starttime) break;
        for (maxPos=(time.size()-1); maxPos>=0; maxPos--)
            if (time.elementAt(maxPos)<=Main.config.endtime) break;

        double[] output = new double[maxPos - minPos];

        for (int i=minPos; i<maxPos; i++)
            output[i-minPos] = x[i];
        return output;
    }


    public double getSampRate() {
        return this.samprate;
    }
}
