package pick_ew_analysis;

import java.awt.Color;
import java.awt.Graphics2D;

public class Channel implements java.io.Serializable{
    //Constants
    public static final int DRAW_RDAT = 0;
    public static final int DRAW_STA = 1;
    public static final int DRAW_LTA = 2;
    public static final int DRAW_STALTA = 3;

    //Variables
    public String flag, pin;
    public String S, C, N, L;
    public double Itr1, MinSmallZC, MinBigZC, MinPeakSize, MaxMint, i9,
            RawDataFilt, CharFuncFilt, StaFilt, LtaFilt, EventThresh,
            RmavFilt, DeadSta, CodaTerm, AltCoda, PreEvent, Erefs, ClipCount;
    private Trace trace = null;

    Channel(String S, String C, String N, String L,
            double Itr1, double MinSmallZC, double MinBigZC,
            double MinPeakSize, double MaxMint, double i9,
            double RawDataFilt, double CharFuncFilt, double StaFilt,
            double LtaFilt, double EventThresh, double RmavFilt, double DeadSta,
            double CodaTerm, double AltCoda, double PreEvent, double Erefs, double ClipCount,
            String flag, String pin) {
        this.S = S;
        this.C = C;
        this.N = N;
        this.L = L;
        this.Itr1 = Itr1;
        this.MinSmallZC = MinSmallZC;
        this.MinBigZC = MinBigZC;
        this.MinPeakSize = MinPeakSize;
        this.MaxMint = MaxMint;
        this.i9 = i9;
        this.RawDataFilt = RawDataFilt;
        this.CharFuncFilt = CharFuncFilt;
        this.StaFilt = StaFilt;
        this.LtaFilt = LtaFilt;
        this.EventThresh = EventThresh;
        this.RmavFilt = RmavFilt;
        this.DeadSta = DeadSta;
        this.CodaTerm = CodaTerm;
        this.AltCoda = AltCoda;
        this.PreEvent = PreEvent;
        this.Erefs = Erefs;
        this.ClipCount = ClipCount;
        this.flag = flag;
        this.pin = pin;
    }

    public void releaseTrace() {
        trace = null;
    }

    public String getSCNL() {
        return S + " " + C + " " + N + " " + L;
    }

    public Trace getTrace() {
        return trace;
    }

    public boolean setTrace() {
        //PLACE HERE TRACE MANAGEMENT!!!!!
        //Retrieve trace from waveserver
        trace = new WaveServer(Main.config.ServerIP, Main.config.ServerPort).
                getSCNL(S, C, N, L, Main.config.starttime - 30, Main.config.endtime + 30);
        if (trace==null)
            return false;
        return true;
    }


    public double[] getSamples() {
        return trace.getSamples();
    }

    public double[] getRdat() {
        return trace.getRdat(RawDataFilt);
    }

    public double[] getEdat() {
        return trace.getEdat(CharFuncFilt);
    }

    public double[] getSta() {
        return trace.getSta(StaFilt, CharFuncFilt);
    }

    public double[] getLta() {
        return trace.getLta(LtaFilt, CharFuncFilt);
    }

    public double[] getStaLta() {
        return trace.getStaLta();
    }

    public double[] getTime() {
        return trace.getTime();
    }


    public void plotOriginal(javax.swing.JPanel panel) {
        //Retrieve trace from waveserver
        trace = new WaveServer(Main.config.ServerIP, Main.config.ServerPort).
                getSCNL(S, C, N, L, Main.config.starttime - 30, Main.config.endtime);
        if (trace==null)
            return; //It was not possible to retrieve the data

        //Get graphics
        Graphics2D gr = (Graphics2D)panel.getGraphics();

        double width = (double)panel.getWidth();
        double height = (double)panel.getHeight();
        //Clear graphics
        gr.setBackground(Color.white);
        gr.clearRect(1, 1, (int)width-2, (int)height-2);

        //Calculate parameters for plot
        double[] y = trace.getSamples();
        double[] x = trace.getTime();
        
        // - mean
        double meanY = 0;
        for (int i=0; i<y.length; i++)
            meanY+=y[i];
        meanY /= y.length;

        // - maximum
        double maxY = 0;
        for (int i=0; i<y.length; i++)
            maxY = (Math.abs(y[i]-meanY)>maxY)?Math.abs(y[i]-meanY):maxY;

        //Prepare final y variable
        int[] yP = new int[y.length];
        for (int i=0;i<y.length; i++)
            yP[i] = (int)(-(y[i]-meanY)/maxY*height/2+height/2);

        //x scale in pixels/s
        double scaleX = (double)(width)/(Main.config.endtime - Main.config.starttime);
        
        //System.out.println("scaleX: " + scaleX);
        //Prepare final x variable
        int[] xP = new int[x.length];
        for (int i=0; i<x.length; i++)
            xP[i] = (int)((x[i]-x[0]) * scaleX);

        //for (int i=0;i<xP.length;i++)
        //    System.out.println(i + ": " + xP[i] + " " + yP[i]);

        //Draw polyline
        gr.setColor(Color.BLACK);
        gr.drawPolyline(xP, yP, xP.length);
    }



    public void plotProcessed(int dataType, javax.swing.JPanel panel) {
        if (trace==null) return; //No available data

        //Get graphics
        Graphics2D gr = (Graphics2D)panel.getGraphics();

        double width = (double)panel.getWidth();
        double height = (double)panel.getHeight();
        Color color = null;
        //Clear graphics
        if (dataType!=DRAW_LTA) {
            gr.setBackground(Color.white);
            gr.clearRect(1, 1, (int)width-2, (int)height-2);

        }

        //Retrieve processed data
        
        double[] y = null;
        switch (dataType) {
            case DRAW_RDAT:
                y = trace.getRdat(RawDataFilt);
                color = Color.BLUE;
                break;
            case DRAW_STA:
                y = trace.getSta(StaFilt, CharFuncFilt);
                color = Color.LIGHT_GRAY;
                break;
            case DRAW_LTA:
                y = trace.getLta(LtaFilt, CharFuncFilt);
                color = Color.BLACK;
                break;
            case DRAW_STALTA:
                y = trace.getStaLta();
                color = Color.LIGHT_GRAY;
        }
        //Check if data is ready
        if (y==null) return;
        double[] x = trace.getTime();
        
        //Calculate parameters for plot
        // - maximum
        double maxY = 0;
        switch (dataType) {
            case DRAW_RDAT:
                for (int i=0; i<y.length; i++)
                    maxY = (Math.abs(y[i])>maxY)?Math.abs(y[i]):maxY;
                break;
            case DRAW_STALTA:
                maxY = 2 * EventThresh;
                break;
            case DRAW_STA:
                for (int i=0; i<y.length; i++)
                    maxY = (Math.abs(y[i])>maxY)?Math.abs(y[i]):maxY;
                break;
            case DRAW_LTA:
                double[] yy = trace.getSta(StaFilt, CharFuncFilt);
                for (int i=0; i<y.length; i++)
                    maxY = (Math.abs(yy[i])>maxY)?Math.abs(yy[i]):maxY;
                break;
        }

        //Prepare final y variable
        int[] yP = new int[y.length];
        double mconst = (dataType==DRAW_RDAT)?height/2:height;
        for (int i=0;i<y.length; i++)
            yP[i] = (int)(-(y[i])/maxY*mconst + mconst);

        //x scale in pixels/s
        double scaleX = (double)(width)/(Main.config.endtime - Main.config.starttime);

        //System.out.println("scaleX: " + scaleX);
        //Prepare final x variable
        int[] xP = new int[x.length];
        for (int i=0; i<x.length; i++)
            xP[i] = (int)((x[i]-x[0]) * scaleX);

        //Draw polyline
        gr.setColor(color);
        gr.drawPolyline(xP, yP, xP.length);


        //Draw reference lines
        switch (dataType) {
            case DRAW_RDAT:
                gr.setColor(Color.RED);
                gr.drawLine(1, (int)(-MinPeakSize/maxY*mconst+mconst),
                        (int)width-2, (int)(-MinPeakSize/maxY*mconst+mconst));
                gr.drawLine(1, (int)(+MinPeakSize/maxY*mconst+mconst),
                        (int)width-2, (int)(+MinPeakSize/maxY*mconst+mconst));
                break;
            case DRAW_STALTA:
                gr.setColor(Color.BLUE);
                gr.drawLine(1, (int)(-EventThresh/maxY*mconst+mconst),
                        (int)width-2, (int)(-EventThresh/maxY*mconst+mconst));
                break;
        }

    }


    public void plotVerticalLine(int xPos, javax.swing.JPanel panel) {
        if (trace==null) return; //No available data

        //Get graphics
        Graphics2D gr = (Graphics2D)panel.getGraphics();

        double width = (double)panel.getWidth();
        double height = (double)panel.getHeight();

        //Retrieve time
        double[] x = trace.getTime();
        double[] xB = trace.getBaseTime();
        double xx = xB[xPos];
        double scaleX = (double)(width)/(Main.config.endtime - Main.config.starttime);
        int xP = (int)((xx-x[0]) * scaleX);

        gr.setColor(Color.red);
        gr.drawLine(xP, 0, xP, (int)height);
    }

}
