
#
#   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
#   CHECKED IT OUT USING THE COMMAND CHECKOUT.
#
#    $Id: makefile.sol,v 1.43 2010/03/15 15:22:41 paulf Exp $
#
#    Revision history:
#     $Log: makefile.sol,v $
#     Revision 1.43  2010/03/15 15:22:41  paulf
#     added wfdiscputaway to makefile.sol
#
#     Revision 1.42  2010/02/24 18:47:29  scott
#     Module debias + xfrm library it is built upon
#
#     Revision 1.41  2009/12/23 15:53:04  paulf
#     added glevent_2_ewevent.c to makefile for sol
#
#     Revision 1.40  2009/05/19 22:24:48  dietz
#     Added rw_coda_aav.c for processing TYPE_CODA_AAV messages
#
#     Revision 1.39  2007/11/28 14:19:17  paulf
#     add sqlite3 to all makefiles
#
#     Revision 1.38  2007/02/20 13:07:19  paulf
#     lockfile added for singleton programs to use
#
#     Revision 1.37  2007/02/07 05:42:40  stefan
#     miniseed writer thanks to BGS, Richard Luckett
#
#     Revision 1.36  2006/09/22 20:50:15  dietz
#     Removed a debug "fprintf(stderr..." statement in EncodeStatus which was
#     printing partial EW status messages to the screen.
#
#     Revision 1.35  2006/04/04 18:00:14  stefan
#     startstop with reconfigure and libraries 20060404 s.lisowski
#
#     Revision 1.34  2006/01/30 21:48:15  friberg
#     added in residue.c and transferFunction.c to makefile for raypicker
#
#     Revision 1.33  2006/01/30 21:04:02  friberg
#     added in Hydra libs for raypicker
#
#     Revision 1.32  2006/01/18 17:07:36  friberg
#     added back in global codes to makefile.sol...they disappeared at one point
#
#     Revision 1.31  2004/07/29 20:02:20  dietz
#     added ws_clientIIx
#
#     Revision 1.30  2004/06/13 02:10:25  davidk
#     Removed *ewevent.c  files.  Files were located in two places,
#     libsrc/util  and oracle/apps/src/libsrc.
#     Files were removed from libsrc/util.
#
#     Revision 1.29  2004/05/14 17:53:54  dietz
#     added rdpickcoda.c, moved from pkfilter's source dir
#
#     Revision 1.28  2004/04/29 23:05:10  kohler
#     Added trheadconv.c to make files.  WMK 4/29/04
#
#     Revision 1.27  2004/04/14 23:13:29  davidk
#     Re-streamlined makefiles, to build the EW libsrc tree on Solaris.
#
#     Revision 1.26  2004/03/17 21:05:35  lucky
#     *** empty log message ***
#
#     Revision 1.25  2002/07/23 19:19:26  dhanych
#     replaced global_msg_rw.c with several
#
#     Revision 1.24  2002/07/23 14:35:29  dhanych
#     added global_msg_rw.c
#
#     Revision 1.23  2002/05/08 16:33:22  dhanych
#     20020508 dbh -- added fleng (Flynn-Engdahl calculations)
#
#     Revision 1.22  2002/05/08 16:28:58  lucky
#     *** empty log message ***
#
#     Revision 1.21  2002/03/21 18:13:59  dhanych
#     added priority_queue
#
#     Revision 1.20  2002/02/22 18:51:58  lucky
#     added gseputaway, seiputaway, and seiutils; needed for new output formats
#
#     Revision 1.19  2001/05/15 20:50:34  davidk
#     removed references to DBEvent/FullEvent objects that have been
#     moved to the oracle/apps/src/libsrc directory.
#
#     Revision 1.18  2001/04/12 04:00:26  lombard
#     nothing significant
#
#     Revision 1.17  2001/04/12 00:17:21  davidk
#     stamped out queue_max_size.c.
#
#     Revision 1.16  2001/03/31 00:44:22  lombard
#     removed sing.c from libsrc/util.
#
#     Revision 1.15  2001/03/30 23:54:38  bogaert
#     *** empty log message ***
#
#     Revision 1.14  2001/03/15 21:59:29  bogaert
#     Added fft99.c
#
#     Revision 1.13  2001/03/14 00:23:40  alex
#     added geo_to_km.    Alex
#
#     Revision 1.12  2001/03/09 18:14:07  dietz
#     *** empty log message ***
#
#     Revision 1.11  2001/03/09 17:48:27  lucky
#     Following the create schema cleanup
#
#     Revision 1.10  2001/01/15 02:08:10  lombard
#     Added fft_prep.c, sing.c, transfer.c
#
#     Revision 1.9  2000/12/18 18:55:36  lucky
#     Re-added old format converter routines, but changed names from
#     DBEvent to FullEvent
#
#     Revision 1.8  2000/12/16 01:01:43  davidk
#     removed 3 DB related library files from this directory.  Moved them to
#     src/oracle/apps/src/libsrc/util
#
#     Revision 1.7  2000/08/29 18:08:55  lucky
#     Added InitDBEvent
#
#     Revision 1.6  2000/08/16 17:19:40  lucky
#     Removed DBEventArcSac, added Arc2DBEvent and Sac2DBEvent
#
#     Revision 1.5  2000/08/09 15:59:25  lucky
#     *** empty log message ***
#
#     Revision 1.4  2000/08/08 18:54:30  lucky
#     Added lint directive
#
#     Revision 1.3  2000/05/02 15:40:56  lucky
#     Added DBEventSacArc.c
#
#     Revision 1.2  2000/03/31 18:21:16  lucky
#     added neic2scn
#
#     Revision 1.1  2000/02/14 18:51:48  lucky
#     Initial revision
#
#
#

CFLAGS = -c -D_REENTRANT $(GLOBALFLAGS)

B = $(EW_HOME)/$(EW_VERSION)/bin
L = $(EW_HOME)/$(EW_VERSION)/lib


SRCS = \
	ahputaway.c \
	brent.c \
	butterworth.c \
	chron3.c \
	complex_math.c \
	convertInstResponse.c \
	fft99.c \
	fft_prep.c \
	fleng.c \
	glevt_2_ewevent.c \
	global_loc_rw.c \
	global_pick_rw.c \
	global_amp_rw.c \
	global_msg.c \
	gma.c \
	geo_to_km.c \
	getutil.c \
	gseputaway.c \
	k2evt2ew.c \
	kom.c \
	ioc_filter.c \
	logit.c \
        lockfile.c\
	make_triglist.c\
	mem_circ_queue.c\
	mnbrak.c \
	mseedputaway.c \
	neic2scn.c \
	parse_trig.c \
	parse_usnsn.c \
	priority_queue.c \
	putaway.c \
	rayloc_message_rw.c \
	rdpickcoda.c \
	read_arc.c \
	residue.c \
	rw_coda_aav.c \
	rw_mag.c \
	rw_strongmotion.c \
	rw_strongmotionII.c \
	sacputaway.c \
	seiputaway.c \
	seiutils.c \
	site.c \
	socket_ew_common.c \
        sqlite3.c \
	startstop_unix_generic.c \
	startstop_lib.c \
	sudsputaway.c \
	swap.c \
	tankputaway.c \
	tlay.c \
	transfer.c \
	transferFunction.c \
	trheadconv.c \
	watchdog_client.c \
	wave_client.c \
	wfdiscputaway.c \
	ws_clientII.c \
	ws_clientIIx.c \
	xfrm.c

OBJS = $(SRCS:%.c=%.o) logit_mt.o

all: $(OBJS) gd_lib libmseed

logit_mt.o: logit.c
	cc -o logit_mt.o $(CFLAGS) -D_LOGITMT logit.c
	cp $@ $L

.c.o:
	cc -c $(CFLAGS) $<
	cp $@ $L

gd_lib::
	(cd gd_lib; make -f makefile.sol)

libmseed::
	(cd libmseed; make -f makefile.sol)

lint:
	lint $(SRCS) $(GLOBALFLAGS)

clean: 
	/bin/rm -f a.out core *.o *.obj *% *~
	(cd gd_lib; make -f makefile.sol clean)
	(cd libmseed; make -f makefile.sol clean)

realclean: clean
	sh -c 'for o in $(OBJS) ;\
	do /bin/rm -f $L/$$o;\
	done'

