/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.CodecException;

public class USNSN {
    public static final int NBK = 4096;
    public static final int NST = 7;
    static boolean prnt = true;
    static int ipt;
    static int nct;
    static int ifr;
    static int iovr;
    static int ldcmprs;
    static int npt;
    static int[][] nib;
    public static final int[] mask;
    public static final int[] isgn;
    public static final int[] msgn;

    static {
        nib = new int[][]{{4, 4, 4, 6, 6, 8, 8, 10, 10, 12, 14, 16, 20, 24, 28, 32}, {4, 8, 12, 4, 8, 4, 8, 4, 8, 4, 4, 4, 4, 4, 4, 4}, {2, 4, 6, 3, 6, 4, 8, 5, 10, 6, 7, 8, 10, 12, 14, 16}};
        mask = new int[]{3, 15, 63, 255, 1023, 4095, 16383, 65535, 262143, 1048575, 0x3FFFFF, 0xFFFFFF, 0x3FFFFFF, 0xFFFFFFF, 0x3FFFFFFF, -1};
        isgn = new int[]{2, 8, 32, 128, 512, 2048, 8192, 32768, 131072, 524288, 0x200000, 0x800000, 0x2000000, 0x8000000, 0x20000000, Integer.MIN_VALUE};
        int[] nArray = new int[16];
        nArray[0] = -4;
        nArray[1] = -16;
        nArray[2] = -64;
        nArray[3] = -256;
        nArray[4] = -1024;
        nArray[5] = -4096;
        nArray[6] = -16384;
        nArray[7] = -65536;
        nArray[8] = -262144;
        nArray[9] = -1048576;
        nArray[10] = -4194304;
        nArray[11] = -16777216;
        nArray[12] = -67108864;
        nArray[13] = -268435456;
        nArray[14] = -1073741824;
        msgn = nArray;
    }

    public static int[] decode(byte[] b, int numSamples, boolean swapBytes, int bias) throws CodecException {
        throw new CodecException("USNSN decompression is not yet implemented.");
    }

    static int dcmprs(int maxx, IntHolder n, int[] idat, IntHolder eod, IntHolder ovr, byte[] icmp) throws CodecException {
        int ia0 = 0;
        IntHolder fin = new IntHolder();
        IntHolder nn = new IntHolder();
        ipt = 1;
        ia0 = USNSN.gnibleOne(icmp, ipt, 32, 1, 1);
        npt = USNSN.gnibleOne(icmp, ipt, 16, 1, 0);
        ifr = 0;
        ipt = 7;
        nct = ipt - 1;
        int id0 = ia0;
        iovr = 0;
        ldcmprs = 1;
        if (n.getVal() < 0) {
            n.setVal(0);
            idat[n.getVal()] = ia0;
        } else if (idat[n.getVal()] != ia0) {
            if (prnt) {
                System.err.println("########## ia0 mismatch ########## idat=" + idat[n.getVal()] + " ia0=" + ia0);
            }
            ldcmprs = 0;
        }
        int lm = n.getVal() + npt;
        do {
            ++ifr;
            int[] tmp = USNSN.unpacknsn(maxx - n.getVal() - 1, nn, fin, ovr, eod, icmp, id0);
            System.arraycopy(tmp, 0, idat, n.getVal() + 1, tmp.length);
            id0 = tmp[tmp.length - 1];
            if (iovr != 0) {
                int ln = lm <= maxx ? lm : maxx;
                int j = n.getVal() + 1;
                while (j < ln) {
                    idat[j] = 0;
                    ++j;
                }
                n.setVal(ln - 1);
                fin.setVal(1);
            } else {
                n.setVal(n.getVal() + nn.getVal() + 1);
            }
            if (maxx - n.getVal() > 1) continue;
            ovr.setVal(1);
        } while (ovr.getVal() == 0 && fin.getVal() == 0);
        return ldcmprs;
    }

    static int[] unpacknsn(int maxx, IntHolder n, IntHolder fin, IntHolder ovr, IntHolder eod, byte[] icmp, int id0) throws CodecException {
        int[] key = new int[2];
        int[] idat = new int[maxx];
        fin.setVal(0);
        ovr.setVal(0);
        eod.setVal(0);
        USNSN.gnible(icmp, key, ipt, 4, 2, 2, 0);
        if (id0 >= 0x40000000 || key[0] >= 15 || key[1] >= 15) {
            if (prnt) {
                System.err.println("## impending integer overflow ## id0=" + id0 + " keys=" + key[0] + " " + key[1] + " ipt=" + ipt);
            }
            ldcmprs = -1;
            iovr = 1;
            throw new CodecException("impending integer overflow ## id0=" + id0 + " keys=" + key[0] + " " + key[1] + " ipt=" + ipt);
        }
        int js = 0;
        int kpt = 0;
        int j = 0;
        while (j < 2) {
            if (js >= maxx) {
                ovr.setVal(1);
                break;
            }
            int jb = key[j];
            int ln = nib[1][jb] <= maxx - js ? nib[1][jb] : maxx - js;
            ln = ln <= npt ? ln : npt;
            int[] tmp = new int[ln];
            USNSN.gnible(icmp, tmp, ipt, nib[0][jb], ln, nib[1][jb], 1);
            System.arraycopy(tmp, 0, idat, js, ln);
            js += ln;
            kpt += ln;
            if ((npt -= ln) <= 0) {
                fin.setVal(1);
                if (j >= 1) break;
                ipt += nib[2][0];
                break;
            }
            ++j;
        }
        n.setVal(js - 1);
        if (n.getVal() >= 0) {
            idat[0] = idat[0] + id0;
            if (n.getVal() >= 1) {
                j = 1;
                while (j <= n.getVal()) {
                    idat[j] = idat[j] + idat[j - 1];
                    ++j;
                }
            }
        }
        if (ovr.getVal() != 0 || ifr % 7 != 0 && fin.getVal() == 0) {
            return idat;
        }
        nct = ipt - nct;
        int ict = USNSN.gnibleOne(icmp, ipt, 8, 1, 0);
        if (ict != nct) {
            if (prnt) {
                System.err.println("########## nct mismatch ########## ict=" + ict + " nct=" + nct + " ipt=" + ipt);
            }
            if (ldcmprs != -1) {
                ldcmprs = -4;
            }
        }
        nct = ipt - 1;
        if (fin.getVal() == 0 || ipt > 4092) {
            return idat;
        }
        int lpt = USNSN.gnibleOne(icmp, ipt, 8, 1, 0);
        if (lpt == 0) {
            return idat;
        }
        eod.setVal(1);
        if (kpt != lpt) {
            if (prnt) {
                System.err.println("########## kpt mismatch ########## kpt=" + kpt + " lpt=" + lpt + " ipt=" + ipt);
            }
            if (ldcmprs >= 0) {
                ldcmprs = -5;
            }
        }
        ipt = 4093;
        int ian = USNSN.gnibleOne(icmp, ipt, 32, 1, 1);
        if (idat[n.getVal()] != ian) {
            if (prnt) {
                System.err.println("########## ian mismatch ########## ian=" + ian + " idat[n]=" + idat[n.getVal()]);
            }
            if (ldcmprs >= 0) {
                ldcmprs = -6;
            }
        }
        return idat;
    }

    static int gnibleOne(byte[] ib, int ns, int nb, int nrun, int sgn) {
        int[] out = new int[1];
        USNSN.gnible(ib, out, ns, nb, 1, nrun, sgn);
        return out[0];
    }

    static void gnible(byte[] ib, int[] ia, int ns, int nb, int n, int nrun, int sgn) {
        byte[] ja = new byte[4];
        int ka = 0;
        int kb = nb / 2 - 1;
        int isw = kb % 4 + 1;
        int mb = 4 - (kb + 5 - isw) / 4;
        int npt = ns + nrun * nb / 8;
        --ns;
        switch (isw) {
            case 1: 
            case 2: {
                int krun = isw == 1 ? 4 : 2;
                int kshf = 2 * isw;
                int k = 0;
                while (k < n) {
                    int ishf = 8;
                    int ke = k + krun - 1 < n ? k + krun - 1 : n - 1;
                    int i = k;
                    while (i <= ke) {
                        --ns;
                        int j = mb;
                        while (j <= 3) {
                            ja[j] = ib[++ns];
                            ++j;
                        }
                        ia[i] = ((ka >>= (ishf -= kshf)) & isgn[kb]) != 0 & sgn != 0 ? ka | msgn[kb] : ka & mask[kb];
                        ++i;
                    }
                    ++ns;
                    k += krun;
                }
                break;
            }
            case 3: {
                int kshf = 2 * isw;
                int k = 0;
                while (k < n) {
                    int ishf = 8;
                    int ke = k + 3 < n ? k + 3 : n - 1;
                    int i = k;
                    while (i <= ke) {
                        int mbe;
                        if ((ishf -= kshf) < 0) {
                            mbe = mb - 1;
                            ishf += 8;
                        } else {
                            mbe = mb;
                        }
                        --ns;
                        int j = mbe;
                        while (j <= 3) {
                            ja[j] = ib[++ns];
                            ++j;
                        }
                        ia[i] = ((ka >>= ishf) & isgn[kb]) != 0 & sgn != 0 ? ka | msgn[kb] : ka & mask[kb];
                        ++i;
                    }
                    ++ns;
                    k += 4;
                }
                break;
            }
            case 4: {
                --ns;
                int i = 0;
                while (i < n) {
                    int j = mb;
                    while (j <= 3) {
                        ja[j] = ib[++ns];
                        ++j;
                    }
                    ia[i] = (ka & isgn[kb]) != 0 & sgn != 0 ? ka | msgn[kb] : ka & mask[kb];
                    ++i;
                }
                break;
            }
        }
        ns = npt;
    }

    static void dcmpbr() {
        prnt = !prnt;
    }

    static void dcmper(int ierr) throws CodecException {
        switch (ierr) {
            case 1: {
                break;
            }
            case 0: {
                throw new CodecException("IA0 mismatch in Dcmprs.");
            }
            case -1: {
                throw new CodecException("Integer overflow in Dcmprs.");
            }
            case -4: {
                throw new CodecException("NCT mismatch in Dcmprs.");
            }
            case -5: {
                throw new CodecException("KPT mismatch in Dcmprs.");
            }
            case -6: {
                throw new CodecException("IAN mismatch in Dcmprs.");
            }
            default: {
                throw new CodecException("Unknown error in Dcmprs (" + ierr + ").");
            }
        }
    }

    static class IntHolder {
        int val;

        public IntHolder(int val) {
            this.val = val;
        }

        public IntHolder() {
            this(0);
        }

        public void setVal(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }
}

