/*
 * Decompiled with CFR 0.152.
 */
package com.isti.dhi;

import com.isti.dhi.FissuresUtils;
import com.isti.dhi.IChannelInfo;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.AllVTFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class CorbaAccess {
    private static final File corbaPropsFile = new File("res/orb.properties");
    private static final String ORBClassProperty = "org.omg.CORBA.ORBClass";
    private static final String ORBSingletonClassProperty = "org.omg.CORBA.ORBSingletonClass";
    private static final String NameServiceProperty = "NameService";
    private static final String NetworkDNSProperty = "NetworkDNS";
    private static final String NetworkDCProperty = "NetworkDC";
    private static final String SeismogramDNSProperty = "SeismogramDNS";
    private static final String SeismogramDCProperty = "SeismogramDC";
    private static final String DEFAULT_ORB_CLASS = "com.ooc.CORBA.ORB";
    private static final String DEFAULT_ORB_SINGLETON_CLASS = "org.omg.CORBA.ORBSingletonClass";
    private static final String DEFAULT_NAME_SERVICE_PROPERTY_NAME = "ooc.orb.service.NameService";
    private final String[] siteCodeSubstitutions = new String[]{"--", "  "};
    private final String defaultDataCenterObjectName;
    private final String defaultDataCenterPath;
    private final String defaultNameService;
    private final String defaultSeismogramObjectName;
    private final String defaultSeismogramPath;
    private final ORB orb;
    private NamingContextExt nameContextObj = null;
    private NetworkFinder networkFinderObj = null;

    public CorbaAccess(File fissuresPropsFile) {
        this(fissuresPropsFile, new String[0], null);
    }

    protected CorbaAccess(File fissuresPropsFile, String[] args, Properties propsObj) {
        ORB orb23Obj;
        Properties fissuresProps = new Properties();
        if (fissuresPropsFile != null) {
            try {
                fissuresProps.load(new FileInputStream(fissuresPropsFile));
            }
            catch (Exception ex) {
                System.err.println("Error loading FISSURES/CORBA server properties: " + ex);
            }
        }
        this.defaultDataCenterObjectName = fissuresProps.getProperty(NetworkDCProperty, "IRIS_NetworkDC");
        this.defaultDataCenterPath = fissuresProps.getProperty(NetworkDNSProperty, "edu/iris/dmc");
        this.defaultNameService = fissuresProps.getProperty(NameServiceProperty, "corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        this.defaultSeismogramObjectName = fissuresProps.getProperty(SeismogramDCProperty, "IRIS_DataCenter");
        this.defaultSeismogramPath = fissuresProps.getProperty(SeismogramDNSProperty, "edu/iris/dmc");
        if (propsObj == null) {
            propsObj = new Properties(System.getProperties());
        }
        CorbaAccess.loadCorbaPproperties(propsObj);
        FissuresUtils.enterDefaultPropValue(propsObj, ORBClassProperty, DEFAULT_ORB_CLASS);
        FissuresUtils.enterDefaultPropValue(propsObj, "org.omg.CORBA.ORBSingletonClass", "org.omg.CORBA.ORBSingletonClass");
        String nameServicePropertyName = propsObj.getProperty(NameServiceProperty);
        if (nameServicePropertyName == null) {
            nameServicePropertyName = DEFAULT_NAME_SERVICE_PROPERTY_NAME;
        }
        FissuresUtils.enterDefaultPropValue(propsObj, nameServicePropertyName, this.defaultNameService);
        CorbaAccess.printCorbaPproperties(propsObj);
        org.omg.CORBA.ORB orb0Obj = org.omg.CORBA.ORB.init(args, propsObj);
        this.orb = orb23Obj = (ORB)orb0Obj;
        try {
            new AllVTFactory().register(this.orb);
        }
        catch (Exception ex) {
            System.err.println("Error registering valuetype factories:  " + ex);
            ex.printStackTrace();
        }
    }

    private static void loadCorbaPproperties(Properties propsObj) {
        BufferedInputStream inStm;
        if (!corbaPropsFile.exists()) {
            return;
        }
        try {
            inStm = new BufferedInputStream(new FileInputStream(corbaPropsFile));
        }
        catch (Exception ex) {
            System.err.println("Unable to open CORBA property file \"" + corbaPropsFile.getPath() + "\":  " + ex);
            ex.printStackTrace();
            return;
        }
        try {
            propsObj.load(inStm);
            System.out.println("loaded CORBA property file: " + corbaPropsFile.getPath());
        }
        catch (Exception ex) {
            System.err.println("Error loading CORBA property file \"" + corbaPropsFile.getPath() + "\":  " + ex);
            ex.printStackTrace();
            return;
        }
        try {
            ((InputStream)inStm).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void printCorbaPproperties(Properties propsObj) {
        try {
            Enumeration<java.lang.Object> keysEnumeration = propsObj.keys();
            while (keysEnumeration.hasMoreElements()) {
                java.lang.Object key = keysEnumeration.nextElement();
                if (!(key instanceof String)) continue;
                System.out.println(key + "=" + propsObj.getProperty((String)key));
            }
        }
        catch (Exception ex) {
            System.err.println("Error logging CORBA properties: " + ex);
            ex.printStackTrace();
        }
    }

    public void destroyORB() {
        try {
            this.orb.destroy();
        }
        catch (Exception ex) {
            System.err.println("Error destroying CORBA ORB:  " + ex);
            ex.printStackTrace();
        }
    }

    public NetworkAccess[] findNetworks(String networkCode) {
        if (this.networkFinderObj == null) {
            this.resolveNetworkFinder();
        }
        if (this.networkFinderObj == null) {
            return null;
        }
        try {
            return this.networkFinderObj.retrieve_by_code(networkCode);
        }
        catch (NetworkNotFound ex) {
            System.err.println("Could not find network by code: " + ex);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println("Error calling 'NetworkFinder.retrieve_by_code()':  " + ex);
            ex.printStackTrace();
        }
        return null;
    }

    public Channel[] getChannels(NetworkAccess nAccObj, Station stationObj) {
        return nAccObj.retrieve_for_station(stationObj.get_id());
    }

    public LocalSeismogram[] getData(IChannelInfo channelInfo, Date startTime, Date endTime) throws Exception {
        Time fissuresBeginTime = FissuresUtils.getTime(startTime);
        Time fissuresEndTime = FissuresUtils.getTime(endTime);
        NetworkId networkId = new NetworkId();
        ChannelId channelId = new ChannelId();
        networkId.network_code = channelInfo.getNetworkName();
        Date networkBeginTime = channelInfo.getNetworkBeginTime();
        networkId.begin_time = networkBeginTime != null ? FissuresUtils.getTime(networkBeginTime) : fissuresBeginTime;
        channelId.network_id = networkId;
        channelId.station_code = channelInfo.getStationName();
        channelId.site_code = channelInfo.getLocationName();
        channelId.channel_code = channelInfo.getChannelName();
        Date channelBeginTime = channelInfo.getChannelBeginTime();
        channelId.begin_time = channelBeginTime != null ? FissuresUtils.getTime(channelBeginTime) : fissuresBeginTime;
        return this.getData(channelId, fissuresBeginTime, fissuresEndTime);
    }

    public LocalSeismogram[] getData(ChannelId channelId, Time start, Time end) throws Exception {
        if (this.networkFinderObj == null) {
            this.resolveNetworkFinder();
        }
        if (this.networkFinderObj == null) {
            throw new IllegalArgumentException("Could not resolve network finder");
        }
        RequestFilter requestFilter = new RequestFilter(channelId, start, end);
        DataCenter seisDC = FissuresUtils.getSeismogramDC(this.nameContextObj, this.defaultSeismogramPath, this.defaultSeismogramObjectName);
        this.substituteRequestFilter(requestFilter);
        System.out.println("requesting data for " + requestFilter.channel_id.network_id.network_code + "." + requestFilter.channel_id.station_code + "." + requestFilter.channel_id.site_code.trim() + "." + requestFilter.channel_id.channel_code + " " + requestFilter.start_time.date_time + " - " + requestFilter.end_time.date_time);
        RequestFilter[] requestFilters = new RequestFilter[]{requestFilter};
        LocalSeismogram[] localSeismograms = seisDC.retrieve_seismograms(requestFilters);
        System.out.println("Got " + localSeismograms.length + " seismograms");
        return localSeismograms;
    }

    public boolean hasData(ChannelId channelId, Time start, Time end) throws Exception {
        if (this.networkFinderObj == null) {
            this.resolveNetworkFinder();
        }
        if (this.networkFinderObj == null) {
            throw new IllegalArgumentException("Could not resolve network finder");
        }
        RequestFilter requestFilter = new RequestFilter(channelId, start, end);
        DataCenter seisDC = FissuresUtils.getSeismogramDC(this.nameContextObj, this.defaultSeismogramPath, this.defaultSeismogramObjectName);
        this.substituteRequestFilter(requestFilter);
        RequestFilter[] requestFilters = new RequestFilter[]{requestFilter};
        RequestFilter[] resultSeismogramRequest = seisDC.available_data(requestFilters);
        System.out.println("querying for " + requestFilter.channel_id.network_id.network_code + "." + requestFilter.channel_id.station_code + "." + requestFilter.channel_id.site_code + "." + requestFilter.channel_id.channel_code);
        boolean hasDataFlag = resultSeismogramRequest != null && resultSeismogramRequest.length > 0;
        return hasDataFlag;
    }

    public boolean resolveNetworkFinder() {
        if (!(this.nameContextObj != null || this.resolveNameService() && this.nameContextObj != null)) {
            return false;
        }
        String pathStr = this.defaultDataCenterPath;
        String objNameStr = this.defaultDataCenterObjectName;
        NetworkDC networkDC = null;
        try {
            networkDC = FissuresUtils.getNetworkDC(this.nameContextObj, pathStr, objNameStr);
        }
        catch (Exception ex) {
            System.err.println("Error finding Network DataCenter \"" + pathStr + "/" + objNameStr + "\":  " + ex);
            ex.printStackTrace();
            return false;
        }
        try {
            this.networkFinderObj = networkDC.a_finder();
            return true;
        }
        catch (Exception ex) {
            System.err.println("Error fetching NetworkFinder from DataCenter \"" + pathStr + "/" + objNameStr + "\":  " + ex);
            ex.printStackTrace();
            return false;
        }
    }

    public boolean resolveNameService() {
        try {
            Object cObj = this.orb.resolve_initial_references(NameServiceProperty);
            if (cObj == null) {
                System.err.println("Unable to resolve initial reference to \"NameService\"");
                return false;
            }
            this.nameContextObj = NamingContextExtHelper.narrow(cObj);
            return true;
        }
        catch (Exception ex) {
            System.err.println("Error resolving initial reference to \"NameService\":  " + ex);
            ex.printStackTrace();
            return false;
        }
    }

    protected void substituteRequestFilter(RequestFilter requestFilter) {
        if (this.siteCodeSubstitutions != null) {
            int maxIndex = this.siteCodeSubstitutions.length - 1;
            for (int i = 0; i < maxIndex; i += 2) {
                String text = this.siteCodeSubstitutions[i];
                if (!requestFilter.channel_id.site_code.equals(text)) continue;
                requestFilter.channel_id.site_code = text = this.siteCodeSubstitutions[i + 1];
            }
        }
    }
}

