# This is Eqassemble's Parameter File

# Basic Earthworm setup:
#-----------------------
 MyModuleId   MOD_EQASSEMBLE    # Module id for this instance of eqassemble
 RingName     PICK_RING     # Ring to get input from
 HeartbeatInt 30            # seconds between heartbeats to statmgr
 LogFile      1             # 0 = turn off disk log file; 
                            # 1 = turn on disk log
                            # 2 = write disk log but not to stderr/stdout

# List the message logos to grab from transport ring
#               Installation       Module          Message Types
#-----------------------------------------------------------------
 GetPicksFrom   INST_WILDCARD    MOD_WILDCARD    # pick2k & coda2k
 GetAssocFrom   INST_MENLO       MOD_BINDER      # quake2k & link2k
  
# Send output to the following command (uncomment one):
#------------------------------------------------------
 PipeTo "eqbuf eqbuf.d"     # buffer events for downstream modules
#PipeTo "eqcoda eqcoda.d"   # do coda weighting & extrapolation
#PipeTo "log_everything"    # end chain here for debugging

# Load station list
#------------------
 maxsite     3500
 site_file   calsta.hinv

# Load crustal model
# Refer to file containing "lay" commands, or list them here
#-----------------------------------------------------------
#@ncal_model.d           # file containing "lay" commands
 lay   0.0     4.0
 lay   3.5     5.9
 lay   15.0    6.85
 lay   25.0    7.85

# Set pick/quake FIFO lengths (must be >= binder's fifo lengths)
#---------------------------------------------------------------
 pick_fifo_length  1000  # optional: default = 1000
 quake_fifo_length  100  # optional: default = 100

# Control how/when events are reported
#-------------------------------------
 ReportS      0     # 0 = do not send S-phases to next process
                    # non-zero = do send S-phases to next process
 HypCheckInterval  5.0	# interval (sec) at which to check all hypocenters   
                    #   to see if it's time to report an event


# Rules for reporting events
#---------------------------
# At least one of these rules must be given; there are no defaults
# Syntax:
#	PrelimRule numPhases
#		Event2K message released with version 0 when event has
#		<numPhases> P phases associated.
#	RapidRule numPhases seconds SinceOrigin
#     or
#	RapidRule numPhases seconds SinceDetection
#		Event2K message released with version 1 <seconds> since
#		origin or detection time provided <numPhases> P phases 
#		associated.
#	FinalRule numPhases seconds [WaitForCodas]
#		Event2K message released with version 2 when solution has
#		been stable for <seconds>, has <numPhases> P phases associated,
#		and optionally after codas have arrived. 
# Codas are reported only with the FinalRule and only if the
# WaitForCodas flag is included in the FinalRule command
#
PrelimRule    25
RapidRule     5 30 SinceDetection
FinalRule     4 60 WaitForCodas

# If we are going to wait for codas, and some picks are imported from
# other Earthworm Installations, eqassemble can optionally wait for codas
# from those other installations with one or more of:
# CodaFromInst InstId
# You do not need to list your own Inst ID.
# CodaFromInst is ignored if the FinalRule does not wait for codas.
CodaFromInst INST_MENLO

# DataSrc: single character to indicate the source of phase data
DataSrc    W

# MaxPhasesPerEq: restrict the number of phases to be reported for
# the RapidRule and FinalRule to this value. Cannot be set greater than
# the Earthworm limit of 250, which is also the default for this parameter.
MaxPhasesPerEq 250

# Control debugging info to log
#------------------------------
 WaifTolerance   4.0  # tolerance (sec) for noting waif picks for
		      #   in log file. (optional: default = 4.0)

