/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.Any;
import com.ooc.CORBA.DataInputStream;
import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.CORBA.TypeCode;
import com.ooc.OB.Assert;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Util;
import com.ooc.OB.ValueFactoryManager;
import com.ooc.OCI.Buffer;
import java.io.Serializable;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;

public final class ValueReader {
    private ORBInstance orbInstance_;
    private InputStream in_;
    private Buffer buf_;
    private Hashtable instanceTable_;
    private Hashtable headerTable_;
    private Hashtable positionTable_;
    private int remarshalDepth_;
    private ChunkState chunkState_ = new ChunkState();
    private Header currentHeader_;

    private void addInstance(int n, Serializable serializable) {
        this.instanceTable_.put(new Integer(n), serializable);
    }

    private void removeInstance(int n) {
        this.instanceTable_.remove(new Integer(n));
    }

    private void readHeader(Header header) {
        int n;
        int n2;
        int n3;
        String string;
        Assert.assert(header.tag != 0 && header.tag != -1);
        if ((header.tag & 8) == 8) {
            header.state.chunked = true;
        }
        if ((header.tag & 1) == 1) {
            string = null;
            n3 = this.buf_.pos_;
            n2 = this.in_.read_long();
            if (n2 == -1) {
                n = this.in_.read_long();
                if (n >= -4) {
                    throw new MARSHAL();
                }
                int n4 = this.buf_.pos_;
                this.buf_.pos_ = this.buf_.pos_ - 4 + n;
                if (this.buf_.pos_ < 0) {
                    throw new MARSHAL();
                }
                string = this.in_.read_string();
                this.buf_.pos_ = n4;
            } else {
                this.buf_.pos_ = n3;
                string = this.in_.read_string();
            }
        }
        if ((header.tag & 6) != 0) {
            if ((header.tag & 6) == 6) {
                int n5 = this.buf_.pos_;
                n3 = this.in_.read_long();
                if (n3 == -1) {
                    n2 = this.in_.read_long();
                    if (n2 > -4) {
                        throw new MARSHAL();
                    }
                    n5 = this.buf_.pos_;
                    this.buf_.pos_ = this.buf_.pos_ - 4 + n2;
                    if (this.buf_.pos_ < 0) {
                        throw new MARSHAL();
                    }
                } else {
                    this.buf_.pos_ = n5;
                }
                n2 = this.in_.read_long();
                header.ids = new String[n2];
                n = 0;
                while (n < n2) {
                    header.ids[n] = this.in_.read_string();
                    ++n;
                }
                if (n3 == -1) {
                    this.buf_.pos_ = n5;
                }
            } else if ((header.tag & 6) == 2) {
                n3 = this.buf_.pos_;
                n2 = this.in_.read_long();
                if (n2 == -1) {
                    n = this.in_.read_long();
                    if (n > -4) {
                        throw new MARSHAL();
                    }
                    n3 = this.buf_.pos_;
                    this.buf_.pos_ = this.buf_.pos_ - 4 + n;
                    if (this.buf_.pos_ < 0) {
                        throw new MARSHAL();
                    }
                    string = this.in_.read_string();
                    this.buf_.pos_ = n3;
                } else {
                    this.buf_.pos_ = n3;
                    string = this.in_.read_string();
                }
                header.ids = new String[1];
                header.ids[0] = string;
            }
        }
        header.dataPos = this.buf_.pos_;
        this.headerTable_.put(new Integer(header.headerPos), header);
    }

    private void readChunk(ChunkState chunkState) {
        int n = this.in_._OB_readLongUnchecked();
        if (n >= 0 && n < 0x7FFFFF00) {
            chunkState.chunkStart = this.buf_.pos_;
            chunkState.chunkSize = n;
            return;
        }
        if (n < 0) {
            this.buf_.pos_ -= 4;
            chunkState.chunkStart = this.buf_.pos_;
            chunkState.chunkSize = 0;
            return;
        }
        this.buf_.pos_ -= 4;
        chunkState.chunkStart = 0;
        chunkState.chunkSize = 0;
    }

    private void initHeader(Header header) {
        Assert.assert(header.tag != 0 && header.tag != -1);
        header.headerPos = this.buf_.pos_ - 4;
        header.state.copyFrom(this.chunkState_);
        this.readHeader(header);
        this.chunkState_.copyFrom(header.state);
        if (this.chunkState_.chunked) {
            this.readChunk(this.chunkState_);
            ++this.chunkState_.nestingLevel;
        }
    }

    private void skipChunk() {
        if (this.chunkState_.chunked) {
            if (this.chunkState_.chunkStart > 0) {
                this.buf_.pos_ = this.chunkState_.chunkStart;
                this.in_._OB_skip(this.chunkState_.chunkSize);
            }
            this.chunkState_.chunkStart = 0;
            this.chunkState_.chunkSize = 0;
            int n = this.chunkState_.nestingLevel;
            int n2 = this.in_._OB_readLongUnchecked();
            while (n2 >= 0 || n2 < 0 && n2 < -this.chunkState_.nestingLevel) {
                if (n2 >= 0x7FFFFF00) {
                    Header header = new Header();
                    header.tag = n2;
                    header.headerPos = this.buf_.pos_ - 4;
                    header.state.nestingLevel = ++n;
                    this.readHeader(header);
                } else if (n2 >= 0) {
                    this.in_._OB_skip(n2);
                } else {
                    --n;
                }
                n2 = this.in_._OB_readLongUnchecked();
            }
            if (n2 > -this.chunkState_.nestingLevel) {
                this.buf_.pos_ -= 4;
            }
            --this.chunkState_.nestingLevel;
            if (this.chunkState_.nestingLevel == 0) {
                this.chunkState_.chunked = false;
                return;
            }
            this.readChunk(this.chunkState_);
        }
    }

    private void unmarshalValueState(Serializable serializable) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this.in_);
            return;
        }
        if (serializable instanceof CustomMarshal) {
            DataInputStream dataInputStream = new DataInputStream(this.in_);
            ((CustomMarshal)((Object)serializable)).unmarshal(dataInputStream);
            return;
        }
        throw new MARSHAL("Valuetype does not implement StreamableValue or CustomMarshal");
    }

    private Serializable readIndirection(CreationStrategy creationStrategy) {
        Integer n;
        Serializable serializable;
        int n2 = this.in_.read_long();
        int n3 = this.buf_.pos_ - 4 + n2;
        n3 += 3;
        if ((serializable = (Serializable)this.instanceTable_.get(n = new Integer(n3 -= n3 & 3))) != null) {
            return serializable;
        }
        int n4 = this.buf_.pos_;
        this.buf_.pos_ = n3;
        if (this.in_._OB_readLongUnchecked() == 0) {
            this.buf_.pos_ = n4;
            return null;
        }
        Header header = (Header)this.headerTable_.get(n);
        if (header == null) {
            throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": cannot instantiate value for indirection", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.buf_.pos_ = header.dataPos;
        ChunkState chunkState = new ChunkState(this.chunkState_);
        this.chunkState_.copyFrom(header.state);
        if (this.chunkState_.chunked) {
            this.readChunk(this.chunkState_);
        }
        try {
            serializable = creationStrategy.create(header);
        }
        finally {
            Object var10_9 = null;
            this.buf_.pos_ = n4;
            this.chunkState_.copyFrom(chunkState);
        }
        return serializable;
    }

    private Serializable read(CreationStrategy creationStrategy) {
        Header header = new Header();
        header.tag = this.in_.read_long();
        if (header.tag == 0) {
            return null;
        }
        if (header.tag == -1) {
            return this.readIndirection(creationStrategy);
        }
        if (header.tag < 0x7FFFFF00) {
            throw new MARSHAL("Illegal valuetype tag 0x" + Integer.toHexString(header.tag));
        }
        this.initHeader(header);
        Serializable serializable = creationStrategy.create(header);
        this.skipChunk();
        return serializable;
    }

    private void copyValueState(org.omg.CORBA.TypeCode typeCode, OutputStream outputStream) {
        try {
            if (typeCode.kind() == TCKind.tk_value) {
                org.omg.CORBA.TypeCode typeCode2 = typeCode.concrete_base_type();
                if (typeCode2 != null) {
                    this.copyValueState(typeCode2, outputStream);
                }
                int n = 0;
                while (n < typeCode.member_count()) {
                    outputStream.write_InputStream(this.in_, typeCode.member_type(n));
                    ++n;
                }
                return;
            }
            if (typeCode.kind() == TCKind.tk_value_box) {
                outputStream.write_InputStream(this.in_, typeCode.content_type());
                return;
            }
            Assert.assert(false);
            return;
        }
        catch (BadKind badKind) {
            Assert.assert(false);
            return;
        }
        catch (Bounds bounds) {
            Assert.assert(false);
            return;
        }
    }

    private void pushHeader(Header header) {
        header.next = this.currentHeader_;
        this.currentHeader_ = header;
    }

    private void popHeader() {
        Assert.assert(this.currentHeader_ != null);
        this.currentHeader_ = this.currentHeader_.next;
    }

    private org.omg.CORBA.TypeCode findTypeCode(String string, org.omg.CORBA.TypeCode typeCode) {
        org.omg.CORBA.TypeCode typeCode2 = null;
        org.omg.CORBA.TypeCode typeCode3 = typeCode;
        while (typeCode2 == null) {
            try {
                TypeCode typeCode4 = ((TypeCode)typeCode3)._OB_getOrigType();
                if (string.equals(((org.omg.CORBA.TypeCode)typeCode4).id())) {
                    typeCode2 = typeCode3;
                    continue;
                }
                if (((org.omg.CORBA.TypeCode)typeCode4).kind() != TCKind.tk_value || ((org.omg.CORBA.TypeCode)typeCode4).type_modifier() != 3) break;
                typeCode3 = ((org.omg.CORBA.TypeCode)typeCode4).concrete_base_type();
            }
            catch (BadKind badKind) {
                Assert.assert(false);
            }
        }
        return typeCode2;
    }

    public ValueReader(InputStream inputStream) {
        this.in_ = inputStream;
        this.buf_ = inputStream._OB_buffer();
        this.orbInstance_ = inputStream._OB_ORBInstance();
        this.instanceTable_ = new Hashtable(131);
        this.headerTable_ = new Hashtable(131);
        this.remarshalDepth_ = 0;
    }

    public Serializable readValue() {
        FactoryCreationStrategy factoryCreationStrategy = new FactoryCreationStrategy(this, this.in_, null);
        return this.read(factoryCreationStrategy);
    }

    public Serializable readValue(String string) {
        FactoryCreationStrategy factoryCreationStrategy = new FactoryCreationStrategy(this, this.in_, string);
        return this.read(factoryCreationStrategy);
    }

    public Serializable readValue(Class clazz) {
        ClassCreationStrategy classCreationStrategy = new ClassCreationStrategy(this, this.in_, clazz);
        return this.read(classCreationStrategy);
    }

    public Serializable readValueBox(BoxedValueHelper boxedValueHelper) {
        BoxCreationStrategy boxCreationStrategy = new BoxCreationStrategy(this, this.in_, boxedValueHelper);
        return this.read(boxCreationStrategy);
    }

    public void initializeValue(Serializable serializable) {
        Assert.assert(this.currentHeader_ != null);
        this.addInstance(this.currentHeader_.headerPos, serializable);
        try {
            this.unmarshalValueState(serializable);
            return;
        }
        catch (SystemException systemException) {
            this.removeInstance(this.currentHeader_.headerPos);
            throw systemException;
        }
    }

    public Object readAbstractInterface() {
        if (this.in_.read_boolean()) {
            return this.in_.read_Object();
        }
        return this.readValue();
    }

    public Object readAbstractInterface(Class clazz) {
        if (this.in_.read_boolean()) {
            return this.in_.read_Object(clazz);
        }
        return this.readValue(clazz);
    }

    public org.omg.CORBA.TypeCode remarshalValue(org.omg.CORBA.TypeCode typeCode, OutputStream outputStream) {
        org.omg.CORBA.TypeCode typeCode2;
        block28: {
            if (this.remarshalDepth_ == 0) {
                this.positionTable_ = new Hashtable(131);
            }
            ++this.remarshalDepth_;
            TypeCode typeCode3 = ((TypeCode)typeCode)._OB_getOrigType();
            typeCode2 = null;
            try {
                Header header = new Header();
                header.tag = this.in_.read_long();
                header.headerPos = this.buf_.pos_ - 4;
                header.state.copyFrom(this.chunkState_);
                int n = header.headerPos;
                if (header.tag == 0) {
                    outputStream.write_long(0);
                    typeCode2 = typeCode;
                    break block28;
                }
                if (header.tag == -1) {
                    Integer n2;
                    int n3 = this.in_.read_long();
                    int n4 = this.buf_.pos_ - 4 + n3;
                    n4 += 3;
                    if ((n2 = (Integer)this.positionTable_.get(new Integer(n4 -= n4 & 3))) != null) {
                        outputStream.write_long(header.tag);
                        n3 = n2 - outputStream._OB_pos();
                        outputStream.write_long(n3);
                        typeCode2 = typeCode;
                        break block28;
                    }
                    throw new MARSHAL("Cannot find value for indirection");
                }
                int n5 = outputStream._OB_pos();
                n5 += 3;
                n5 -= n5 & 3;
                this.positionTable_.put(new Integer(n), new Integer(n5));
                this.readHeader(header);
                this.chunkState_.copyFrom(header.state);
                if (this.chunkState_.chunked) {
                    this.readChunk(this.chunkState_);
                    ++this.chunkState_.nestingLevel;
                }
                String string = null;
                short s = 0;
                try {
                    string = ((org.omg.CORBA.TypeCode)typeCode3).id();
                    if (((org.omg.CORBA.TypeCode)typeCode3).kind() == TCKind.tk_value) {
                        s = ((org.omg.CORBA.TypeCode)typeCode3).type_modifier();
                    }
                }
                catch (BadKind badKind) {
                    Assert.assert(false);
                }
                String string2 = null;
                int n6 = 0;
                while (n6 < header.ids.length) {
                    if (string.equals(header.ids[n6])) {
                        string2 = header.ids[n6];
                        break;
                    }
                    ++n6;
                }
                String string3 = null;
                int n7 = 0;
                ValueFactory valueFactory = null;
                if (this.orbInstance_ != null) {
                    ValueFactoryManager valueFactoryManager = this.orbInstance_.getValueFactoryManager();
                    n7 = 0;
                    while (n7 < header.ids.length) {
                        valueFactory = valueFactoryManager.lookupValueFactoryWithClass(header.ids[n7]);
                        if (valueFactory != null) {
                            string3 = header.ids[n7];
                            break;
                        }
                        ++n7;
                    }
                }
                if (header.ids.length > 0 && string2 == null && string3 == null) {
                    throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": insufficient information to copy valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                if (s == 1 && string3 == null) {
                    throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": unable to copy custom valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                if (n6 < n7 || header.ids.length == 0 || ((org.omg.CORBA.TypeCode)typeCode3).kind() == TCKind.tk_value_box) {
                    int n8 = header.ids.length - n6;
                    String[] stringArray = new String[n8];
                    int n9 = n6;
                    while (n9 < header.ids.length) {
                        stringArray[n9 - n6] = header.ids[n9];
                        ++n9;
                    }
                    outputStream._OB_beginValue(header.tag, stringArray, header.state.chunked);
                    this.copyValueState(typeCode3, outputStream);
                    outputStream._OB_endValue();
                    typeCode2 = typeCode;
                } else {
                    try {
                        this.pushHeader(header);
                        Serializable serializable = valueFactory.read_value(this.in_);
                        try {
                            outputStream.write_value(serializable);
                        }
                        finally {
                            Object var21_26 = null;
                            this.removeInstance(header.headerPos);
                        }
                        Object var18_22 = null;
                        this.popHeader();
                    }
                    catch (Throwable throwable) {
                        Object var18_23 = null;
                        this.popHeader();
                        throw throwable;
                    }
                    typeCode2 = this.findTypeCode(header.ids[n7], typeCode);
                    if (typeCode2 == null) {
                        typeCode2 = typeCode;
                    }
                }
                this.skipChunk();
            }
            catch (Throwable throwable) {
                Object var6_30 = null;
                --this.remarshalDepth_;
                if (this.remarshalDepth_ == 0) {
                    this.positionTable_ = null;
                }
                throw throwable;
            }
        }
        Object var6_29 = null;
        --this.remarshalDepth_;
        if (this.remarshalDepth_ == 0) {
            this.positionTable_ = null;
        }
        Assert.assert(typeCode2 != null);
        return typeCode2;
    }

    public void readValueAny(org.omg.CORBA.Any any, org.omg.CORBA.TypeCode typeCode) {
        Any any2 = (Any)any;
        TypeCode typeCode2 = ((TypeCode)typeCode)._OB_getOrigType();
        if (typeCode2.kind() == TCKind.tk_abstract_interface) {
            boolean bl = this.in_.read_boolean();
            if (bl) {
                any2.replace(typeCode, this.in_.read_Object());
                return;
            }
            any2.replace(typeCode, this.readValue());
            return;
        }
        try {
            String string = typeCode2.id();
            if (string.equals("IDL:omg.org/CORBA/ValueBase:1.0")) {
                any2.replace(typeCode, this.readValue());
                return;
            }
        }
        catch (BadKind badKind) {
            Assert.assert(false);
        }
        int n = this.buf_.pos_;
        ChunkState chunkState = new ChunkState(this.chunkState_);
        if (typeCode2.kind() == TCKind.tk_value_box) {
            try {
                any2.replace(typeCode, this.readValue(typeCode.id()));
                return;
            }
            catch (MARSHAL mARSHAL) {
                this.buf_.pos_ = n;
                this.chunkState_.copyFrom(chunkState);
                Buffer buffer = new Buffer();
                OutputStream outputStream = new OutputStream(buffer);
                outputStream._OB_ORBInstance(this.orbInstance_);
                this.remarshalValue(typeCode2, outputStream);
                InputStream inputStream = (InputStream)outputStream.create_input_stream();
                any2.replace(typeCode, inputStream);
            }
            catch (BadKind badKind) {
                Assert.assert(false);
            }
        } else {
            Header header = new Header();
            header.tag = this.in_.read_long();
            if (header.tag == 0) {
                any2.replace(typeCode, null);
                return;
            }
            if (header.tag != -1 && header.tag < 0x7FFFFF00) {
                throw new MARSHAL("Illegal valuetype tag 0x" + Integer.toHexString(header.tag));
            }
            FactoryCreationStrategy factoryCreationStrategy = new FactoryCreationStrategy(this, this.in_, null);
            try {
                if (header.tag == -1) {
                    any2.replace(typeCode, this.readIndirection(factoryCreationStrategy));
                    return;
                }
                this.initHeader(header);
                StringHolder stringHolder = new StringHolder();
                Serializable serializable = factoryCreationStrategy.create(header, stringHolder);
                this.skipChunk();
                org.omg.CORBA.TypeCode typeCode3 = this.findTypeCode(stringHolder.value, typeCode);
                if (typeCode3 != null) {
                    any2.replace(typeCode3, serializable);
                    return;
                }
                any2.replace(typeCode, serializable);
                return;
            }
            catch (MARSHAL mARSHAL) {
                this.buf_.pos_ = n;
                this.chunkState_.copyFrom(chunkState);
                Buffer buffer = new Buffer();
                OutputStream outputStream = new OutputStream(buffer);
                outputStream._OB_ORBInstance(this.orbInstance_);
                org.omg.CORBA.TypeCode typeCode4 = this.remarshalValue(typeCode2, outputStream);
                InputStream inputStream = (InputStream)outputStream.create_input_stream();
                any2.replace(typeCode4, inputStream);
                return;
            }
        }
        Assert.assert(false);
    }

    public void beginValue() {
        Header header = new Header();
        header.tag = this.in_.read_long();
        Assert.assert(header.tag != 0 && header.tag != -1);
        this.initHeader(header);
    }

    public void endValue() {
        this.skipChunk();
    }

    public void checkChunk() {
        if (!this.chunkState_.chunked) {
            return;
        }
        if (this.chunkState_.chunkStart > 0 && this.chunkState_.chunkStart + this.chunkState_.chunkSize == this.buf_.pos_) {
            this.readChunk(this.chunkState_);
        }
    }

    private static class ChunkState {
        boolean chunked;
        int nestingLevel;
        int chunkStart;
        int chunkSize;

        ChunkState() {
        }

        ChunkState(ChunkState chunkState) {
            this.copyFrom(chunkState);
        }

        void copyFrom(ChunkState chunkState) {
            this.chunked = chunkState.chunked;
            this.nestingLevel = chunkState.nestingLevel;
            this.chunkStart = chunkState.chunkStart;
            this.chunkSize = chunkState.chunkSize;
        }
    }

    private static class Header {
        int tag;
        int headerPos;
        int dataPos;
        String[] ids = new String[0];
        ChunkState state = new ChunkState();
        Header next;

        Header() {
        }
    }

    private static abstract class CreationStrategy {
        protected ValueReader reader_;
        protected InputStream is_;

        CreationStrategy(ValueReader valueReader, InputStream inputStream) {
            this.reader_ = valueReader;
            this.is_ = inputStream;
        }

        abstract Serializable create(Header var1);
    }

    private static class BoxCreationStrategy
    extends CreationStrategy {
        private BoxedValueHelper helper_;

        BoxCreationStrategy(ValueReader valueReader, InputStream inputStream, BoxedValueHelper boxedValueHelper) {
            super(valueReader, inputStream);
            this.helper_ = boxedValueHelper;
        }

        Serializable create(Header header) {
            Assert.assert(header.tag >= 0x7FFFFF00 && header.tag != -1);
            Serializable serializable = this.helper_.read_value(this.is_);
            if (serializable != null) {
                this.reader_.addInstance(header.headerPos, serializable);
                return serializable;
            }
            throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": " + this.helper_.get_id(), 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static class ClassCreationStrategy
    extends CreationStrategy {
        private Class clz_;

        ClassCreationStrategy(ValueReader valueReader, InputStream inputStream, Class clazz) {
            super(valueReader, inputStream);
            this.clz_ = clazz;
        }

        Serializable create(Header header) {
            Assert.assert(header.tag >= 0x7FFFFF00 && header.tag != -1);
            Serializable serializable = null;
            try {
                serializable = (Serializable)this.clz_.newInstance();
                this.reader_.addInstance(header.headerPos, serializable);
                try {
                    this.reader_.unmarshalValueState(serializable);
                }
                catch (SystemException systemException) {
                    this.reader_.removeInstance(header.headerPos);
                    throw systemException;
                }
                return serializable;
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
            throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": " + this.clz_.getName(), 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static class FactoryCreationStrategy
    extends CreationStrategy {
        private String id_;
        private ORBInstance orbInstance_;

        FactoryCreationStrategy(ValueReader valueReader, InputStream inputStream, String string) {
            super(valueReader, inputStream);
            this.id_ = string;
            this.orbInstance_ = inputStream._OB_ORBInstance();
        }

        private ValueFactory findFactory(Header header, StringHolder stringHolder) {
            ValueFactory valueFactory = null;
            if (this.orbInstance_ != null) {
                ValueFactoryManager valueFactoryManager = this.orbInstance_.getValueFactoryManager();
                if (header.ids.length > 0) {
                    int n = 0;
                    while (n < header.ids.length) {
                        valueFactory = valueFactoryManager.lookupValueFactoryWithClass(header.ids[n]);
                        if (valueFactory != null) {
                            stringHolder.value = header.ids[n];
                            break;
                        }
                        ++n;
                    }
                } else if (this.id_ != null) {
                    valueFactory = valueFactoryManager.lookupValueFactoryWithClass(this.id_);
                    stringHolder.value = this.id_;
                }
            }
            return valueFactory;
        }

        private Serializable createWithFactory(Header header, ValueFactory valueFactory) {
            Serializable serializable;
            try {
                this.reader_.pushHeader(header);
                serializable = valueFactory.read_value(this.is_);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.reader_.popHeader();
                throw throwable;
            }
            this.reader_.popHeader();
            return serializable;
        }

        private BoxedValueHelper getBoxedHelper(String string) {
            Class clazz = Util.idToClass(string, "Helper");
            if (clazz != null) {
                try {
                    return (BoxedValueHelper)clazz.newInstance();
                }
                catch (ClassCastException classCastException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {}
                throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": invalid BoxedValueHelper for " + string, 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return null;
        }

        Serializable create(Header header) {
            StringHolder stringHolder = new StringHolder();
            return this.create(header, stringHolder);
        }

        Serializable create(Header header, StringHolder stringHolder) {
            Assert.assert(header.tag >= 0x7FFFFF00 && header.tag != -1);
            ValueFactory valueFactory = this.findFactory(header, stringHolder);
            if (valueFactory != null) {
                return this.createWithFactory(header, valueFactory);
            }
            BoxedValueHelper boxedValueHelper = null;
            if (header.ids.length > 0 && (boxedValueHelper = this.getBoxedHelper(header.ids[0])) != null) {
                stringHolder.value = header.ids[0];
            }
            if (boxedValueHelper == null && this.id_ != null && (boxedValueHelper = this.getBoxedHelper(this.id_)) != null) {
                stringHolder.value = this.id_;
            }
            if (boxedValueHelper != null) {
                Serializable serializable = boxedValueHelper.read_value(this.is_);
                this.reader_.addInstance(header.headerPos, serializable);
                return serializable;
            }
            String string = "<unknown>";
            if (header.ids.length > 0) {
                string = header.ids[0];
            } else if (this.id_ != null) {
                string = this.id_;
            }
            throw new MARSHAL(String.valueOf(MinorCodes.describeMarshal(1330446337)) + ": " + string, 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }
}

