      SUBROUTINE HYSTA
C--READ IN STATION LIST & COORDINATES FOR HYPOINVERSE
      CHARACTER CXWT*1,CFWT*1,CALT*1,LINE*132
      INCLUDE 'common.inc'

C--GIVE THESE A VALUE IN CASE HYPO71 FORMAT IS USED
      PD1=0.
      PD2=0.
      CXWT=' '
      CFWT=' '

C--ZERO THE DELAYS IN CASE WE HAVE OLD VALUES IN MEMORY
      DO 5 I=1,LM
      DO 5 J=1,MAXSTA
5     JPD(I,J)=0

C--LOOP TO READ STATIONS INTO LOOK-UP TABLE
      DO 20 J=1,MAXSTA
      JSTA=J-1

      READ (14,'(A)',END=30,ERR=40) LINE

C--INITIALIZE NAME CODES THAT MAY NOT BE READ
      STANAM(J)='     '
      JNET(J)='   '
      JCOMP3(J)='   '
      JCOMP1(J)=' '
      JCOMPA(J)='   '
      JSLOC(J)='  '
      JSLOC2(J)='  '

      IF (ISTFMT.EQ.1) THEN
C--OLD HYPOINVERSE FORMAT
        READ (LINE,1000,ERR=40) STANAM(J)(1:4),CTEMP,JLATD(J),
     2  ALAT,IS, JLOND(J),ALON,IE, PER,JCOMP1(J),CALT,STRMK(J),
     3  PD1,PD2, XMC,CXWT,FMC,CFWT, JTYPE(J),CAL, JNET(J),JCOMP3(J),
     4  JSLOC(J)

1000   FORMAT (A4,A1,I2,1X,
     2  F5.2,A1, I3,1X,F5.2,A1,4X, F3.1,A1,1X,2A1,
     3  2(F5.2,1X), 2(F5.2,A1), I1,F6.2,A2,1X,A3,
     4  A2)

        JLMOD(J)=CALT.EQ.'2' .OR. CALT.EQ.'A'
      ELSE IF (ISTFMT.EQ.2) THEN

C--HYPO71 FORMAT
        READ (LINE,1001,ERR=40) JCOMP1(J),CTEMP,STANAM(J)(1:4),
     2  JLATD(J),ALAT,IS, JLOND(J),ALON,IE,
     3  PD1,STRMK(J), FMC,XMC, JTYPE(J),PER,CAL
1001    FORMAT (2A1,A4,
     2  I2,F5.2,A1, I3,F5.2,A1,5X,
     3  F5.2,1X,A1,2X, F5.2,2X,F5.2,1X, I1,1X,F4.2,1X,F6.2)

      ELSE
C--NEW HYPOINVERSE FORMAT
        READ (LINE,1012,ERR=40) STANAM(J),JNET(J),
     4  JCOMP1(J),JCOMP3(J), CTEMP,JLATD(J),
     2  ALAT,IS, JLOND(J),ALON,IE, PER,CALT,STRMK(J),
     3  PD1,PD2, XMC,CXWT,FMC,CFWT, JTYPE(J),CAL,JSLOC(J),JCOMPA(J)

1012    FORMAT (A5,1X,A2,1X,
     4  A1,A3,1X, A1,I2,1X,
     2  F7.4,A1, I3,1X,F7.4,A1,4X, F3.1,2X,2A1,
     3  2(F5.2,1X), 2(F5.2,A1), I1,F6.2,A2,A3)

        JLMOD(J)=CALT.EQ.'2' .OR. CALT.EQ.'A'

      END IF

C--IF WE WILL MATCH ON THE 1-LETTER COMPONENTS, TRANSFER THEM TO THE 3-LETTER
C  ARRAY WHERE TESTING IS DONE
C      IF (LCOMP1) JCOMP3(J)=JCOMP1(J)

C--ASSIGN EQUIVALENT LOCATION CODE: '  ' AND '--' WILL BOTH MATCH
      IF (JSLOC(J).EQ.'  ') THEN
        JSLOC2(J)='--'
      ELSE IF (JSLOC(J).EQ.'--') THEN
        JSLOC2(J)='  '
      ELSE
        JSLOC2(J)=JSLOC(J)
      END IF

C--OPTIONALLY CONVERT ATTENUATIONS TO CAL FACTORS
      IF (LATEN) THEN
        KTEMP2=NINT(CAL)
        KTEMP=KTEMP2/6
C--ATTENUATIONS MUST BE A VALID MULTIPLE OF 6 DB
        IF (KTEMP2-6*KTEMP .EQ. 0 .AND. KTEMP.GT.0 .AND. KTEMP.LT.11)
     2  CAL=CALSV(KTEMP)
      END IF

C--CORRECT VALUES WHICH ARE OUT OF RANGE
      IF (PER.LT..1) PER=.2
      IF (CAL.LT.0.) CAL=0.

C--STORED LAT & LON ARE POSITIVE N & W
C--USE NEG LAT FOR SOUTH, NEG LON FOR EAST
      IF (IS.EQ.'S') THEN
        JLATD(J)=-JLATD(J)
        ALAT=-ALAT
      END IF
      IF (IE.EQ.'E') THEN
        JLOND(J)=-JLOND(J)
        ALON=-ALON
      END IF

C--STORE STATION INFO IN CONDENSED INTEGER FORMAT
C--LAT & LON IN .01 MINUTE, KEPT AS NEAREST INTEGER
      JLATM(J)=NINT(100.*ALAT)
      JLONM(J)=NINT(100.*ALON)

C--STORE STATION WEIGHTS IN UNITS OF 0.1 FROM 0.0 TO 1.0
C--P & S TIME WEIGHTS
      JPSWT(J)=IWT(CTEMP)

C--AMP MAG WEIGHT
      JXWT(J)=IWT(CXWT)
C--ALLOW FOR 0 WEIGHT ASSIGNED BY ADDING 5.0 TO MAG CORRECTION
      IF (XMC.GT.2.45) THEN
        XMC=XMC-5.
        JXWT(J)=0
      END IF

C--DURATION MAGNIUTDE WEIGHT
      JFWT(J)=IWT(CFWT)

C--ADD 10 TO CORRECTION TO GIVE GAIN CORRECTION 0 WEIGHT
C--YOU CAN ADD BOTH 10 AND 5, BUT MUST DO THIS TEST FIRST
      IF (FMC.GT.7.45) THEN
        JFGWT(J)=0
        FMC=FMC-10.
      ELSE
        JFGWT(J)=1
      END IF

C--ALLOW FOR 0 WEIGHT ASSIGNED BY ADDING 5.0 TO MAG CORRECTION
      IF (FMC.GT.2.45) THEN
        FMC=FMC-5.
        JFWT(J)=0
      END IF

C--STORE MAGNITUDE CORRECTIONS
      JXCOR(J)=NINT(XMC*100.)
      JFCOR(J)=NINT(FMC*100.)

C--STORE P DELAYS
      JPD(1,J)=NINT(PD1*100.)
      JPD(2,J)=NINT(PD2*100.)

C--STORE STATION TYPE, CAL FACTOR & PERIOD
      JPER(J)=NINT(PER*10.)
      JCAL(J)=NINT(CAL*1000.)
20    CONTINUE

C--COME HERE IF TOO MANY STATIONS ARE IN FILE
      JSTA=MAXSTA
      WRITE (6,1003) JSTA
1003  FORMAT (' *** TOO MANY STATIONS. THE FIRST',I4,' ARE USED.')
      IRES=-34

C--WRITE NUMBER OF STATIONS READ
30    WRITE (6,'(I6,'' STATIONS READ IN.'')') JSTA
      RETURN

C--COME HERE FOR READ ERROR
40      WRITE (6,1002) LINE(1:79)
1002      FORMAT (' *** ERROR READING STATION FILE AT LINE:'/1X,A)
      IRES=-94
      STOP
      END

      FUNCTION IWT (CHA)
C--USED BY HYSTA TO CONVERT A 1-CHARACTER WEIGHT CODE INTO AN
C  INTEGER THAT REPRESENTS THE NUMERICAL WEIGHT IN TENTHS.
C--TREAT INTEGER WEIGHT CODES AS WEIGHT IN TENTHS (0-9).
C--0 OR * GIVES NO WEIGHT (0).
C--BLANK OR ANY OTHER CHARACTER GIVES FULL WEIGHT (10).

      CHARACTER CHA*1
      L=ICHAR(CHA)
      IF (L.GT.47 .AND. L.LT.58) THEN
        IWT=L-48
      ELSE IF (CHA.EQ.'*') THEN
        IWT=0
      ELSE
        IWT=10
      END IF
      RETURN
      END
