#
# vdl_ew configuration file for CERI, Memphis
# VDL under Earthworm is started by startstop, and given the commandline found in startstop.d
# That's where vdl get's its cusomary command line arguments. The file here is read
# by the "feedme" routines, which determine vdl's identity to earthworm, and what to feed to vdl.
#
 MyModuleId     MOD_VDL_EW   # module id for this export,
 RingName       WAVE_RING      # transport ring to use for input/output,
 HeartBeatInt   10             # Heartbeat interval in seconds (Earthworm internal)
		# feedme() will consider beating the heart each time it's called, but will
		# not beat faster than the interval above
 LogFile        0              # If 0, don't write logfile at all,
 #MaxMsgSize	500	# length of largest message we'll ever handle - in bytes
 MaxMsgSize	4068	# length of largest message we'll ever handle - in bytes
 MaxMessages	800	# limit of number of message to buffer

# List the message logos to grab from transport ring for us to choose from
#  - as to which we will forward to VDL
#              Installation       Module       Message Type
# withers changed message type to tracebuf
 GetMsgLogo    INST_WILDCARD      MOD_WILDCARD     TYPE_TRACEBUF

# List of pin numbers to send to VDL, and the corresponding VDL-USNSN designators
#		Earthworm pin number	USNSN designator
SendSCN SFTN EHZ NM 0
SendSCN PWLA EHZ NM 1
SendSCN QUAR SCZ NM 2
SendSCN CWPT SCZ NM 3
SendSCN RELT SCZ NM 4
SendSCN EBZ  EHZ NM 5
SendSCN GLST SCZ NM 6
SendSCN WADM SCZ NM 7
SendSCN TWAR SCZ NM 8
SendSCN DLAR SCZ NM 9
SendSCN GNAR HHZ NM 10
SendSCN GNAR HHN NM 11
SendSCN GNAR HHE NM 12
#SendSCN SWET HHZ ET 16    # new VDL needed before multiple input rates o.k.
#SendSCN SWET HHN ET 17
#SendSCN SWET HHE ET 18
