#
#   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
#   CHECKED IT OUT USING THE COMMAND CHECKOUT.
#
#    $Id: makefile.sol,v 1.10 2007/08/28 17:42:19 paulf Exp $
#
#    Revision history:
#     $Log: makefile.sol,v $
#     Revision 1.10  2007/08/28 17:42:19  paulf
#     patched code to use common lib instead of all in main file
#
#     Revision 1.9  2007/08/25 16:47:42  paulf
#     added tankcut and tanksniff
#
#     Revision 1.8  2007/05/31 17:24:12  paulf
#     fixed libs for solaris
#
#     Revision 1.7  2007/05/31 17:21:33  paulf
#     added ring2tank
#
#     Revision 1.6  2007/01/02 15:26:45  stefan
#     clean_bin tweak for ms2tb
#
#     Revision 1.5  2006/11/17 17:21:23  ilya
#     Added path to QLIB2 in makefile.sol
#
#     Revision 1.4  2006/08/08 20:53:15  paulf
#     added ms2tb to makefile.sol
#
#     Revision 1.3  2005/10/14 23:06:18  dietz
#     *** empty log message ***
#
#     Revision 1.2  2002/11/03 05:14:38  lombard
#     Cleaned up makefile
#
#
#
#IGD 2006/11/17  Added QLIB2 location required for ms2tb
QLIB_DIR = ../../libsrc/qlib2/

CFLAGS = $(GLOBALFLAGS) -I$(QLIB_DIR)

B = $(EW_HOME)/$(EW_VERSION)/bin
L = $(EW_HOME)/$(EW_VERSION)/lib

LIBS = $L/swap.o $L/time_ew.o $L/logit.o
RTLIBS = $L/transport.o $L/swap.o $L/time_ew.o $L/getutil.o $L/logit.o $L/sleep_ew.o $L/kom.o -lrt


all: remux_tbuf sac2tb ms2tb ring2tank tankcut tanksniff
	make -f makefile.sol remux_tbuf
	make -f makefile.sol sac2tb
	make -f makefile.sol ring2tank
	make -f makefile.sol tanksniff
	make -f makefile.sol tankcut
	make -f makefile.sol ms2tb
	
remux_tbuf: remux_tbuf.o remux_code.o $(LIBS)
	cc -g -o $B/remux_tbuf remux_code.o remux_tbuf.o $L/chron3.o $(LIBS) -lrt
	
sac2tb: sac2tb.o $(LIBS)
	cc -g -o $B/sac2tb sac2tb.o $(LIBS) -lrt

ring2tank: ring2tank.o $(LIBS)
	cc -g -o $B/ring2tank ring2tank.o $(RTLIBS)

ms2tb: ms2tb.o $(LIBS) read_mseed_data.o
	cc -g -o $B/ms2tb ms2tb.o read_mseed_data.o -L$(L) -L$(QLIB_DIR) -lqlib2nl -lm

tanksniff: tanksniff.o $(LIBS)
	cc -g -o $B/tanksniff tanksniff.o $(LIBS) -lrt

tankcut: tankcut.o remux_code.o
	cc -g -o $B/tankcut tankcut.o remux_code.o $L/chron3.o $(RTLIBS) 

.c.o:
	$(CC) $(CFLAGS) $(CPPFLAGS) -c  $(OUTPUT_OPTION) $<

# Clean-up rules
clean:
	rm -f a.out core *.o *.obj *% *~

clean_bin:
	rm -f $B/remux_tbuf* $B/sac2tb* $B/ms2tb* $B/ring2tank $B/tankcut
