/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnsupportedFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISOTime {
    private static final DateFormat[] dateFormats;
    public static final String[] patterns;
    static int[] matches;
    protected MicroSecondDate date;
    protected String orig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISOTime(String s) throws UnsupportedFormat {
        this.orig = s;
        if (s.equals("edu.iris.Fissures/Time/UNKNOWN") || s.equals("25991231235959.0000GMT")) {
            this.date = TimeUtils.future;
        } else {
            String clean = this.cleanDate(s);
            Date d = null;
            for (int i = 0; i < dateFormats.length; ++i) {
                DateFormat dateFormat = dateFormats[i];
                synchronized (dateFormat) {
                    d = dateFormats[i].parse(clean, new ParsePosition(0));
                }
                if (d != null) break;
            }
            if (d == null) {
                throw new UnsupportedFormat(s);
            }
            this.date = new MicroSecondDate(d);
        }
    }

    public ISOTime(int year, int jday, int hour, int minute, float second) {
        this(ISOTime.getISOString(year, jday, hour, minute, second));
    }

    public static String getISOString(int year, int jday, int hour, int minute, float second) {
        DecimalFormat xxFormat = new DecimalFormat("00");
        DecimalFormat xxxFormat = new DecimalFormat("000");
        DecimalFormat floatFormat = new DecimalFormat("00.000#");
        return xxxFormat.format(year) + xxxFormat.format(jday) + "T" + xxFormat.format(hour) + xxFormat.format(minute) + floatFormat.format(second) + "Z";
    }

    protected String cleanDate(String s) {
        int zoneIndex = s.indexOf(90);
        if (zoneIndex == -1 && (zoneIndex = s.indexOf(43)) == -1) {
            zoneIndex = s.indexOf(45, 8);
        }
        if (zoneIndex == -1) {
            zoneIndex = s.length();
        }
        int endIndex = s.lastIndexOf(46) == -1 ? zoneIndex : (zoneIndex - s.lastIndexOf(46) > 3 ? s.lastIndexOf(46) + 4 : zoneIndex);
        String out = s.substring(0, endIndex);
        if (zoneIndex - s.lastIndexOf(46) == 3) {
            out = out + "0";
        } else if (zoneIndex - s.lastIndexOf(46) == 2) {
            out = out + "00";
        } else if (zoneIndex - s.lastIndexOf(46) == 1) {
            out = out + "000";
        }
        if (out.indexOf(84) == 7) {
            out = out.replace('T', 'J');
        }
        if (zoneIndex == s.length()) {
            out = out + "GMT";
        } else if (s.charAt(zoneIndex) == 'Z') {
            out = out + "GMT";
        } else {
            String tzString = s.substring(zoneIndex);
            if (tzString.length() == 3) {
                tzString = tzString + ":00";
            }
            out = out + "GMT" + tzString;
        }
        return out;
    }

    public String getOrigString() {
        return this.orig;
    }

    public Calendar getCalendar() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(this.date);
        return cal;
    }

    public MicroSecondDate getDate() {
        return this.date;
    }

    public static String getISOString(MicroSecondDate ms) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss.SSS");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String s = df.format(ms);
        long micros = ms.getMicroSeconds();
        if (micros != 0L) {
            s = micros < 10L ? s + "00" + micros : (micros < 100L ? (micros % 10L == 0L ? s + "0" + micros % 10L : s + "0" + micros) : (micros % 100L == 0L ? s + micros % 100L : (micros % 10L == 0L ? s + micros % 10L : s + micros)));
        }
        return s + "Z";
    }

    public static String getISOString(Date ms) {
        if (ms instanceof MicroSecondDate) {
            return ISOTime.getISOString((MicroSecondDate)ms);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss.SSSz");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(ms);
    }

    public String toString() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(this.getCalendar().getTime());
    }

    public static void main(String[] args) {
        String[] s = new String[]{"19990101T120030.1111Z", "1999-01-01T000030.1111Z", "19990101T00:00:30.1111Z", "1999-01-01T00:00:30.1111Z", "1999001T00:00:30.1111Z", "1999001T000030.1111Z", "1999-12-21T00:00:30.1234Z", "2048-01-01T16:00:30.1111+01", "1999-01-01T00:59:30.1111+01:30", "1999-01-01T23:59:59.999-01:30", "19990101T120030Z"};
        try {
            for (int i = 0; i < s.length; ++i) {
                ISOTime iso = new ISOTime(s[i]);
                System.out.println(iso + " = " + iso.getOrigString());
            }
            System.out.println(ISOTime.getISOString(1999, 1, 2, 3, 3.456f));
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    static {
        patterns = new String[]{"yyyyDDD'J'HHmmss.SSSz", "yyyyMMddHHmmss.SSSz", "yyyyMMdd'T'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyyDDD'J'HH:mm:ss.SSSz", "yyyyMMdd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyyMMdd HH:mm:ss.SSSz", "yyyyMMdd HHmmss.SSSz", "yyyy-MM-dd HH:mm:ss.SSSz", "yyyy-MM-dd HHmmss.SSSz", "yyyyDDD'J'HH:mm:ssz", "yyyyDDD'J'HHmmssz", "yyyyMMdd'T'HH:mm:ssz", "yyyyMMdd'T'HHmmssz", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HHmmssz", "yyyyMMdd HH:mm:ssz", "yyyyMMdd HHmmssz", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HHmmssz", "yyyyMMddHHmmssz"};
        matches = new int[patterns.length];
        dateFormats = new DateFormat[patterns.length];
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        for (int i = 0; i < patterns.length; ++i) {
            ISOTime.dateFormats[i] = new SimpleDateFormat(patterns[i]);
            dateFormats[i].setTimeZone(gmt);
        }
    }
}

