/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.OB.ORBInstance;
import com.ooc.OBPortableServer.ActiveObjectOnlyStrategy;
import com.ooc.OBPortableServer.DefaultServantHolder;
import com.ooc.OBPortableServer.NonRetainStrategy;
import com.ooc.OBPortableServer.POAPolicies;
import com.ooc.OBPortableServer.RetainStrategy;
import com.ooc.OBPortableServer.ServantActivatorStrategy;
import com.ooc.OBPortableServer.ServantLocationStrategy;
import com.ooc.OBPortableServer.ServantLocatorStrategy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;

class ServantLocationStrategyFactory {
    public static ServantLocationStrategy createServantLocationStrategy(POAPolicies pOAPolicies, ORBInstance oRBInstance) {
        if (pOAPolicies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
            return new ActiveObjectOnlyStrategy(pOAPolicies, oRBInstance);
        }
        ServantLocatorStrategy servantLocatorStrategy = null;
        ServantActivatorStrategy servantActivatorStrategy = null;
        DefaultServantHolder defaultServantHolder = null;
        if (pOAPolicies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            defaultServantHolder = new DefaultServantHolder();
        }
        if (pOAPolicies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
            if (pOAPolicies.servantRetentionPolicy() == ServantRetentionPolicyValue.RETAIN) {
                servantActivatorStrategy = new ServantActivatorStrategy();
            } else {
                servantLocatorStrategy = new ServantLocatorStrategy(oRBInstance);
            }
        }
        if (pOAPolicies.servantRetentionPolicy() == ServantRetentionPolicyValue.RETAIN) {
            return new RetainStrategy(pOAPolicies, oRBInstance, servantActivatorStrategy, defaultServantHolder);
        }
        return new NonRetainStrategy(servantLocatorStrategy, defaultServantHolder);
    }

    ServantLocationStrategyFactory() {
    }
}

