#
# samtac2ew configuration file
#
# This code receives serial data stream (SDS) packets from the SAMTAC-802U via
# a WindowsNT serial port, converts them into Earthworm trace buf messages,
# and stuffs them into a wave ring.
#

ComPort         1               # K2 COM port ID, 1=COM1, 2=COM, etc
Speed           19200           # K2 baud rate

ModuleId        MOD_SAMTAC2EW        # module id for this import
RingName        WAVE_RING       # transport ring to use for input/output

LogFile         1               # If 0, don't output to logfile; if 1, do
                                # if 2, log to module log but not stderr/stdout

HeartbeatInt    30              # Heartbeat interval in seconds

Network         NC              # Network name for EW msg headers

LCFlag 1			# Indicator for action on missing
				# ChannelNames and LocationNames
				# 1: use the default location code and
				#    samtac-configured channel code if none
				#    found in samtac2ew configuration
				# 2: Exit with error if any data channel
				#    is not assigned in ChannelName and 
				#    LocationName commands.

# Optional commands:

BasePinno     1001              # Earthworm pin numbers are assigned by
                                # adding this base number to the stream
                                # number (0 - 5) of each packet
                                # default: 0

# StationID SEAB		# If specified, assign a different station
				# code to the TRACEBUF packets than what
				# is configured into the K2

# ChannelNames	HHE,HHN,HHZ	# If present, assign different channel names
				# to the TRACEBUF packets that the names
				# configured in the K2. The list can be
				# delimited by commas or spaces. See the
				# documentation for details about channel
				# and serial stream numbering conventions!
                                # List only STREAMed channels here, which
                                # may be fewer than the K2 acquires.

# LocationNames 01,01,01	# If present, assign location codes to
				# the TRACEBUF packets emitted by k2ew.
				# Otherwise, default location code
				# will be assigned; currently "--"
                                # List only STREAMed channels here, which
                                # may be fewer than the K2 acquires.

# HeaderFile "..\k2hdr\k2hdr.SEA" # If specified, k2ew will write the K2 binary
                                # header to this file.  The file is created at
                                # program startup and once per day thereafter.
                                # default: none

# RestartFile   "restart.SEA"   # If you want to attempt a K2 restart, give
                                # a name for the restart file. It MUST be
                                # a unique name for this K2 or gross confusion
                                # will result!
                                # default: none

MaxRestartAge    60             # Maximum age of the restart file, in seconds
                                # If the restart file is older than this
                                # when k2ew restarts, a normal start will
                                # be used
                                # Should be less than WaitTime (above)
                                # default: 0 (seconds)

CommTimeout   5000              # If unable to communicate with K2 for X
                                # milliseconds, retry comm port or terminate
                                # default: 5000 (milliseconds)

# DontQuit                      # Optional command; if present, k2ew will
                                # not quit on timeouts. K2ew will quit on
                                # errors in any event.

# RestartComm			# This command is pertinent only when the
				# 'DontQuit' command is present. In this case,
				# when 'k2ew' detects a timeout condition (and
				# 'RestartComm' is set), the communications link
				# to the K2 will be closed and reopened before
				# 'k2ew' resumes reading data.   

ExtStatus                       # Request extended status with normal status
                                # Comment this out for no extended status
                                # default: no extended status

Debug 0                         # debug level: 0 or commented out for no debug
                                # logging; 1 - 4 for increasing verbosity
                                # default: 0 (no debug output)
