/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.Downcall;
import com.ooc.OB.GIOPClient;
import com.ooc.OB.GIOPClientWorker;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.Transport;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

final class GIOPClientWorkerThreaded
extends GIOPClientWorker {
    protected Thread senderThread_;
    protected Thread receiverThread_;

    protected void addUnsent(Buffer buffer) {
        super.addUnsent(buffer);
        this.notifyAll();
    }

    protected void addUnsent(Downcall downcall) {
        downcall.initStateMonitor();
        super.addUnsent(downcall);
        this.notifyAll();
    }

    protected Downcall findAndRemovePending(int n) {
        Object object;
        while (!this.unsent_.isEmpty()) {
            object = (GIOPClientWorker.UnsentMessage)this.unsent_.firstElement();
            if (((GIOPClientWorker.UnsentMessage)object).down == null || ((GIOPClientWorker.UnsentMessage)object).down.requestId() != n) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = super.findAndRemovePending(n);
        if (this.acmTimeout_ > 0 && this.unsent_.isEmpty() && this.pending_.isEmpty()) {
            this.notifyAll();
        }
        return object;
    }

    protected boolean exception(int n, SystemException systemException, boolean bl) {
        if (!super.exception(n, systemException, bl)) {
            return false;
        }
        this.notifyAll();
        return true;
    }

    GIOPClientWorkerThreaded(ORBInstance oRBInstance, GIOPClient gIOPClient, Transport transport, int n) {
        super(oRBInstance, gIOPClient, transport, n);
        try {
            ThreadGroup threadGroup = this.orbInstance_.getClientWorkerGroup();
            this.senderThread_ = new SenderThread(threadGroup, this);
            this.senderThread_.start();
            this.receiverThread_ = new ReceiverThread(threadGroup, this);
            this.receiverThread_.start();
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.transport_.close();
            this.state_ = 4;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    synchronized void destroy() {
        this.exception(1, new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO));
    }

    public boolean send(Downcall downcall, boolean bl) {
        GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
        synchronized (gIOPClientWorkerThreaded) {
            this.addUnsent(downcall);
        }
        try {
            return downcall.waitUntilSent(bl);
        }
        catch (SystemException systemException) {
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded2 = this;
            synchronized (gIOPClientWorkerThreaded2) {
                this.exception(4, systemException);
                boolean bl2 = true;
                Object var6_7 = null;
                return bl2;
            }
        }
    }

    public boolean receive(Downcall downcall, boolean bl) {
        try {
            return downcall.waitUntilCompleted(bl);
        }
        catch (SystemException systemException) {
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                this.exception(4, systemException);
                boolean bl2 = true;
                Object var6_6 = null;
                return bl2;
            }
        }
    }

    public boolean sendReceive(Downcall downcall) {
        GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
        synchronized (gIOPClientWorkerThreaded) {
            this.addUnsent(downcall);
        }
        return this.receive(downcall, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void senderRun() {
        boolean bl = true;
        while (true) {
            Buffer buffer;
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                if (!bl) {
                    this.moveFirstUnsentToPending();
                    this.notifyAll();
                } else {
                    bl = false;
                }
                while (true) {
                    long l;
                    if (this.state_ == 4) {
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 1) {
                        this.logCloseConnection();
                        this.transport_.shutdown();
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 2) {
                        this.exception(4, new TRANSIENT(MinorCodes.describeTransient(0x4F4F0004), 0x4F4F0004, CompletionStatus.COMPLETED_MAYBE));
                        return;
                    }
                    if (!this.unsent_.isEmpty()) {
                        GIOPClientWorker.UnsentMessage unsentMessage = (GIOPClientWorker.UnsentMessage)this.unsent_.firstElement();
                        buffer = unsentMessage.buf;
                        break;
                    }
                    if (this.acmTimeout_ > 0 && this.unsent_.isEmpty() && this.pending_.isEmpty() && (l = System.currentTimeMillis() / 1000L) >= this.timestamp_ + (long)this.acmTimeout_) {
                        this.exception(1, new TRANSIENT(MinorCodes.describeTransient(1330577411), 1330577411, CompletionStatus.COMPLETED_MAYBE));
                        continue;
                    }
                    try {
                        if (this.acmTimeout_ > 0 && this.unsent_.isEmpty() && this.pending_.isEmpty()) {
                            this.wait(this.acmTimeout_ * 1000);
                            continue;
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.transport_.send(buffer, true);
                Assert.assert(buffer.is_full());
            }
            catch (SystemException systemException) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded2 = this;
                synchronized (gIOPClientWorkerThreaded2) {
                    this.exception(4, systemException);
                    return;
                }
            }
        }
    }

    public void receiverRun() {
        while (true) {
            Assert.assert(this.buf_ == null);
            this.buf_ = new Buffer(12);
            try {
                this.transport_.receive(this.buf_, true);
                Assert.assert(this.buf_.is_full());
            }
            catch (SystemException systemException) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(4, systemException);
                    Object var3_10 = null;
                    return;
                }
            }
            try {
                this.incoming_.extractHeader(this.buf_);
                this.buf_.realloc(12 + this.incoming_.size());
            }
            catch (SystemException systemException) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(2, systemException);
                    Object var3_11 = null;
                    return;
                }
            }
            if (!this.buf_.is_full()) {
                try {
                    this.transport_.receive(this.buf_, true);
                    Assert.assert(this.buf_.is_full());
                }
                catch (SystemException systemException) {
                    GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                    synchronized (gIOPClientWorkerThreaded) {
                        this.exception(4, systemException);
                        Object var3_12 = null;
                        return;
                    }
                }
            }
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                if (this.state_ != 0 && this.state_ != 1) {
                    Object var2_9 = null;
                    return;
                }
                this.execute();
            }
        }
    }

    protected static final class SenderThread
    extends Thread {
        private GIOPClientWorkerThreaded worker_;

        SenderThread(ThreadGroup threadGroup, GIOPClientWorkerThreaded gIOPClientWorkerThreaded) {
            super(threadGroup, "ORBacus:Client:SenderThread");
            this.worker_ = gIOPClientWorkerThreaded;
        }

        public void run() {
            try {
                this.worker_.senderRun();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                Assert.assert(false);
            }
            while (true) {
                try {
                    if (this.worker_.shutdownTimeout_ > 0) {
                        this.worker_.receiverThread_.join(this.worker_.shutdownTimeout_ * 1000);
                        break;
                    }
                    this.worker_.receiverThread_.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this.worker_;
            synchronized (gIOPClientWorkerThreaded) {
                this.worker_.exception(4, new TRANSIENT(MinorCodes.describeTransient(0x4F4F0004), 0x4F4F0004, CompletionStatus.COMPLETED_MAYBE));
            }
            this.worker_ = null;
        }
    }

    protected static final class ReceiverThread
    extends Thread {
        private GIOPClientWorkerThreaded worker_;

        ReceiverThread(ThreadGroup threadGroup, GIOPClientWorkerThreaded gIOPClientWorkerThreaded) {
            super(threadGroup, "ORBacus:Client:ReceiverThread");
            this.worker_ = gIOPClientWorkerThreaded;
        }

        public void run() {
            try {
                this.worker_.receiverRun();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                Assert.assert(false);
            }
            this.worker_ = null;
        }
    }
}

