# Create an Earthworm environment on MacOSX?!
# This file should be sourced by a bourne shell wanting 
# to run or build an EARTHWORM system under Linux.

# Set environment variables describing your Earthworm directory/version
export EW_HOME=/Users/earthworm
export EW_VERSION=v7.3
export SYS_NAME=`hostname`

# Set environment variables used by earthworm modules at run-time
# Path names must end with the slash "/"
export EW_INSTALLATION=INST_CIT
export EW_PARAMS=${EW_HOME}/run/params/
export EW_LOG=${EW_HOME}/run/logs/

#
# Database (Oracle) related environment
#

# not used in linux build
#export SCHEMA_DIR=${EW_HOME}/${EW_VERSION}/src/oracle/schema-working
#export APPS_DIR=${EW_HOME}/${EW_VERSION}/src/oracle/apps
#export WEB_DOC_DIR=${EW_HOME}/${EW_VERSION}/WEB_DOC/DBMS/API-DOC

#
# Web server related environment
#
export WEB_DIR=${EW_HOME}/web

# Tack the earthworm bin directory in front of the current path
# Also add Oracle paths to the current path.
#set path=( ${EW_HOME}/${EW_VERSION}/bin /opt/oracle/bin /var/opt/oracle $path )
export PATH=${EW_HOME}/$EW_VERSION/bin:$PATH

# Set up library path for dynamically loaded libraries:
#export OPENWINHOME   /usr/openwin
#export ORACLE_HOME   /opt/oracle
#export COMPILER_DIR /opt/SUNWspro
#export LD_LIBRARY_PATH="${OPENWINHOME}/lib:${ORACLE_HOME}/lib:${COMPILER_DIR}/lib:/usr/lib"

# Set environment variables for compiling earthworm modules
#export GLOBALFLAGS="-Dlinux -D__i386 -D_LINUX -D_INTEL -D_USE_SCHED  -D_USE_PTHREADS -D_USE_TERMIOS -I${EW_HOME}/${EW_VERSION}/include"
export GLOBALFLAGS="-D_MACOSX -D_INTEL -D_USE_PTHREADS -D_USE_SCHED -I${EW_HOME}/${EW_VERSION}/include"

# for intel Mac OS X I only found gfortran to work on 10.4.X with they hyp2000 modules, get it from http://hpc.sourceforge.net
export FC=gfortran
# the flag below is not needed with gfortran
#export FLFLAGS=-lSystemStubs
#
# Note I (Paul Friberg) got this hyp2000 and hyp2000_mgr to work using this version 
# $ gfortran -v
#Using built-in specs.
#Target: i386-apple-darwin8.10.1
#Configured with: /tmp/gfortran-20071231/ibin/../gcc/configure --prefix=/usr/local/gfortran --enable-languages=c,fortran --with-gmp=/tmp/gfortran-20071231/gfortran_libs --enable-bootstrap
#Thread model: posix
#gcc version 4.3.0 20071231 (experimental) [trunk revision 131236] (GCC) 


export CFLAGS=$GLOBALFLAGS
export KEEP_STATE=""
