/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.Utility;

public class Steim2 {
    public static int[] decode(byte[] b, int numSamples, boolean swapBytes, int bias) throws SteimException {
        if (b.length % 64 != 0) {
            throw new SteimException("encoded data length is not multiple of 64 bytes (" + b.length + ")");
        }
        int[] samples = new int[numSamples];
        int numFrames = b.length / 64;
        int current = 0;
        int start = 0;
        int end = 0;
        int firstData = 0;
        int lastValue = 0;
        for (int i = 0; i < numFrames; ++i) {
            int[] tempSamples = Steim2.extractSamples(b, i * 64, swapBytes);
            firstData = 0;
            if (i == 0) {
                lastValue = bias;
                start = tempSamples[1];
                end = tempSamples[2];
                firstData = 3;
                if (bias == 0) {
                    lastValue = start - tempSamples[3];
                }
            }
            for (int j = firstData; j < tempSamples.length && current < numSamples; ++current, ++j) {
                samples[current] = lastValue + tempSamples[j];
                lastValue = samples[current];
            }
        }
        if (current != numSamples) {
            throw new SteimException("Number of samples decompressed doesn't match number in header: " + current + " != " + numSamples);
        }
        return samples;
    }

    public static int[] decode(byte[] b, int numSamples, boolean swapBytes) throws SteimException {
        return Steim2.decode(b, numSamples, swapBytes, 0);
    }

    public static byte[] encode(int[] samples) {
        byte[] b = new byte[]{};
        return b;
    }

    protected static int[] extractSamples(byte[] bytes, int offset, boolean swapBytes) {
        int nibbles = Utility.bytesToInt(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], swapBytes);
        int currNibble = 0;
        int dnib = 0;
        int[] temp = new int[106];
        int currNum = 0;
        block16: for (int i = 0; i < 16; ++i) {
            currNibble = nibbles >> 30 - i * 2 & 3;
            switch (currNibble) {
                case 0: {
                    if (offset != 0) continue block16;
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    continue block16;
                }
                case 1: {
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4]);
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4 + 1]);
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4 + 2]);
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4 + 3]);
                    continue block16;
                }
                case 2: {
                    int tempInt = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    dnib = tempInt >> 30 & 3;
                    switch (dnib) {
                        case 1: {
                            temp[currNum++] = tempInt << 2 >> 2;
                            continue block16;
                        }
                        case 2: {
                            temp[currNum++] = tempInt << 2 >> 17;
                            temp[currNum++] = tempInt << 17 >> 17;
                            continue block16;
                        }
                        case 3: {
                            temp[currNum++] = tempInt << 2 >> 22;
                            temp[currNum++] = tempInt << 12 >> 22;
                            temp[currNum++] = tempInt << 22 >> 22;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 3: {
                    int tempInt = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    dnib = tempInt >> 30 & 3;
                    int diffCount = 0;
                    int bitSize = 0;
                    int headerSize = 0;
                    switch (dnib) {
                        case 0: {
                            headerSize = 2;
                            diffCount = 5;
                            bitSize = 6;
                            break;
                        }
                        case 1: {
                            headerSize = 2;
                            diffCount = 6;
                            bitSize = 5;
                            break;
                        }
                        case 2: {
                            headerSize = 4;
                            diffCount = 7;
                            bitSize = 4;
                            break;
                        }
                    }
                    if (diffCount <= 0) continue block16;
                    for (int d = 0; d < diffCount; ++d) {
                        temp[currNum++] = tempInt << headerSize + d * bitSize >> (diffCount - 1) * bitSize + headerSize;
                    }
                    continue block16;
                }
            }
        }
        int[] out = new int[currNum];
        System.arraycopy(temp, 0, out, 0, currNum);
        return out;
    }

    public static void main(String[] args) throws SteimException {
        byte[] b = new byte[64];
        for (int i = 0; i < 64; ++i) {
            b[i] = 0;
        }
        b[0] = 1;
        b[1] = -80;
        System.out.println(b[1]);
        b[2] = -1;
        b[3] = -1;
        b[4] = 0;
        b[5] = 0;
        b[6] = 0;
        b[7] = 0;
        b[8] = 0;
        b[9] = 0;
        b[10] = 0;
        b[11] = 0;
        b[12] = 1;
        b[13] = 2;
        b[14] = 3;
        b[15] = 0;
        b[16] = 1;
        b[17] = 1;
        b[18] = 0;
        b[19] = 0;
        b[20] = 0;
        b[21] = 1;
        b[22] = 0;
        b[23] = 0;
        int[] temp = Steim2.decode(b, 17, false);
    }
}

