/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.DispatchRequest;
import java.util.Vector;
import org.omg.CORBA.OBJ_ADAPTER;

final class ThreadPool {
    private boolean destroy_ = false;
    private Vector requests_ = new Vector();
    private ThreadGroup group_;

    public ThreadPool(int n, int n2) {
        this.group_ = new ThreadGroup("ThreadPool-" + n);
        int n3 = 0;
        while (n3 < n2) {
            Dispatcher dispatcher = new Dispatcher(this.group_, this, n, n3);
            dispatcher.start();
            ++n3;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.destroy_) {
            throw new InternalError();
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void destroy() {
        Object object = this;
        synchronized (object) {
            if (this.destroy_) {
                return;
            }
            this.destroy_ = true;
            this.notifyAll();
        }
        object = this.group_;
        synchronized (object) {
            while (true) {
                if (this.group_.activeCount() <= 0) {
                    try {
                        this.group_.destroy();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        Assert.assert(false);
                    }
                    break;
                }
                try {
                    this.group_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    synchronized void add(DispatchRequest dispatchRequest) {
        if (this.destroy_) {
            throw new OBJ_ADAPTER("Thread pool is destroyed");
        }
        this.requests_.addElement(dispatchRequest);
        this.notify();
    }

    private synchronized DispatchRequest get() {
        while (!this.destroy_ && this.requests_.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        DispatchRequest dispatchRequest = null;
        if (!this.destroy_) {
            dispatchRequest = (DispatchRequest)this.requests_.firstElement();
            this.requests_.removeElementAt(0);
        }
        return dispatchRequest;
    }

    private class Dispatcher
    extends Thread {
        private ThreadPool threadPool_;

        Dispatcher(ThreadGroup threadGroup, ThreadPool threadPool2, int n, int n2) {
            super(threadGroup, "ORBacus:ThreadPool-" + n + ":Dispatcher-" + n2);
            ThreadPool.this = ThreadPool.this;
            this.threadPool_ = threadPool2;
        }

        public void run() {
            DispatchRequest dispatchRequest;
            while ((dispatchRequest = this.threadPool_.get()) != null) {
                dispatchRequest.invoke();
            }
            return;
        }
    }
}

