/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.CharMapDatabaseInit;
import com.ooc.OB.CharMapInfo;
import com.ooc.OB.CodeConverter;
import com.ooc.OB.CodeConverterBase;
import com.ooc.OB.CodeSetDatabaseInit;
import com.ooc.OB.CodeSetInfo;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.LocalCodeConverter;
import java.util.Locale;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CORBA.CODESET_INCOMPATIBLE;

public final class CodeSetDatabase {
    public static final int ISOLATIN1 = 65537;
    public static final int ISOLATIN2 = 65538;
    public static final int ISOLATIN3 = 65539;
    public static final int ISOLATIN4 = 65540;
    public static final int ISOLATIN5 = 65541;
    public static final int ISOLATIN7 = 65543;
    public static final int ISOLATIN9 = 65545;
    public static final int PCS = 65568;
    public static final int UTF8 = 0x5010001;
    public static final int UTF16 = 65801;
    public static final int UCS2 = 65792;
    private Vector codeConverters_ = new Vector();
    private static CodeSetDatabase instance_;
    private static CharMapDatabaseInit database_;

    protected void finalize() throws Throwable {
        this.codeConverters_ = null;
        super.finalize();
    }

    public static CodeSetDatabase instance() {
        if (instance_ == null) {
            instance_ = new CodeSetDatabase();
            String string = Locale.getDefault().getLanguage();
            if (string.equals("C") || string.equals("POSIX")) {
                CodeSetUtil.addCharCodeSet(65537);
            } else {
                String string2 = string.substring(0, 2);
                if (string2.equals("de") || string2.equals("en") || string2.equals("fr") || string2.equals("nl") || string2.equals("pt")) {
                    CodeSetUtil.addCharCodeSet(65537);
                } else if (string2.equals("da") || string2.equals("fi") || string2.equals("is") || string2.equals("no") || string2.equals("sv")) {
                    CodeSetUtil.addCharCodeSet(65540);
                } else if (string2.equals("it")) {
                    CodeSetUtil.addCharCodeSet(65539);
                } else if (string2.equals("cs") || string2.equals("hu") || string2.equals("pl") || string2.equals("sk")) {
                    CodeSetUtil.addCharCodeSet(65538);
                } else if (string2.equals("el")) {
                    CodeSetUtil.addCharCodeSet(65543);
                } else if (string2.equals("ru")) {
                    CodeSetUtil.addCharCodeSet(65541);
                } else if (string2.equals("tr")) {
                    CodeSetUtil.addCharCodeSet(65545);
                }
            }
            CodeSetUtil.addCharCodeSet(65568);
            CodeSetUtil.addWcharCodeSet(65801);
            CodeSetUtil.addWcharCodeSet(65792);
        }
        return instance_;
    }

    public synchronized CodeConverterBase getConverter(int n, int n2) {
        CodeConverterBase codeConverterBase;
        Object object;
        if (n == 0 || n2 == 0) {
            return null;
        }
        if (n == n2) {
            object = this.getCodeSetInfo(n);
            if (((CodeSetInfo)object).max_bytes == 1) {
                return LocalCodeConverter.instanceChar();
            }
        }
        object = this.codeConverters_.elements();
        while (object.hasMoreElements()) {
            codeConverterBase = (CodeConverterBase)object.nextElement();
            if (codeConverterBase.getTo().rgy_value != n || codeConverterBase.getFrom().rgy_value != n2) continue;
            return codeConverterBase;
        }
        codeConverterBase = new CodeConverter(this.getCodeSetInfo(n2), this.getCodeSetInfo(n));
        this.codeConverters_.addElement(codeConverterBase);
        return codeConverterBase;
    }

    public CodeSetInfo getCodeSetInfo(int n) {
        int n2 = 0;
        while (n2 < CodeSetDatabaseInit.codeSetInfoArraySize_) {
            if (CodeSetDatabaseInit.codeSetInfoArray_[n2].rgy_value == n) {
                return CodeSetDatabaseInit.codeSetInfoArray_[n2];
            }
            ++n2;
        }
        return null;
    }

    int determineTCS(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2, int n) {
        if (codeSetComponent.native_code_set == 0 || codeSetComponent2.native_code_set == 0) {
            return 0;
        }
        if (codeSetComponent.native_code_set == codeSetComponent2.native_code_set) {
            return codeSetComponent2.native_code_set;
        }
        if (this.checkCodeSetId(codeSetComponent, codeSetComponent2.native_code_set)) {
            return codeSetComponent2.native_code_set;
        }
        if (this.checkCodeSetId(codeSetComponent2, codeSetComponent.native_code_set)) {
            return codeSetComponent.native_code_set;
        }
        int n2 = 0;
        while (n2 < codeSetComponent2.conversion_code_sets.length) {
            if (this.checkCodeSetId(codeSetComponent, codeSetComponent2.conversion_code_sets[n2])) {
                return codeSetComponent2.conversion_code_sets[n2];
            }
            ++n2;
        }
        if (this.isCompatible(codeSetComponent.native_code_set, codeSetComponent2.native_code_set)) {
            return n;
        }
        throw new CODESET_INCOMPATIBLE();
    }

    boolean isCompatible(int n, int n2) {
        CodeSetInfo codeSetInfo = this.getCodeSetInfo(n);
        CodeSetInfo codeSetInfo2 = this.getCodeSetInfo(n2);
        if (codeSetInfo == null || codeSetInfo2 == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < codeSetInfo.char_values_size) {
            int n4 = 0;
            while (n4 < codeSetInfo2.char_values_size) {
                if (codeSetInfo.char_values[n3] == codeSetInfo2.char_values[n4]) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }

    boolean checkCodeSetId(CodeSetComponent codeSetComponent, int n) {
        int n2 = 0;
        while (n2 < codeSetComponent.conversion_code_sets.length) {
            if (codeSetComponent.conversion_code_sets[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int nameToId(String string) {
        Assert.assert(string != null);
        int n = 0;
        while (n < CodeSetDatabaseInit.codeSetInfoArraySize_) {
            String string2 = CodeSetDatabaseInit.codeSetInfoArray_[n].description;
            if (string2.indexOf(string) != -1) {
                return CodeSetDatabaseInit.codeSetInfoArray_[n].rgy_value;
            }
            ++n;
        }
        return 0;
    }

    public String idToName(int n) {
        int n2 = 0;
        while (n2 < CodeSetDatabaseInit.codeSetInfoArraySize_) {
            if (CodeSetDatabaseInit.codeSetInfoArray_[n2].rgy_value == n) {
                return CodeSetDatabaseInit.codeSetInfoArray_[n2].description;
            }
            ++n2;
        }
        return null;
    }

    CharMapInfo getCharMapInfo(CodeSetInfo codeSetInfo) {
        String string = "";
        switch (codeSetInfo.rgy_value) {
            case 65537: {
                string = "ISO 8859-1 (1987) to Unicode";
                break;
            }
            case 65538: {
                string = "ISO 8859-2 (1987) to Unicode";
                break;
            }
            case 65539: {
                string = "ISO 8859-3 (1988) to Unicode";
                break;
            }
            case 65540: {
                string = "ISO 8859-4 (1988) to Unicode";
                break;
            }
            case 65541: {
                string = "ISO 8859-5 (1988) to Unicode";
                break;
            }
            case 65543: {
                string = "ISO 8859-7 (1987) to Unicode";
                break;
            }
            case 65545: {
                string = "ISO 8859-9 (1989) to Unicode";
                break;
            }
            case 65568: {
                string = "PCS to Unicode";
                break;
            }
        }
        int n = 0;
        while (n < CharMapDatabaseInit.charMapInfoArraySize_) {
            if (CharMapDatabaseInit.charMapInfoArray_[n].name.equals(string)) {
                return CharMapDatabaseInit.charMapInfoArray_[n];
            }
            ++n;
        }
        return null;
    }

    static {
        database_ = new CharMapDatabaseInit();
    }
}

