/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.ClientManager;
import com.ooc.OB.DispatchStrategyFactory;
import com.ooc.OB.DispatchStrategyFactory_impl;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.Logger;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerFactory;
import com.ooc.OBPortableServer.POAManagerFactoryHelper;
import com.ooc.OBPortableServer.POAManagerFactoryPackage.POAManagerAlreadyExists;
import com.ooc.OBPortableServer.POAManagerFactory_impl;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OCI.InvalidParam;
import com.ooc.PortableServer.Current_impl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;

public final class ORBControl {
    ORBInstance orbInstance_;
    private static final int StateNotRunning = 0;
    private static final int StateRunning = 1;
    private static final int StateServerShutdown = 2;
    private static final int StateClientShutdown = 3;
    private static final int StateDestroyed = 4;
    private int state_ = 0;
    private boolean shutdown_ = false;
    private java.lang.Object shutdownCond_ = new java.lang.Object();
    private POA rootPOA_;
    private Thread mainThread_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void completeServerShutdown() {
        ThreadGroup threadGroup;
        if (!this.shutdown_ || this.state_ == 2) {
            return;
        }
        Assert.assert(this.state_ != 3 && this.state_ != 4);
        Assert.assert(this.state_ == 0 || this.mainThread_ == Thread.currentThread());
        POAManagerFactory pOAManagerFactory = this.orbInstance_.getPOAManagerFactory();
        POAManagerFactory_impl pOAManagerFactory_impl = (POAManagerFactory_impl)pOAManagerFactory;
        pOAManagerFactory_impl._OB_deactivate();
        ThreadGroup threadGroup2 = threadGroup = this.orbInstance_.getServerWorkerGroup();
        synchronized (threadGroup2) {
            while (true) {
                if (threadGroup.activeCount() <= 0) {
                    DispatchStrategyFactory dispatchStrategyFactory = this.orbInstance_.getDispatchStrategyFactory();
                    DispatchStrategyFactory_impl dispatchStrategyFactory_impl = (DispatchStrategyFactory_impl)dispatchStrategyFactory;
                    dispatchStrategyFactory_impl._OB_destroy();
                    this.state_ = 2;
                    if (this.rootPOA_ != null) {
                        this.rootPOA_.destroy(true, true);
                        this.rootPOA_ = null;
                    }
                    this.notifyAll();
                    return;
                }
                try {
                    threadGroup.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private synchronized void validateState() {
        if (this.state_ == 4) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 2 || this.state_ == 3) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 0) {
            this.mainThread_ = Thread.currentThread();
            this.state_ = 1;
        }
    }

    private synchronized void blockServerShutdownComplete() {
        while (this.state_ == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void destroy() {
        Assert.assert(this.state_ == 3);
        this.state_ = 4;
        this.orbInstance_ = null;
    }

    public void setORBInstance(ORBInstance oRBInstance) {
        this.orbInstance_ = oRBInstance;
    }

    public boolean workPending() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            return false;
        }
        return this.shutdown_;
    }

    public void performWork() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            return;
        }
        this.completeServerShutdown();
    }

    public void run() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            this.blockServerShutdownComplete();
            return;
        }
        do {
            java.lang.Object object = this.shutdownCond_;
            synchronized (object) {
                try {
                    this.shutdownCond_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.completeServerShutdown();
        } while (this.state_ == 1);
    }

    public void shutdownServer(boolean bl) {
        if (this.state_ == 4) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 2 || this.state_ == 3) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        if (bl) {
            boolean bl2 = false;
            try {
                InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
                Object object = initialServiceManager.resolveInitialReferences("POACurrent");
                Current_impl current_impl = (Current_impl)object;
                bl2 = current_impl._OB_inUpcall();
            }
            catch (ClassCastException classCastException) {
            }
            catch (InvalidName invalidName) {}
            if (bl2) {
                throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446339), 1330446339, CompletionStatus.COMPLETED_NO);
            }
        }
        this.shutdown_ = true;
        java.lang.Object object = this.shutdownCond_;
        synchronized (object) {
            this.shutdownCond_.notifyAll();
        }
        if (!bl) {
            return;
        }
        if (this.state_ == 1 && this.mainThread_ != Thread.currentThread()) {
            this.blockServerShutdownComplete();
            return;
        }
        this.completeServerShutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void shutdownServerClient() {
        ThreadGroup threadGroup;
        if (this.state_ == 4) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 3) {
            return;
        }
        if (this.state_ != 2) {
            this.shutdownServer(true);
        }
        Assert.assert(this.state_ == 2);
        ClientManager clientManager = this.orbInstance_.getClientManager();
        clientManager.destroy();
        ThreadGroup threadGroup2 = threadGroup = this.orbInstance_.getClientWorkerGroup();
        synchronized (threadGroup2) {
            while (threadGroup.activeCount() > 0) {
                try {
                    threadGroup.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.state_ = 3;
        this.notifyAll();
    }

    public void initializeRootPOA(String string) {
        String string2;
        if (string == null) {
            string2 = "_RootPOA";
        } else {
            Assert.assert(string.length() > 0);
            string2 = string;
        }
        InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
        POAManagerFactory pOAManagerFactory = null;
        try {
            pOAManagerFactory = POAManagerFactoryHelper.narrow(initialServiceManager.resolveInitialReferences("POAManagerFactory"));
        }
        catch (InvalidName invalidName) {
            Assert.assert(false);
        }
        POAManager pOAManager = null;
        POAManager[] pOAManagerArray = pOAManagerFactory.get_poa_managers();
        int n = 0;
        while (n < pOAManagerArray.length) {
            if (pOAManagerArray[n].name().equals("RootPOAManager")) {
                pOAManager = pOAManagerArray[n];
                break;
            }
            ++n;
        }
        if (pOAManager == null) {
            try {
                pOAManager = pOAManagerFactory.create_poa_manager("RootPOAManager");
            }
            catch (POAManagerAlreadyExists pOAManagerAlreadyExists) {
                Assert.assert(false);
            }
            catch (InvalidParam invalidParam) {
                Logger logger = this.orbInstance_.getLogger();
                String string3 = "invalid configuration parameter `" + invalidParam.p.name + "' for RootPOAManager: " + invalidParam.reason;
                logger.error(string3);
                throw new INITIALIZE(string3);
            }
        }
        POA_impl pOA_impl = new POA_impl(this.orbInstance_, string2, pOAManager);
        pOA_impl._OB_addPolicyFactory();
        this.rootPOA_ = pOA_impl;
        try {
            initialServiceManager.addInitialReference("RootPOA", pOA_impl, true);
        }
        catch (InvalidName invalidName) {
            Assert.assert(false);
        }
        POAManagerFactory_impl pOAManagerFactory_impl = (POAManagerFactory_impl)pOAManagerFactory;
        pOAManagerFactory_impl._OB_initializeIMR(pOA_impl, this);
    }
}

